/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.histogram;

import ddtrot.com.datadoghq.sketch.ddsketch.DDSketch;
import ddtrot.com.datadoghq.sketch.ddsketch.mapping.BitwiseLinearlyInterpolatedMapping;
import ddtrot.com.datadoghq.sketch.ddsketch.store.CollapsingLowestDenseStore;
import ddtrot.dd.trace.core.histogram.Histogram;
import java.nio.ByteBuffer;

public final class DDSketchHistogram
implements Histogram {
    private final DDSketch sketch;

    public DDSketchHistogram() {
        this(new DDSketch(new BitwiseLinearlyInterpolatedMapping(0.0078125), () -> new CollapsingLowestDenseStore(1024)));
    }

    public DDSketchHistogram(DDSketch sketch) {
        this.sketch = sketch;
    }

    @Override
    public void accept(long value) {
        this.sketch.accept(value);
    }

    @Override
    public void accept(double value) {
        this.sketch.accept(value);
    }

    @Override
    public double valueAtQuantile(double quantile) {
        if (this.sketch.isEmpty()) {
            return 0.0;
        }
        return this.sketch.getValueAtQuantile(quantile);
    }

    @Override
    public double max() {
        if (this.sketch.isEmpty()) {
            return 0.0;
        }
        return this.sketch.getMaxValue();
    }

    @Override
    public void clear() {
        this.sketch.clear();
    }

    @Override
    public ByteBuffer serialize() {
        return this.sketch.serialize();
    }
}

