/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.LogHandler;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogHandler
implements LogHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogHandler.class);

    @Override
    public void log(Map<String, ?> fields, AgentSpan span) {
        this.extractError(fields, span);
    }

    @Override
    public void log(long timestampMicroseconds, Map<String, ?> fields, AgentSpan span) {
        this.extractError(fields, span);
    }

    @Override
    public void log(String event, AgentSpan span) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)event);
    }

    @Override
    public void log(long timestampMicroseconds, String event, AgentSpan span) {
        log.debug("`log` method is not implemented. Provided log: {}", (Object)event);
    }

    private boolean isErrorSpan(Map<String, ?> map, AgentSpan span) {
        String event = map.get("event") instanceof String ? (String)map.get("event") : "";
        return span.isError() || event.equalsIgnoreCase("error");
    }

    private void extractError(Map<String, ?> map, AgentSpan span) {
        if (map.get("error.object") instanceof Throwable) {
            Throwable error = (Throwable)map.get("error.object");
            span.addThrowable(error);
        } else if (this.isErrorSpan(map, span) && map.get("message") instanceof String) {
            span.setTag("error.msg", (String)map.get("message"));
        }
    }
}

