/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch.encoding;

import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Input;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;

public final class ByteArrayInput
implements Input {
    private final byte[] array;
    private final int endPos;
    private int pos;

    private ByteArrayInput(byte[] array, int offset, int length) {
        Objects.requireNonNull(array);
        if (offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        this.array = array;
        this.endPos = offset + length;
        this.pos = offset;
    }

    public static ByteArrayInput wrap(byte[] array, int offset, int length) {
        return new ByteArrayInput(array, offset, length);
    }

    public static ByteArrayInput wrap(byte[] array) {
        return ByteArrayInput.wrap(array, 0, array.length);
    }

    @Override
    public final boolean hasRemaining() {
        return this.pos < this.endPos;
    }

    @Override
    public final byte readByte() throws EOFException {
        if (this.pos >= this.endPos) {
            throw new EOFException();
        }
        return this.array[this.pos++];
    }

    @Override
    public final long readLongLE() throws IOException {
        if (this.pos > this.endPos - 8) {
            throw new EOFException();
        }
        long value = 0L;
        value |= Byte.toUnsignedLong(this.array[this.pos]);
        value |= Byte.toUnsignedLong(this.array[this.pos + 1]) << 8;
        value |= Byte.toUnsignedLong(this.array[this.pos + 2]) << 16;
        value |= Byte.toUnsignedLong(this.array[this.pos + 3]) << 24;
        value |= Byte.toUnsignedLong(this.array[this.pos + 4]) << 32;
        value |= Byte.toUnsignedLong(this.array[this.pos + 5]) << 40;
        value |= Byte.toUnsignedLong(this.array[this.pos + 6]) << 48;
        this.pos += 8;
        return value |= Byte.toUnsignedLong(this.array[this.pos + 7]) << 56;
    }
}

