/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.cache;

import datadog.trace.api.Pair;
import ddtrot.dd.trace.api.cache.DDCache;
import java.util.Arrays;
import java.util.function.Function;

abstract class FixedSizeCache<K, V>
implements DDCache<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    private final int mask;
    private final Pair<K, V>[] elements;

    FixedSizeCache(int capacity) {
        int n;
        if (capacity <= 0) {
            throw new IllegalArgumentException("Cache capacity must be > 0");
        }
        if (capacity > 0x40000000) {
            capacity = 0x40000000;
        }
        n = (n = -1 >>> Integer.numberOfLeadingZeros(capacity - 1)) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
        Pair[] lmnts = new Pair[n];
        this.elements = lmnts;
        this.mask = n - 1;
    }

    @Override
    public final V computeIfAbsent(K key, Function<K, ? extends V> creator) {
        V value;
        if (key == null) {
            return null;
        }
        int h = this.hash(key);
        int firstPos = h & this.mask;
        int i = 1;
        while (true) {
            int pos;
            Pair<K, V> current;
            if ((current = this.elements[pos = h & this.mask]) == null) {
                value = this.createAndStoreValue(key, creator, pos);
                break;
            }
            if (this.equals(key, current)) {
                value = current.getRight();
                break;
            }
            if (i == 3) {
                value = this.createAndStoreValue(key, creator, firstPos);
                break;
            }
            h = this.rehash(h);
            ++i;
        }
        return value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
    }

    abstract int hash(K var1);

    abstract boolean equals(K var1, Pair<K, V> var2);

    private V createAndStoreValue(K key, Function<K, ? extends V> creator, int pos) {
        V value = creator.apply(key);
        this.elements[pos] = Pair.of(key, value);
        return value;
    }

    private int rehash(int v) {
        int h = v * -1640532531;
        h = Integer.reverseBytes(h);
        return h * -1640532531;
    }

    static final class ArrayHash<K, V>
    extends FixedSizeCache<K[], V> {
        ArrayHash(int capacity) {
            super(capacity);
        }

        @Override
        int hash(K[] key) {
            return Arrays.hashCode(key);
        }

        @Override
        boolean equals(K[] key, Pair<K[], V> current) {
            return Arrays.equals(key, current.getLeft());
        }
    }

    static final class ObjectHash<K, V>
    extends FixedSizeCache<K, V> {
        ObjectHash(int capacity) {
            super(capacity);
        }

        @Override
        int hash(K key) {
            return key.hashCode();
        }

        @Override
        boolean equals(K key, Pair<K, V> current) {
            return key.equals(current.getLeft());
        }
    }
}

