/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast;

import ddtrot.dd.trace.api.iast.IastModule;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstrumentationBridge {
    private static final Logger LOG = LoggerFactory.getLogger(InstrumentationBridge.class);
    private static IastModule MODULE;

    private InstrumentationBridge() {
    }

    public static void registerIastModule(IastModule module) {
        MODULE = module;
    }

    public static void onCipherGetInstance(@Nonnull String algorithm) {
        try {
            if (MODULE != null) {
                MODULE.onCipherAlgorithm(algorithm);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onCipher threw.", t);
        }
    }

    public static void onMessageDigestGetInstance(@Nonnull String algorithm) {
        try {
            if (MODULE != null) {
                MODULE.onHashingAlgorithm(algorithm);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onHash threw.", t);
        }
    }

    public static void onParameterName(String parameterName) {
        try {
            if (MODULE != null) {
                MODULE.onParameterName(parameterName);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onParameterName threw.", t);
        }
    }

    public static void onParameterValue(String paramName, String paramValue) {
        try {
            if (MODULE != null) {
                MODULE.onParameterValue(paramName, paramValue);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onParameterValue threw.", t);
        }
    }

    private static void onUnexpectedException(String message, Throwable error) {
        LOG.warn(message, error);
    }
}

