/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.PersonInfo;

class BitriseInfo
extends CIProviderInfo {
    public static final String BITRISE = "BITRISE_BUILD_SLUG";
    public static final String BITRISE_PROVIDER_NAME = "bitrise";
    public static final String BITRISE_PIPELINE_ID = "BITRISE_BUILD_SLUG";
    public static final String BITRISE_PIPELINE_NAME = "BITRISE_TRIGGERED_WORKFLOW_ID";
    public static final String BITRISE_PIPELINE_NUMBER = "BITRISE_BUILD_NUMBER";
    public static final String BITRISE_PIPELINE_URL = "BITRISE_BUILD_URL";
    public static final String BITRISE_WORKSPACE_PATH = "BITRISE_SOURCE_DIR";
    public static final String BITRISE_GIT_REPOSITORY_URL = "GIT_REPOSITORY_URL";
    public static final String BITRISE_GIT_PR_COMMIT = "BITRISE_GIT_COMMIT";
    public static final String BITRISE_GIT_COMMIT = "GIT_CLONE_COMMIT_HASH";
    public static final String BITRISE_GIT_BRANCH = "BITRISE_GIT_BRANCH";
    public static final String BITRISE_GIT_TAG = "BITRISE_GIT_TAG";
    public static final String BITRISE_GIT_MESSAGE = "BITRISE_GIT_MESSAGE";

    BitriseInfo() {
    }

    @Override
    protected GitInfo buildCIGitInfo() {
        String gitTag = this.normalizeRef(System.getenv(BITRISE_GIT_TAG));
        return new GitInfo(this.filterSensitiveInfo(System.getenv(BITRISE_GIT_REPOSITORY_URL)), this.buildGitBranch(gitTag), gitTag, new CommitInfo(this.buildGitCommit(), PersonInfo.NOOP, PersonInfo.NOOP, System.getenv(BITRISE_GIT_MESSAGE)));
    }

    @Override
    protected CIProviderInfo.CIInfo buildCIInfo() {
        return CIProviderInfo.CIInfo.builder().ciProviderName(BITRISE_PROVIDER_NAME).ciPipelineId(System.getenv("BITRISE_BUILD_SLUG")).ciPipelineName(System.getenv(BITRISE_PIPELINE_NAME)).ciPipelineNumber(System.getenv(BITRISE_PIPELINE_NUMBER)).ciPipelineUrl(System.getenv(BITRISE_PIPELINE_URL)).ciWorkspace(this.expandTilde(System.getenv(BITRISE_WORKSPACE_PATH))).build();
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        return this.normalizeRef(System.getenv(BITRISE_GIT_BRANCH));
    }

    private String buildGitCommit() {
        String fromCommit = System.getenv(BITRISE_GIT_PR_COMMIT);
        if (fromCommit != null && !fromCommit.isEmpty()) {
            return fromCommit;
        }
        return System.getenv(BITRISE_GIT_COMMIT);
    }
}

