/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.EndpointCheckpointer;
import datadog.trace.api.EndpointCheckpointerHolder;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.Platform;
import datadog.trace.api.PropagationStyle;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import ddtrot.dd.communication.ddagent.ExternalAgentLauncher;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.communication.monitor.DDAgentStatsDClientManager;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.trace.api.gateway.CallbackProvider;
import ddtrot.dd.trace.api.gateway.InstrumentationGateway;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.gateway.SubscriptionService;
import ddtrot.dd.trace.api.profiling.TracingContextTrackerFactory;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.api.time.SystemTimeSource;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScopeManager;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ContextThreadListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.civisibility.CiVisibilityTraceInterceptor;
import ddtrot.dd.trace.common.metrics.MetricsAggregator;
import ddtrot.dd.trace.common.metrics.MetricsAggregatorFactory;
import ddtrot.dd.trace.common.sampling.PrioritySampler;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.common.writer.DDAgentWriter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.common.writer.WriterFactory;
import ddtrot.dd.trace.common.writer.ddintake.DDIntakeTraceInterceptor;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.core.PendingTrace;
import ddtrot.dd.trace.core.PendingTraceBuffer;
import ddtrot.dd.trace.core.StatusLogger;
import ddtrot.dd.trace.core.datastreams.DataStreamsCheckpointer;
import ddtrot.dd.trace.core.datastreams.StubDataStreamsCheckpointer;
import ddtrot.dd.trace.core.monitor.MonitoringImpl;
import ddtrot.dd.trace.core.propagation.DatadogTags;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import ddtrot.dd.trace.core.taginterceptor.RuleFlags;
import ddtrot.dd.trace.core.taginterceptor.TagInterceptor;
import ddtrot.dd.trace.lambda.LambdaHandler;
import ddtrot.dd.trace.relocate.api.RatelimitedLogger;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.dd.trace.util.CollectionUtils;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTracer
implements AgentTracer.TracerAPI {
    private static final Logger log = LoggerFactory.getLogger(CoreTracer.class);
    public static final BigInteger TRACE_ID_MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    private static final String LANG_STATSD_TAG = "lang";
    private static final String LANG_VERSION_STATSD_TAG = "lang_version";
    private static final String LANG_INTERPRETER_STATSD_TAG = "lang_interpreter";
    private static final String LANG_INTERPRETER_VENDOR_STATSD_TAG = "lang_interpreter_vendor";
    private static final String TRACER_VERSION_STATSD_TAG = "tracer_version";
    private final long startTimeNano;
    private final long startNanoTicks;
    private final long clockSyncPeriod;
    private volatile long lastSyncTicks;
    private volatile long counterDrift;
    private final PendingTraceBuffer pendingTraceBuffer;
    final String serviceName;
    final Writer writer;
    final Sampler<DDSpan> sampler;
    final AgentScopeManager scopeManager;
    final MetricsAggregator metricsAggregator;
    private final Map<String, ?> localRootSpanTags;
    private final Map<String, ?> defaultSpanTags;
    private final Map<String, String> serviceNameMappings;
    private final int partialFlushMinSpans;
    private final StatsDClient statsDClient;
    private final Monitoring monitoring;
    private final Monitoring performanceMonitoring;
    private final Recording traceWriteTimer;
    private final IdGenerationStrategy idGenerationStrategy;
    private final PendingTrace.Factory pendingTraceFactory;
    private final EndpointCheckpointerHolder endpointCheckpointer;
    private final DataStreamsCheckpointer dataStreamsCheckpointer;
    private final ExternalAgentLauncher externalAgentLauncher;
    private boolean disableSamplingMechanismValidation;
    private final TimeSource timeSource;
    private final Thread shutdownCallback;
    private final TagInterceptor tagInterceptor;
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(Comparator.comparingInt(TraceInterceptor::priority));
    private final HttpCodec.Injector injector;
    private final HttpCodec.Extractor extractor;
    private final InstrumentationGateway instrumentationGateway;
    private final CallbackProvider callbackProviderAppSec;
    private final CallbackProvider callbackProviderIast;
    private final CallbackProvider universalCallbackProvider;
    private final DatadogTags.Factory datadogTagsFactory;
    private final RatelimitedLogger rlLog = new RatelimitedLogger(log, 1, TimeUnit.MINUTES);

    public static CoreTracerBuilder builder() {
        return new CoreTracerBuilder();
    }

    DatadogTags.Factory getDatadogTagsFactory() {
        return this.datadogTagsFactory;
    }

    @Override
    public AgentScope.Continuation capture() {
        AgentScope activeScope = this.activeScope();
        return activeScope == null ? null : activeScope.capture();
    }

    @Override
    public void onRootSpanFinished(AgentSpan root, boolean published) {
        this.endpointCheckpointer.onRootSpanFinished(root, published);
    }

    @Override
    public void onRootSpanStarted(AgentSpan root) {
        this.endpointCheckpointer.onRootSpanStarted(root);
    }

    private CoreTracer(Config config, String serviceName, SharedCommunicationObjects sharedCommunicationObjects, Writer writer, IdGenerationStrategy idGenerationStrategy, Sampler<DDSpan> sampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, AgentScopeManager scopeManager, Map<String, ?> localRootSpanTags, Map<String, ?> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans, StatsDClient statsDClient, TagInterceptor tagInterceptor, boolean strictTraceWrites, InstrumentationGateway instrumentationGateway, TimeSource timeSource, DataStreamsCheckpointer dataStreamsCheckpointer) {
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        this.timeSource = timeSource == null ? SystemTimeSource.INSTANCE : timeSource;
        this.startTimeNano = this.timeSource.getCurrentTimeNanos();
        this.startNanoTicks = this.timeSource.getNanoTicks();
        this.clockSyncPeriod = Math.max(1000000L, TimeUnit.SECONDS.toNanos(config.getClockSyncPeriod()));
        this.lastSyncTicks = this.startNanoTicks;
        this.endpointCheckpointer = EndpointCheckpointerHolder.create();
        this.serviceName = serviceName;
        this.sampler = sampler;
        this.injector = injector;
        this.extractor = extractor;
        this.localRootSpanTags = localRootSpanTags;
        this.defaultSpanTags = defaultSpanTags;
        this.serviceNameMappings = serviceNameMappings;
        this.partialFlushMinSpans = partialFlushMinSpans;
        IdGenerationStrategy idGenerationStrategy2 = this.idGenerationStrategy = null == idGenerationStrategy ? Config.get().getIdGenerationStrategy() : idGenerationStrategy;
        this.statsDClient = statsDClient != null ? statsDClient : (writer == null || writer instanceof DDAgentWriter ? CoreTracer.createStatsDClient(config) : StatsDClient.NO_OP);
        this.monitoring = config.isHealthMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.performanceMonitoring = config.isPerfMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.traceWriteTimer = this.performanceMonitoring.newThreadLocalTimer("trace.write");
        if (scopeManager == null) {
            ContinuableScopeManager csm = new ContinuableScopeManager(config.getScopeDepthLimit(), this.statsDClient, config.isScopeStrictMode(), config.isScopeInheritAsyncPropagation());
            this.scopeManager = csm;
        } else {
            this.scopeManager = scopeManager;
        }
        this.externalAgentLauncher = new ExternalAgentLauncher(config);
        this.disableSamplingMechanismValidation = config.isSamplingMechanismValidationDisabled();
        if (sharedCommunicationObjects == null) {
            sharedCommunicationObjects = new SharedCommunicationObjects();
        }
        sharedCommunicationObjects.monitoring = this.monitoring;
        sharedCommunicationObjects.createRemaining(config);
        this.writer = writer == null ? WriterFactory.createWriter(config, sharedCommunicationObjects, sampler, this.statsDClient) : writer;
        this.pendingTraceBuffer = strictTraceWrites ? PendingTraceBuffer.discarding() : PendingTraceBuffer.delaying(this.timeSource);
        this.pendingTraceFactory = new PendingTrace.Factory(this, this.pendingTraceBuffer, this.timeSource, strictTraceWrites);
        this.pendingTraceBuffer.start();
        this.writer.start();
        this.metricsAggregator = MetricsAggregatorFactory.createMetricsAggregator(config, sharedCommunicationObjects);
        AgentTaskScheduler.INSTANCE.scheduleWithJitter(MetricsAggregator::start, this.metricsAggregator, 1L, TimeUnit.SECONDS);
        this.dataStreamsCheckpointer = dataStreamsCheckpointer == null ? CoreTracer.createDataStreamsCheckpointer(config, sharedCommunicationObjects, this.timeSource) : dataStreamsCheckpointer;
        this.dataStreamsCheckpointer.start();
        TagInterceptor tagInterceptor2 = this.tagInterceptor = null == tagInterceptor ? new TagInterceptor(new RuleFlags(config)) : tagInterceptor;
        if (config.isCiVisibilityEnabled()) {
            this.addTraceInterceptor(CiVisibilityTraceInterceptor.INSTANCE);
            if (config.isCiVisibilityAgentlessEnabled()) {
                this.addTraceInterceptor(DDIntakeTraceInterceptor.INSTANCE);
            }
        }
        this.instrumentationGateway = instrumentationGateway;
        this.callbackProviderAppSec = instrumentationGateway.getCallbackProvider(RequestContextSlot.APPSEC);
        this.callbackProviderIast = instrumentationGateway.getCallbackProvider(RequestContextSlot.IAST);
        this.universalCallbackProvider = instrumentationGateway.getUniversalCallbackProvider();
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        StatusLogger.logStatus(config);
        this.datadogTagsFactory = DatadogTags.factory(config);
    }

    protected void finalize() {
        try {
            this.shutdownCallback.run();
            Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            log.error("Error while finalizing DDTracer.", (Throwable)e);
        }
    }

    PendingTrace createTrace(DDTraceId id) {
        return this.pendingTraceFactory.create(id);
    }

    public String mapServiceName(String serviceName) {
        String mapped = this.serviceNameMappings.get(serviceName);
        return null == mapped ? serviceName : mapped;
    }

    private void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addTraceInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: " + classLoader, (Throwable)e);
        }
    }

    long getTimeWithNanoTicks(long nanoTicks) {
        long computedNanoTime = this.startTimeNano + Math.max(0L, nanoTicks - this.startNanoTicks);
        if (nanoTicks - this.lastSyncTicks >= this.clockSyncPeriod) {
            long drift = computedNanoTime - this.timeSource.getCurrentTimeNanos();
            if (Math.abs(drift + this.counterDrift) >= 1000000L) {
                this.counterDrift = -TimeUnit.MILLISECONDS.toNanos(TimeUnit.NANOSECONDS.toMillis(drift));
            }
            this.lastSyncTicks = nanoTicks;
        }
        return computedNanoTime + this.counterDrift;
    }

    @Override
    public CoreSpanBuilder buildSpan(CharSequence operationName) {
        return new CoreSpanBuilder(operationName, this);
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName) {
        return this.buildSpan(spanName).start();
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName, long startTimeMicros) {
        return this.buildSpan(spanName).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent) {
        return this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent).start();
    }

    @Override
    public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
        return this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent).withStartTimestamp(startTimeMicros).start();
    }

    public AgentScope activateSpan(AgentSpan span) {
        return this.scopeManager.activate(span, ScopeSource.INSTRUMENTATION, true);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
        return this.scopeManager.activate(span, source);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.scopeManager.activate(span, source, isAsyncPropagating);
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
        return this.scopeManager.captureSpan(span, source);
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        this.scopeManager.closePrevious(finishSpan);
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        return this.scopeManager.activateNext(span);
    }

    public TagInterceptor getTagInterceptor() {
        return this.tagInterceptor;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    @Override
    public AgentSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public AgentScope activeScope() {
        return this.scopeManager.active();
    }

    @Override
    public AgentPropagation propagate() {
        return this;
    }

    @Override
    public AgentSpan noopSpan() {
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(span.context(), carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(context, carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, PropagationStyle style) {
        this.inject(span.context(), carrier, setter, style);
    }

    @Override
    public <C> void injectBinaryPathwayContext(AgentSpan span, C carrier, AgentPropagation.BinarySetter<C> setter, LinkedHashMap<String, String> sortedTags) {
        PathwayContext pathwayContext = span.context().getPathwayContext();
        pathwayContext.setCheckpoint(sortedTags, this.dataStreamsCheckpointer);
        try {
            byte[] encodedContext = span.context().getPathwayContext().encode();
            if (encodedContext != null) {
                log.debug("Injecting pathway context {}", (Object)pathwayContext);
                setter.set(carrier, "dd-pathway-ctx", encodedContext);
            }
        }
        catch (IOException e) {
            log.debug("Unable to set encode pathway context", (Throwable)e);
        }
    }

    @Override
    public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        PathwayContext pathwayContext = span.context().getPathwayContext();
        pathwayContext.setCheckpoint(sortedTags, this.dataStreamsCheckpointer);
        try {
            String encodedContext = pathwayContext.strEncode();
            if (encodedContext != null) {
                setter.set(carrier, "dd-pathway-ctx-base64", encodedContext);
            }
        }
        catch (IOException e) {
            log.debug("Unable to set encode pathway context", (Throwable)e);
        }
    }

    private <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter, PropagationStyle style) {
        if (!(context instanceof DDSpanContext)) {
            return;
        }
        DDSpanContext ddSpanContext = (DDSpanContext)context;
        DDSpan rootSpan = ddSpanContext.getTrace().getRootSpan();
        this.setSamplingPriorityIfNecessary(rootSpan);
        if (null == style) {
            this.injector.inject(ddSpanContext, carrier, setter);
        } else {
            HttpCodec.inject(ddSpanContext, carrier, setter, style);
        }
    }

    @Override
    public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        return this.extractor.extract(carrier, getter);
    }

    @Override
    public <C> PathwayContext extractBinaryPathwayContext(C carrier, AgentPropagation.BinaryContextVisitor<C> getter) {
        return this.dataStreamsCheckpointer.extractBinaryPathwayContext(carrier, getter);
    }

    @Override
    public <C> PathwayContext extractPathwayContext(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        return this.dataStreamsCheckpointer.extractPathwayContext(carrier, getter);
    }

    @Override
    public void setDataStreamCheckpoint(AgentSpan span, LinkedHashMap<String, String> sortedTags) {
        span.context().getPathwayContext().setCheckpoint(sortedTags, this.dataStreamsCheckpointer);
    }

    @Override
    public AgentSpan.Context notifyExtensionStart(Object event) {
        return LambdaHandler.notifyStartInvocation(event, this.datadogTagsFactory);
    }

    @Override
    public void notifyExtensionEnd(AgentSpan span, boolean isError) {
        LambdaHandler.notifyEndInvocation(span, isError);
    }

    void write(List<DDSpan> trace) {
        if (trace.isEmpty()) {
            return;
        }
        List<DDSpan> writtenTrace = trace;
        if (!this.interceptors.isEmpty()) {
            Collection<MutableSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            for (TraceInterceptor traceInterceptor : this.interceptors) {
                try {
                    interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
                }
                catch (Exception e) {
                    String interceptorName = traceInterceptor.getClass().getName();
                    this.rlLog.warn("Exception in TraceInterceptor {}", interceptorName, e);
                }
            }
            writtenTrace = new ArrayList<DDSpan>(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                writtenTrace.add((DDSpan)mutableSpan);
            }
        }
        if (!writtenTrace.isEmpty()) {
            boolean published;
            boolean forceKeep = this.metricsAggregator.publish(writtenTrace);
            DDSpan rootSpan = writtenTrace.get(0).getLocalRootSpan();
            this.setSamplingPriorityIfNecessary(rootSpan);
            DDSpan dDSpan = rootSpan == null ? writtenTrace.get(0) : rootSpan;
            dDSpan.forceKeep(forceKeep);
            boolean bl = published = forceKeep || this.sampler.sample(dDSpan);
            if (published) {
                if (TracingContextTrackerFactory.isTrackingAvailable()) {
                    for (DDSpan span : writtenTrace) {
                        int stored = span.storeContextToTag();
                        if (stored <= -1) continue;
                        log.trace("Sending statsd metric 'tracing.context.size'={} (client={})", (Object)stored, (Object)this.statsDClient);
                        this.statsDClient.histogram("tracing.context.size", stored, new String[0]);
                    }
                }
                this.writer.write(writtenTrace);
            } else {
                this.writer.incrementDropCounts(writtenTrace.size());
            }
            if (null != rootSpan) {
                this.onRootSpanFinished(rootSpan, published);
                RequestContext requestContext = rootSpan.getRequestContext();
                if (requestContext != null) {
                    try {
                        requestContext.close();
                    }
                    catch (IOException e) {
                        log.warn("Error closing request context data", (Throwable)e);
                    }
                }
            }
        }
    }

    void setSamplingPriorityIfNecessary(DDSpan rootSpan) {
        if (this.sampler instanceof PrioritySampler && rootSpan != null && rootSpan.context().getSamplingPriority() == -128) {
            ((PrioritySampler)((Object)this.sampler)).setSamplingPriority(rootSpan);
        }
    }

    @Override
    public String getTraceId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return activeSpan.getTraceId().toString();
        }
        return "0";
    }

    @Override
    public String getSpanId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return DDSpanId.toString(activeSpan.getSpanId());
        }
        return "0";
    }

    @Override
    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    @Override
    public void addScopeListener(ScopeListener listener) {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).addScopeListener(listener);
        }
    }

    @Override
    public void addThreadContextListener(ContextThreadListener listener) {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).addContextThreadListener(listener);
        }
    }

    @Override
    public void detach() {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).detach();
        }
    }

    @Override
    public void registerCheckpointer(EndpointCheckpointer implementation) {
        this.endpointCheckpointer.register(implementation);
    }

    @Override
    public SubscriptionService getSubscriptionService(RequestContextSlot slot) {
        return (SubscriptionService)((Object)this.instrumentationGateway.getCallbackProvider(slot));
    }

    @Override
    public CallbackProvider getCallbackProvider(RequestContextSlot slot) {
        if (slot == RequestContextSlot.APPSEC) {
            return this.callbackProviderAppSec;
        }
        if (slot == RequestContextSlot.IAST) {
            return this.callbackProviderIast;
        }
        return CallbackProvider.CallbackProviderNoop.INSTANCE;
    }

    @Override
    public CallbackProvider getUniversalCallbackProvider() {
        return this.universalCallbackProvider;
    }

    @Override
    public void close() {
        this.pendingTraceBuffer.close();
        this.writer.close();
        this.statsDClient.close();
        this.metricsAggregator.close();
        this.dataStreamsCheckpointer.close();
        this.externalAgentLauncher.close();
    }

    @Override
    public void flush() {
        this.pendingTraceBuffer.flush();
        this.writer.flush();
    }

    private static StatsDClient createStatsDClient(Config config) {
        Integer port;
        if (!config.isHealthMetricsEnabled()) {
            return StatsDClient.NO_OP;
        }
        String host = config.getHealthMetricsStatsdHost();
        if (host == null) {
            host = config.getJmxFetchStatsdHost();
        }
        if ((port = config.getHealthMetricsStatsdPort()) == null) {
            port = config.getJmxFetchStatsdPort();
        }
        return DDAgentStatsDClientManager.statsDClientManager().statsDClient(host, port, config.getDogStatsDNamedPipe(), "ddtrot.dd.tracer", CoreTracer.generateConstantTags(config));
    }

    private static String[] generateConstantTags(Config config) {
        String env;
        ArrayList<String> constantTags = new ArrayList<String>();
        constantTags.add(CoreTracer.statsdTag(LANG_STATSD_TAG, "java"));
        constantTags.add(CoreTracer.statsdTag(LANG_VERSION_STATSD_TAG, DDTraceCoreInfo.JAVA_VERSION));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_NAME));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_VENDOR_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_VENDOR));
        constantTags.add(CoreTracer.statsdTag(TRACER_VERSION_STATSD_TAG, DDTraceCoreInfo.VERSION));
        constantTags.add(CoreTracer.statsdTag("service", config.getServiceName()));
        Map<String, String> mergedSpanTags = config.getMergedSpanTags();
        String version = mergedSpanTags.get("version");
        if (version != null && !version.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("version", version));
        }
        if ((env = mergedSpanTags.get("env")) != null && !env.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("env", env));
        }
        return constantTags.toArray(new String[0]);
    }

    @SuppressForbidden
    private static DataStreamsCheckpointer createDataStreamsCheckpointer(Config config, SharedCommunicationObjects sharedCommunicationObjects, TimeSource timeSource) {
        if (config.isDataStreamsEnabled() && Platform.isJavaVersionAtLeast(8)) {
            try {
                return (DataStreamsCheckpointer)Class.forName("ddtrot.dd.trace.core.datastreams.DefaultDataStreamsCheckpointer").getConstructor(Config.class, SharedCommunicationObjects.class, TimeSource.class).newInstance(config, sharedCommunicationObjects, timeSource);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Failed to instantiate data streams checkpointer", (Throwable)e);
                return new StubDataStreamsCheckpointer();
            }
        }
        log.debug("Data streams monitoring not enabled.");
        return new StubDataStreamsCheckpointer();
    }

    Recording writeTimer() {
        return this.traceWriteTimer.start();
    }

    private static String statsdTag(String tagPrefix, String tagValue) {
        return tagPrefix + ":" + tagValue;
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<CoreTracer> reference;

        private ShutdownHook(CoreTracer tracer) {
            super(AgentThreadFactory.AGENT_THREAD_GROUP, "dd-tracer-shutdown-hook");
            this.reference = new WeakReference<CoreTracer>(tracer);
        }

        @Override
        public void run() {
            CoreTracer tracer = (CoreTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class CoreSpanBuilder
    implements AgentTracer.SpanBuilder {
        private final CharSequence operationName;
        private final CoreTracer tracer;
        private Map<String, Object> tags;
        private long timestampMicro;
        private Object parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private CharSequence spanType;
        private boolean ignoreScope = false;

        CoreSpanBuilder(CharSequence operationName, CoreTracer tracer) {
            this.operationName = operationName;
            this.tracer = tracer;
        }

        @Override
        public CoreSpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan buildSpan() {
            DDSpan span = DDSpan.create(this.timestampMicro, this.buildSpanContext());
            if (span.isLocalRootSpan()) {
                this.tracer.onRootSpanStarted(span);
            }
            return span;
        }

        @Override
        public AgentSpan start() {
            return this.buildSpan();
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)string);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        @Override
        public CoreSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        @Override
        public CoreSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        @Override
        public CoreSpanBuilder withSpanType(CharSequence spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public CoreSpanBuilder asChildOf(AgentSpan.Context spanContext) {
            this.parent = spanContext;
            return this;
        }

        public CoreSpanBuilder asChildOf(AgentSpan agentSpan) {
            this.parent = agentSpan.context();
            return this;
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Object value) {
            Map<String, Object> tagMap = this.tags;
            if (tagMap == null) {
                this.tags = tagMap = new LinkedHashMap<String, Object>();
            }
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                tagMap.remove(tag);
            } else {
                tagMap.put(tag, value);
            }
            return this;
        }

        private DDSpanContext buildSpanContext() {
            DatadogTags datadogTags;
            PathwayContext pathwayContext;
            Object requestContextDataIast;
            Object requestContextDataAppSec;
            Map rootSpanTags;
            Map<String, String> coreTags;
            String origin;
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            long parentSpanId;
            DDTraceId traceId;
            AgentSpan activeSpan;
            long spanId = CoreTracer.this.idGenerationStrategy.generateSpanId();
            Object parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = CoreTracer.this.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            String parentServiceName = null;
            if (parentContext instanceof DDSpanContext) {
                RequestContext requestContext;
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = -128;
                origin = null;
                coreTags = null;
                rootSpanTags = null;
                parentServiceName = ddsc.getServiceName();
                if (this.serviceName == null) {
                    this.serviceName = parentServiceName;
                }
                if ((requestContext = ((DDSpanContext)parentContext).getRequestContext()) != null) {
                    requestContextDataAppSec = requestContext.getData(RequestContextSlot.APPSEC);
                    requestContextDataIast = requestContext.getData(RequestContextSlot.IAST);
                } else {
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                }
                pathwayContext = ddsc.getPathwayContext().isStarted() ? ddsc.getPathwayContext() : CoreTracer.this.dataStreamsCheckpointer.newPathwayContext();
                datadogTags = CoreTracer.this.datadogTagsFactory.empty();
            } else {
                long endToEndStartTime;
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    endToEndStartTime = extractedContext.getEndToEndStartTime();
                    baggage = extractedContext.getBaggage();
                    datadogTags = extractedContext.getDatadogTags();
                } else {
                    traceId = CoreTracer.this.idGenerationStrategy.generateTraceId();
                    parentSpanId = 0L;
                    samplingPriority = -128;
                    endToEndStartTime = 0L;
                    baggage = null;
                    datadogTags = CoreTracer.this.datadogTagsFactory.empty();
                }
                if (parentContext instanceof TagContext) {
                    TagContext tc = (TagContext)parentContext;
                    coreTags = tc.getTags();
                    origin = tc.getOrigin();
                    requestContextDataAppSec = tc.getRequestContextDataAppSec();
                    requestContextDataIast = tc.getRequestContextDataIast();
                } else {
                    coreTags = null;
                    origin = null;
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                }
                rootSpanTags = CoreTracer.this.localRootSpanTags;
                parentTrace = CoreTracer.this.createTrace(traceId);
                if (endToEndStartTime > 0L) {
                    parentTrace.beginEndToEnd(endToEndStartTime);
                }
                pathwayContext = CoreTracer.this.dataStreamsCheckpointer.newPathwayContext();
            }
            if (this.serviceName == null) {
                this.serviceName = CoreTracer.this.serviceName;
            }
            CharSequence operationName = this.operationName != null ? this.operationName : this.resourceName;
            int tagsSize = (null == this.tags ? 0 : this.tags.size()) + CoreTracer.this.defaultSpanTags.size() + (null == coreTags ? 0 : coreTags.size()) + (null == rootSpanTags ? 0 : rootSpanTags.size());
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, parentServiceName, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, this.errorFlag, this.spanType, tagsSize, parentTrace, requestContextDataAppSec, requestContextDataIast, pathwayContext, CoreTracer.this.disableSamplingMechanismValidation, datadogTags);
            context.setAllTags(CoreTracer.this.defaultSpanTags);
            context.setAllTags(this.tags);
            context.setAllTags(coreTags);
            context.setAllTags(rootSpanTags);
            return context;
        }
    }

    public static class CoreTracerBuilder {
        private Config config;
        private String serviceName;
        private SharedCommunicationObjects sharedCommunicationObjects;
        private Writer writer;
        private IdGenerationStrategy idGenerationStrategy;
        private Sampler<DDSpan> sampler;
        private HttpCodec.Injector injector;
        private HttpCodec.Extractor extractor;
        private AgentScopeManager scopeManager;
        private Map<String, ?> localRootSpanTags;
        private Map<String, ?> defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private int partialFlushMinSpans;
        private StatsDClient statsDClient;
        private TagInterceptor tagInterceptor;
        private boolean strictTraceWrites;
        private InstrumentationGateway instrumentationGateway;
        private TimeSource timeSource;
        private DataStreamsCheckpointer dataStreamsCheckpointer;

        public CoreTracerBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public CoreTracerBuilder sharedCommunicationObjects(SharedCommunicationObjects sharedCommunicationObjects) {
            this.sharedCommunicationObjects = sharedCommunicationObjects;
            return this;
        }

        public CoreTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public CoreTracerBuilder idGenerationStrategy(IdGenerationStrategy idGenerationStrategy) {
            this.idGenerationStrategy = idGenerationStrategy;
            return this;
        }

        public CoreTracerBuilder sampler(Sampler<DDSpan> sampler) {
            this.sampler = sampler;
            return this;
        }

        public CoreTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public CoreTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public CoreTracerBuilder scopeManager(AgentScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(Map<String, ?> localRootSpanTags) {
            this.localRootSpanTags = CollectionUtils.tryMakeImmutableMap(localRootSpanTags);
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(Map<String, ?> defaultSpanTags) {
            this.defaultSpanTags = CollectionUtils.tryMakeImmutableMap(defaultSpanTags);
            return this;
        }

        public CoreTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = CollectionUtils.tryMakeImmutableMap(serviceNameMappings);
            return this;
        }

        public CoreTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = CollectionUtils.tryMakeImmutableMap(taggedHeaders);
            return this;
        }

        public CoreTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public CoreTracerBuilder statsDClient(StatsDClient statsDClient) {
            this.statsDClient = statsDClient;
            return this;
        }

        public CoreTracerBuilder tagInterceptor(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder statsDClient(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder strictTraceWrites(boolean strictTraceWrites) {
            this.strictTraceWrites = strictTraceWrites;
            return this;
        }

        public CoreTracerBuilder instrumentationGateway(InstrumentationGateway instrumentationGateway) {
            this.instrumentationGateway = instrumentationGateway;
            return this;
        }

        public CoreTracerBuilder timeSource(TimeSource timeSource) {
            this.timeSource = timeSource;
            return this;
        }

        public CoreTracerBuilder dataStreamsCheckpointer(DataStreamsCheckpointer dataStreamsCheckpointer) {
            this.dataStreamsCheckpointer = dataStreamsCheckpointer;
            return this;
        }

        public CoreTracerBuilder() {
            this.config(Config.get());
        }

        public CoreTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get(properties));
        }

        public CoreTracerBuilder config(Config config) {
            this.config = config;
            this.serviceName(config.getServiceName());
            this.sampler(Sampler.Builder.forConfig(config));
            this.instrumentationGateway(new InstrumentationGateway());
            this.injector(HttpCodec.createInjector(config));
            this.extractor(HttpCodec.createExtractor(config, config.getRequestHeaderTags()));
            this.localRootSpanTags(config.getLocalRootSpanTags());
            this.defaultSpanTags(config.getMergedSpanTags());
            this.serviceNameMappings(config.getServiceMapping());
            this.taggedHeaders(config.getRequestHeaderTags());
            this.partialFlushMinSpans(config.getPartialFlushMinSpans());
            this.strictTraceWrites(config.isTraceStrictWritesEnabled());
            return this;
        }

        public CoreTracer build() {
            return new CoreTracer(this.config, this.serviceName, this.sharedCommunicationObjects, this.writer, this.idGenerationStrategy, this.sampler, this.injector, this.extractor, this.scopeManager, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.partialFlushMinSpans, this.statsDClient, this.tagInterceptor, this.strictTraceWrites, this.instrumentationGateway, this.timeSource, this.dataStreamsCheckpointer);
        }
    }
}

