/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.monitor;

import datadog.trace.api.StatsDClient;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.trace.core.histogram.Histogram;
import ddtrot.dd.trace.core.histogram.Histograms;
import ddtrot.dd.trace.core.monitor.Utils;
import java.util.concurrent.TimeUnit;

public class Timer
extends Recording {
    private static final long THIRTY_SECONDS_AS_MICROS = TimeUnit.SECONDS.toMicros(30L);
    private static final String[] P_50 = new String[]{"stat:p50"};
    private static final String[] P_99 = new String[]{"stat:p99"};
    private static final String[] MAX = new String[]{"stat:max"};
    private final String name;
    private final StatsDClient statsd;
    private final Histogram histogram;
    private final long flushAfterNanos;
    private final String[] p50Tags;
    private final String[] p99Tags;
    private final String[] maxTags;
    private long start;
    private long lastFlush = 0L;

    Timer(String name, String[] tags, StatsDClient statsd, long flushAfterNanos) {
        this.name = name;
        this.statsd = statsd;
        this.flushAfterNanos = flushAfterNanos;
        this.histogram = Histograms.newHistogramFactory().newHistogram();
        this.p50Tags = Utils.mergeTags(P_50, tags);
        this.p99Tags = Utils.mergeTags(P_99, tags);
        this.maxTags = Utils.mergeTags(MAX, tags);
    }

    Timer(String name, StatsDClient statsd, long flushAfterNanos) {
        this(name, null, statsd, flushAfterNanos);
    }

    @Override
    public Recording start() {
        this.start = System.nanoTime();
        return this;
    }

    @Override
    public void reset() {
        long now = System.nanoTime();
        this.record(now);
        this.start = now;
    }

    @Override
    public void stop() {
        this.record(System.nanoTime());
    }

    private void record(long now) {
        this.histogram.accept(Math.min(TimeUnit.NANOSECONDS.toMicros(now - this.start), THIRTY_SECONDS_AS_MICROS));
        if (now - this.lastFlush > this.flushAfterNanos) {
            this.lastFlush = now;
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.statsd.gauge(this.name, this.histogram.valueAtQuantile(0.5), this.p50Tags);
        this.statsd.gauge(this.name, this.histogram.valueAtQuantile(0.99), this.p99Tags);
        this.statsd.gauge(this.name, this.histogram.max(), this.maxTags);
        this.histogram.clear();
    }
}

