/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import ddtrot.com.google.re2j.Matcher;
import ddtrot.com.google.re2j.Pattern;
import ddtrot.com.google.re2j.PatternSyntaxException;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import ddtrot.dd.trace.util.Strings;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryObfuscator
implements TagsPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(QueryObfuscator.class);
    private static final String DEFAULT_OBFUSCATION_PATTERN = "((?i)(?:p(?:ass)?w(?:or)?d|pass(?:_?phrase)?|secret|(?:api_?|private_?|public_?|access_?|secret_?)key(?:_?id)?|token|consumer_?(?:id|key|secret)|sign(?:ed|ature)?|auth(?:entication|orization)?)(?:(?:\\s|%20)*(?:=|%3D)[^&]+|(?:\"|%22)(?:\\s|%20)*(?::|%3A)(?:\\s|%20)*(?:\"|%22)(?:%2[^2]|%[^2]|[^\"%])+(?:\"|%22))|bearer(?:\\s|%20)+[a-z0-9\\._\\-]|token(?::|%3A)[a-z0-9]{13}|gh[opsu]_[0-9a-zA-Z]{36}|ey[I-L](?:[\\w=-]|%3D)+\\.ey[I-L](?:[\\w=-]|%3D)+(?:\\.(?:[\\w.+\\/=-]|%3D|%2F|%2B)+)?|[\\-]{5}BEGIN(?:[a-z\\s]|%20)+PRIVATE(?:\\s|%20)KEY[\\-]{5}[^\\-]+[\\-]{5}END(?:[a-z\\s]|%20)+PRIVATE(?:\\s|%20)KEY|ssh-rsa(?:\\s|%20)*(?:[a-z0-9\\/\\.+]|%2F|%5C|%2B){100,})";
    private final Pattern pattern;

    public QueryObfuscator(String regex) {
        if ("".equals(regex)) {
            this.pattern = null;
            return;
        }
        if (regex == null) {
            regex = DEFAULT_OBFUSCATION_PATTERN;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            log.error("Could not compile given query obfuscation regex: {}", (Object)regex, (Object)e);
        }
        this.pattern = pattern;
    }

    private String obfuscate(String query) {
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(query);
            while (matcher.find()) {
                query = Strings.replace(query, matcher.group(), "<redacted>");
            }
        }
        return query;
    }

    @Override
    public Map<String, Object> processTags(Map<String, Object> unsafeTags) {
        Object query = unsafeTags.get("http.query.string");
        if (query instanceof String) {
            query = this.obfuscate((String)query);
            unsafeTags.put("http.query.string", query);
            Object url = unsafeTags.get("http.url");
            if (url instanceof String) {
                unsafeTags.put("http.url", url + "?" + query);
            }
        }
        return unsafeTags;
    }
}

