/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci.git;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitConfig;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfoExtractor;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitObject;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.PersonInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.RawParseUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.pack.GitPackObject;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.pack.GitPackUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.pack.V2PackGitInfoExtractor;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.pack.VersionedPackGitInfoExtractor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;

public class LocalFSGitInfoExtractor
implements GitInfoExtractor {
    private static final int SHA_INDEX = 1;
    private static final VersionedPackGitInfoExtractor V2_PACK_GIT_INFO_EXTRACTOR = new V2PackGitInfoExtractor();
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");

    @Override
    public GitInfo headCommit(String gitFolder) {
        try {
            Path gitFolderPath = Paths.get(gitFolder, new String[0]);
            String head = this.readFile(gitFolderPath.resolve("HEAD"));
            String ref = this.extractRef(head);
            String branch = this.extractBranch(ref);
            String tag = this.extractTag(ref);
            String sha = this.extractSha(gitFolderPath, head);
            String repositoryURL = this.extractRepositoryURL(gitFolderPath, branch);
            CommitInfo commitInfo = this.findCommit(gitFolder, sha);
            return new GitInfo(repositoryURL, branch, tag, commitInfo);
        }
        catch (Exception e) {
            return GitInfo.NOOP;
        }
    }

    private String extractRepositoryURL(Path gitFolderPath, String branch) {
        File configFile = gitFolderPath.resolve("config").toFile();
        if (!configFile.exists()) {
            return null;
        }
        GitConfig gitConfig = new GitConfig(configFile.getAbsolutePath());
        String branchRemote = gitConfig.getString("branch \"" + branch + "\"", "remote");
        String remoteUrl = gitConfig.getString("remote \"" + branchRemote + "\"", "url");
        if (remoteUrl == null) {
            remoteUrl = gitConfig.getString("remote \"origin\"", "url");
        }
        return GitUtils.filterSensitiveInfo(remoteUrl);
    }

    private String extractTag(String ref) {
        if (ref != null && ref.contains("refs/tags")) {
            return GitUtils.normalizeRef(ref);
        }
        return null;
    }

    private String extractBranch(String ref) {
        if (ref != null && (ref.contains("origin") || ref.contains("refs/heads"))) {
            return GitUtils.normalizeRef(ref);
        }
        return null;
    }

    private String extractRef(String head) {
        if (head == null || head.isEmpty() || !head.contains("ref:")) {
            return null;
        }
        return head.substring(5);
    }

    private CommitInfo findCommit(String gitFolder, String sha) throws IOException, DataFormatException {
        GitObject gitObject;
        String filename;
        if (sha == null || sha.isEmpty()) {
            return CommitInfo.NOOP;
        }
        String folder = sha.substring(0, 2);
        File gitObjectFile = Paths.get(gitFolder, "objects", folder, filename = sha.substring(2)).toFile();
        if (gitObjectFile.exists()) {
            byte[] deflatedBytes = Files.readAllBytes(gitObjectFile.toPath());
            gitObject = this.buildGitObject(deflatedBytes);
        } else {
            GitPackObject gitPackObject = this.readPackObject(gitFolder, sha);
            gitObject = this.buildGitObject(gitPackObject);
        }
        if (gitObject == null) {
            return CommitInfo.NOOP;
        }
        return this.parseCommit(gitFolder, sha, gitObject);
    }

    private GitPackObject readPackObject(String gitFolder, String sha) throws IOException {
        File packFolder = Paths.get(gitFolder, "objects", "pack").toFile();
        File[] idxFiles = packFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".idx");
            }
        });
        if (idxFiles == null) {
            return null;
        }
        short packVersion = 0;
        for (File idxFile : idxFiles) {
            VersionedPackGitInfoExtractor gitPackExtractor;
            if (packVersion == 0) {
                packVersion = GitPackUtils.extractGitPackVersion(idxFile);
            }
            if ((gitPackExtractor = LocalFSGitInfoExtractor.lookupExtractor(packVersion)) == null) break;
            GitPackObject packObj = gitPackExtractor.extract(idxFile, GitPackUtils.getPackFile(idxFile), sha);
            if (packObj.raisedError()) {
                return null;
            }
            if (packObj.getShaIndex() == -1) continue;
            return packObj;
        }
        return null;
    }

    private CommitInfo parseCommit(String gitFolder, String sha, GitObject gitObject) throws IOException, DataFormatException {
        if (gitObject.getType() == 4) {
            int lf = RawParseUtils.nextLF(gitObject.getContent(), 0);
            if (lf == -1) {
                return CommitInfo.NOOP;
            }
            String objectSha = new String(Arrays.copyOfRange(gitObject.getContent(), 0, lf - 1));
            String[] objectShaChunks = SPACE_PATTERN.split(objectSha);
            if (objectShaChunks.length < 2) {
                return CommitInfo.NOOP;
            }
            String innerSha = objectShaChunks[1];
            return this.findCommit(gitFolder, innerSha);
        }
        if (gitObject.getType() != 1) {
            return CommitInfo.NOOP;
        }
        byte[] content = gitObject.getContent();
        PersonInfo author = this.getAuthor(content);
        PersonInfo committer = this.getCommitter(content);
        String fullMessage = this.getFullMessage(content);
        return new CommitInfo(sha, author, committer, fullMessage);
    }

    private GitObject buildGitObject(byte[] compressedBytes) {
        try {
            byte[] decompressed = GitUtils.inflate(compressedBytes);
            if (decompressed == null) {
                return GitObject.NOOP;
            }
            int separatorIndex = RawParseUtils.findByte(decompressed, (byte)0);
            if (separatorIndex == -1) {
                return GitObject.NOOP;
            }
            byte[] metadataBytes = Arrays.copyOfRange(decompressed, 0, separatorIndex);
            String[] metadata = SPACE_PATTERN.split(new String(metadataBytes));
            if (metadata.length != 2) {
                return GitObject.NOOP;
            }
            byte[] content = Arrays.copyOfRange(decompressed, separatorIndex + 1, decompressed.length);
            return new GitObject(LocalFSGitInfoExtractor.typeToByte(metadata[0]), Integer.parseInt(metadata[1]), content);
        }
        catch (DataFormatException ex) {
            return GitObject.NOOP;
        }
    }

    private GitObject buildGitObject(GitPackObject gitPackObject) {
        if (gitPackObject == null) {
            return GitObject.NOOP;
        }
        try {
            byte[] decompressed = GitUtils.inflate(gitPackObject.getDeflatedContent());
            if (decompressed == null) {
                return GitObject.NOOP;
            }
            return new GitObject(gitPackObject.getType(), decompressed.length, decompressed);
        }
        catch (DataFormatException ex) {
            return GitObject.NOOP;
        }
    }

    private static byte typeToByte(String type) {
        switch (type) {
            case "commit": {
                return 1;
            }
            case "tag": {
                return 4;
            }
        }
        return 0;
    }

    private String extractSha(Path gitFolder, String head) throws IOException {
        if (head == null) {
            return null;
        }
        if (head.contains("ref:")) {
            String refStr = this.extractRef(head);
            if (refStr == null) {
                return null;
            }
            File ref = gitFolder.resolve(refStr).toFile();
            if (!ref.exists()) {
                return null;
            }
            return this.readFile(ref.toPath());
        }
        return head;
    }

    protected PersonInfo getAuthor(byte[] buffer) {
        int authorNameBeginning = RawParseUtils.author(buffer, 0);
        if (authorNameBeginning < 0) {
            return PersonInfo.NOOP;
        }
        return this.parsePersonInfo(buffer, authorNameBeginning);
    }

    protected PersonInfo getCommitter(byte[] buffer) {
        int nameB = RawParseUtils.committer(buffer, 0);
        if (nameB < 0) {
            return PersonInfo.NOOP;
        }
        return this.parsePersonInfo(buffer, nameB);
    }

    protected String getFullMessage(byte[] buffer) {
        int msgB = RawParseUtils.commitMessage(buffer, 0);
        if (msgB < 0) {
            return null;
        }
        return RawParseUtils.decode(buffer, msgB, buffer.length);
    }

    protected PersonInfo parsePersonInfo(byte[] raw, int nameB) {
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailB >= raw.length || raw[emailB] == 10 || emailE >= raw.length - 1 && raw[emailE - 1] != 62) {
            return null;
        }
        int nameEnd = emailB - 2 >= nameB && raw[emailB - 2] == 32 ? emailB - 2 : emailB - 1;
        String name = RawParseUtils.decode(raw, nameB, nameEnd);
        String email = RawParseUtils.decode(raw, emailB, emailE - 1);
        int tzBegin = RawParseUtils.lastIndexOfTrim(raw, ' ', RawParseUtils.nextLF(raw, emailE - 1) - 2) + 1;
        if (tzBegin <= emailE) {
            return new PersonInfo(name, email, 0L, 0);
        }
        int whenBegin = Math.max(emailE, RawParseUtils.lastIndexOfTrim(raw, ' ', tzBegin - 1) + 1);
        if (whenBegin >= tzBegin - 1) {
            return new PersonInfo(name, email, 0L, 0);
        }
        long when = RawParseUtils.parseLongBase10(raw, whenBegin);
        int tz = RawParseUtils.parseTimeZoneOffset(raw, tzBegin);
        return new PersonInfo(name, email, when * 1000L, tz);
    }

    private String readFile(Path filepath) throws IOException {
        if (filepath == null || !filepath.toFile().exists()) {
            return null;
        }
        String content = new String(Files.readAllBytes(filepath));
        if (content.endsWith("\n")) {
            return content.substring(0, content.length() - 1);
        }
        return content;
    }

    private static VersionedPackGitInfoExtractor lookupExtractor(short packVersion) {
        if (packVersion == 2) {
            return V2_PACK_GIT_INFO_EXTRACTOR;
        }
        return null;
    }
}

