/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.taginterceptor;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.env.CapturedEnvironment;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.taginterceptor.RuleFlags;
import java.util.Set;

public class TagInterceptor {
    private final RuleFlags ruleFlags;
    private final boolean isServiceNameSetByUser;
    private final boolean splitByServletContext;
    private final String inferredServiceName;
    private final Set<String> splitServiceTags;

    public TagInterceptor(RuleFlags ruleFlags) {
        this(Config.get().isServiceNameSetByUser(), CapturedEnvironment.get().getProperties().get("service.name"), Config.get().getSplitByTags(), ruleFlags);
    }

    public TagInterceptor(boolean isServiceNameSetByUser, String inferredServiceName, Set<String> splitServiceTags, RuleFlags ruleFlags) {
        this.isServiceNameSetByUser = isServiceNameSetByUser;
        this.inferredServiceName = inferredServiceName;
        this.splitServiceTags = splitServiceTags;
        this.ruleFlags = ruleFlags;
        this.splitByServletContext = splitServiceTags.contains("servlet.context");
    }

    public boolean interceptTag(DDSpanContext span, String tag, Object value) {
        switch (tag) {
            case "resource.name": {
                return this.interceptResourceName(span, value);
            }
            case "db.statement": {
                return this.interceptDbStatement(span, value);
            }
            case "service.name": 
            case "service": {
                return this.interceptServiceName(RuleFlags.Feature.SERVICE_NAME, span, value);
            }
            case "peer.service": {
                return this.interceptServiceName(RuleFlags.Feature.PEER_SERVICE, span, value);
            }
            case "manual.keep": {
                if (TagInterceptor.asBoolean(value)) {
                    span.forceKeep();
                    return true;
                }
                return false;
            }
            case "manual.drop": {
                return this.interceptSamplingPriority(RuleFlags.Feature.FORCE_MANUAL_DROP, -1, 4, span, value);
            }
            case "servlet.context": {
                return this.interceptServletContext(span, value);
            }
            case "span.type": {
                return this.interceptSpanType(span, value);
            }
            case "_dd1.sr.eausr": {
                return this.interceptAnalyticsSampleRate(span, value);
            }
            case "error": {
                return this.interceptError(span, value);
            }
            case "http.status_code": {
                return this.interceptHttpStatusCode(span, value);
            }
            case "_dd.origin": {
                return this.interceptOrigin(span, value);
            }
            case "_dd.measured": {
                return TagInterceptor.interceptMeasured(span, value);
            }
        }
        return this.intercept(span, tag, value);
    }

    private boolean intercept(DDSpanContext span, String tag, Object value) {
        if (this.splitServiceTags.contains(tag)) {
            span.setServiceName(String.valueOf(value));
            return true;
        }
        return false;
    }

    private boolean interceptResourceName(DDSpanContext span, Object value) {
        if (this.ruleFlags.isEnabled(RuleFlags.Feature.RESOURCE_NAME)) {
            if (value instanceof CharSequence) {
                span.setResourceName((CharSequence)value, (byte)5);
            } else {
                span.setResourceName(String.valueOf(value), (byte)5);
            }
            return true;
        }
        return false;
    }

    private boolean interceptDbStatement(DDSpanContext span, Object value) {
        CharSequence resourceName;
        if (value instanceof CharSequence && (resourceName = (CharSequence)value).length() > 0) {
            span.setResourceName(resourceName, (byte)5);
        }
        return true;
    }

    private boolean interceptError(DDSpanContext span, Object value) {
        span.setErrorFlag(TagInterceptor.asBoolean(value));
        return true;
    }

    private boolean interceptAnalyticsSampleRate(DDSpanContext span, Object value) {
        Number analyticsSampleRate = TagInterceptor.getOrTryParse(value);
        if (null != analyticsSampleRate) {
            span.setMetric("_dd1.sr.eausr", analyticsSampleRate);
        }
        return true;
    }

    private boolean interceptSpanType(DDSpanContext span, Object value) {
        if (value instanceof CharSequence) {
            span.setSpanType((CharSequence)value);
        } else {
            span.setSpanType(String.valueOf(value));
        }
        return true;
    }

    private boolean interceptServiceName(RuleFlags.Feature feature, DDSpanContext span, Object value) {
        if (this.ruleFlags.isEnabled(feature)) {
            span.setServiceName(String.valueOf(value));
            return true;
        }
        return false;
    }

    private boolean interceptSamplingPriority(RuleFlags.Feature feature, int samplingPriority, int samplingMechanism, DDSpanContext span, Object value) {
        if (this.ruleFlags.isEnabled(feature)) {
            if (TagInterceptor.asBoolean(value)) {
                span.setSamplingPriority(samplingPriority, samplingMechanism);
            }
            return true;
        }
        return false;
    }

    private boolean interceptServletContext(DDSpanContext span, Object value) {
        if (!(this.splitByServletContext || !this.isServiceNameSetByUser && this.ruleFlags.isEnabled(RuleFlags.Feature.SERVLET_CONTEXT) && (span.getServiceName().isEmpty() || span.getServiceName().equals(this.inferredServiceName) || span.getServiceName().equals("unnamed-java-app")))) {
            return false;
        }
        String contextName = String.valueOf(value).trim();
        if (!contextName.isEmpty()) {
            if (contextName.equals("/")) {
                span.setServiceName(Config.get().getRootContextServiceName());
            } else if (contextName.charAt(0) == '/') {
                if (contextName.length() > 1) {
                    span.setServiceName(contextName.substring(1));
                }
            } else {
                span.setServiceName(contextName);
            }
        }
        return false;
    }

    private boolean interceptHttpStatusCode(DDSpanContext span, Object statusCode) {
        if (statusCode instanceof Number) {
            span.setHttpStatusCode(((Number)statusCode).shortValue());
            return true;
        }
        try {
            span.setHttpStatusCode(Short.parseShort(String.valueOf(statusCode)));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean interceptOrigin(DDSpanContext span, Object origin) {
        if (origin instanceof CharSequence) {
            span.setOrigin((CharSequence)origin);
        } else {
            span.setOrigin(String.valueOf(origin));
        }
        return true;
    }

    private static boolean interceptMeasured(DDSpanContext span, Object value) {
        if (value instanceof Number && ((Number)value).intValue() > 0 || TagInterceptor.asBoolean(value)) {
            span.setMeasured(true);
            return true;
        }
        return false;
    }

    private static boolean asBoolean(Object value) {
        return Boolean.TRUE.equals(value) || !Boolean.FALSE.equals(value) && Boolean.parseBoolean(String.valueOf(value));
    }

    private static Number getOrTryParse(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

