/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.Platform;
import ddtrot.dd.trace.bootstrap.config.provider.ConfigProvider;
import ddtrot.dd.trace.util.CollectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class InstrumenterConfig {
    private final ConfigProvider configProvider;
    private final boolean integrationsEnabled;
    private final boolean logsInjectionEnabled;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final Set<String> traceThreadPoolExecutorsExclude;
    private final String jdbcPreparedStatementClassName;
    private final String jdbcConnectionClassName;
    private final List<String> excludedClasses;
    private final String excludedClassesFile;
    private final Set<String> excludedClassLoaders;
    private final List<String> excludedCodeSources;
    private final boolean resolverOutlinePoolEnabled;
    private final int resolverOutlinePoolSize;
    private final int resolverTypePoolSize;
    private final boolean resolverUseLoadClassEnabled;
    private final boolean runtimeContextFieldInjection;
    private final boolean serialVersionUIDFieldInjection;
    private final String traceAnnotations;
    private final String traceMethods;
    private final boolean internalExitOnFailure;
    @SuppressFBWarnings(value={"SI_INSTANCE_BEFORE_FINALS_ASSIGNED"})
    private static final InstrumenterConfig INSTANCE = new InstrumenterConfig(Platform.isNativeImageBuilder() ? ConfigProvider.withoutCollector() : ConfigProvider.getInstance());

    private InstrumenterConfig() {
        this(ConfigProvider.createDefault());
    }

    private InstrumenterConfig(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        this.integrationsEnabled = configProvider.getBoolean("integrations.enabled", true, new String[0]);
        this.logsInjectionEnabled = configProvider.getBoolean("logs.injection", true, new String[0]);
        this.traceExecutorsAll = configProvider.getBoolean("trace.executors.all", false, new String[0]);
        this.traceExecutors = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.executors"));
        this.traceThreadPoolExecutorsExclude = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.thread-pool-executors.exclude"));
        this.jdbcPreparedStatementClassName = configProvider.getString("trace.jdbc.prepared.statement.class.name", "", new String[0]);
        this.jdbcConnectionClassName = configProvider.getString("trace.jdbc.connection.class.name", "", new String[0]);
        this.excludedClasses = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.classes.exclude"));
        this.excludedClassesFile = configProvider.getString("trace.classes.exclude.file");
        this.excludedClassLoaders = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.classloaders.exclude"));
        this.excludedCodeSources = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.codesources.exclude"));
        this.resolverOutlinePoolEnabled = configProvider.getBoolean("resolver.outline.pool.enabled", true, new String[0]);
        this.resolverOutlinePoolSize = configProvider.getInteger("resolver.outline.pool.size", 128, new String[0]);
        this.resolverTypePoolSize = configProvider.getInteger("resolver.type.pool.size", 64, new String[0]);
        this.resolverUseLoadClassEnabled = configProvider.getBoolean("resolver.use.loadclass", true, new String[0]);
        this.runtimeContextFieldInjection = configProvider.getBoolean("trace.runtime.context.field.injection", true, new String[0]);
        this.serialVersionUIDFieldInjection = configProvider.getBoolean("trace.serialversionuid.field.injection", true, new String[0]);
        this.traceAnnotations = configProvider.getString("trace.annotations", ConfigDefaults.DEFAULT_TRACE_ANNOTATIONS, new String[0]);
        this.traceMethods = configProvider.getString("trace.methods", ConfigDefaults.DEFAULT_TRACE_METHODS, new String[0]);
        this.internalExitOnFailure = configProvider.getBoolean("trace.internal.exit.on.failure", false, new String[0]);
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public boolean isIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "integration.", ".enabled", defaultEnabled);
    }

    public boolean isIntegrationShortcutMatchingEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "integration.", ".matching.shortcut.enabled", defaultEnabled);
    }

    public boolean isLogsInjectionEnabled() {
        return this.logsInjectionEnabled;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public Set<String> getTraceThreadPoolExecutorsExclude() {
        return this.traceThreadPoolExecutorsExclude;
    }

    public String getJdbcPreparedStatementClassName() {
        return this.jdbcPreparedStatementClassName;
    }

    public String getJdbcConnectionClassName() {
        return this.jdbcConnectionClassName;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public String getExcludedClassesFile() {
        return this.excludedClassesFile;
    }

    public Set<String> getExcludedClassLoaders() {
        return this.excludedClassLoaders;
    }

    public List<String> getExcludedCodeSources() {
        return this.excludedCodeSources;
    }

    public boolean isResolverOutlinePoolEnabled() {
        return this.resolverOutlinePoolEnabled;
    }

    public int getResolverOutlinePoolSize() {
        return this.resolverOutlinePoolSize;
    }

    public int getResolverTypePoolSize() {
        return this.resolverTypePoolSize;
    }

    public boolean isResolverUseLoadClassEnabled() {
        return this.resolverUseLoadClassEnabled;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public boolean isSerialVersionUIDFieldInjection() {
        return this.serialVersionUIDFieldInjection;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public String getTraceMethods() {
        return this.traceMethods;
    }

    public boolean isInternalExitOnFailure() {
        return this.internalExitOnFailure;
    }

    public boolean isLegacyInstrumentationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".legacy.tracing.enabled", defaultEnabled);
    }

    public static InstrumenterConfig get() {
        return INSTANCE;
    }

    public String toString() {
        return "InstrumenterConfig{integrationsEnabled=" + this.integrationsEnabled + ", logsInjectionEnabled=" + this.logsInjectionEnabled + ", traceExecutorsAll=" + this.traceExecutorsAll + ", traceExecutors=" + this.traceExecutors + ", jdbcPreparedStatementClassName='" + this.jdbcPreparedStatementClassName + '\'' + ", jdbcConnectionClassName='" + this.jdbcConnectionClassName + '\'' + ", excludedClasses=" + this.excludedClasses + ", excludedClassesFile=" + this.excludedClassesFile + ", excludedClassLoaders=" + this.excludedClassLoaders + ", excludedCodeSources=" + this.excludedCodeSources + ", resolverOutlinePoolEnabled=" + this.resolverOutlinePoolEnabled + ", resolverOutlinePoolSize=" + this.resolverOutlinePoolSize + ", resolverTypePoolSize=" + this.resolverTypePoolSize + ", resolverUseLoadClassEnabled=" + this.resolverUseLoadClassEnabled + ", runtimeContextFieldInjection=" + this.runtimeContextFieldInjection + ", serialVersionUIDFieldInjection=" + this.serialVersionUIDFieldInjection + ", traceAnnotations='" + this.traceAnnotations + '\'' + ", traceMethods='" + this.traceMethods + '\'' + ", internalExitOnFailure=" + this.internalExitOnFailure + ", configProvider=" + this.configProvider + '}';
    }
}

