/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.metrics;

import datadog.trace.api.Config;
import datadog.trace.api.Functions;
import datadog.trace.api.WellKnownTags;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.common.metrics.Aggregator;
import ddtrot.dd.trace.common.metrics.Batch;
import ddtrot.dd.trace.common.metrics.EventListener;
import ddtrot.dd.trace.common.metrics.MetricKey;
import ddtrot.dd.trace.common.metrics.MetricWriter;
import ddtrot.dd.trace.common.metrics.MetricsAggregator;
import ddtrot.dd.trace.common.metrics.OkHttpSink;
import ddtrot.dd.trace.common.metrics.SerializingMetricWriter;
import ddtrot.dd.trace.common.metrics.Sink;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.org.jctools.maps.NonBlockingHashMap;
import ddtrot.org.jctools.queues.MpscBlockingConsumerArrayQueue;
import ddtrot.org.jctools.queues.SpmcArrayQueue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConflatingMetricsAggregator
implements MetricsAggregator,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(ConflatingMetricsAggregator.class);
    private static final Map<String, String> DEFAULT_HEADERS = Collections.singletonMap("Datadog-Meta-Tracer-Version", DDTraceCoreInfo.VERSION);
    private static final DDCache<String, UTF8BytesString> SERVICE_NAMES = DDCaches.newFixedSizeCache(32);
    private static final CharSequence SYNTHETICS_ORIGIN = "synthetics";
    static final Batch POISON_PILL = Batch.NULL;
    private final Set<String> ignoredResources;
    private final Queue<Batch> batchPool;
    private final NonBlockingHashMap<MetricKey, Batch> pending;
    private final NonBlockingHashMap<MetricKey, MetricKey> keys;
    private final Thread thread;
    private final BlockingQueue<Batch> inbox;
    private final Sink sink;
    private final Aggregator aggregator;
    private final long reportingInterval;
    private final TimeUnit reportingIntervalTimeUnit;
    private final DDAgentFeaturesDiscovery features;
    private volatile AgentTaskScheduler.Scheduled<?> cancellation;

    public ConflatingMetricsAggregator(Config config, SharedCommunicationObjects sharedCommunicationObjects) {
        this(config.getWellKnownTags(), config.getMetricsIgnoredResources(), sharedCommunicationObjects.featuresDiscovery(config), new OkHttpSink(sharedCommunicationObjects.okHttpClient, config.getAgentUrl(), "v0.6/stats", config.isTracerMetricsBufferingEnabled(), false, DEFAULT_HEADERS), config.getTracerMetricsMaxAggregates(), config.getTracerMetricsMaxPending());
    }

    ConflatingMetricsAggregator(WellKnownTags wellKnownTags, Set<String> ignoredResources, DDAgentFeaturesDiscovery features, Sink sink, int maxAggregates, int queueSize) {
        this(wellKnownTags, ignoredResources, features, sink, maxAggregates, queueSize, 10L, TimeUnit.SECONDS);
    }

    ConflatingMetricsAggregator(WellKnownTags wellKnownTags, Set<String> ignoredResources, DDAgentFeaturesDiscovery features, Sink sink, int maxAggregates, int queueSize, long reportingInterval, TimeUnit timeUnit) {
        this(ignoredResources, features, sink, new SerializingMetricWriter(wellKnownTags, sink), maxAggregates, queueSize, reportingInterval, timeUnit);
    }

    ConflatingMetricsAggregator(Set<String> ignoredResources, DDAgentFeaturesDiscovery features, Sink sink, MetricWriter metricWriter, int maxAggregates, int queueSize, long reportingInterval, TimeUnit timeUnit) {
        this.ignoredResources = ignoredResources;
        this.inbox = new MpscBlockingConsumerArrayQueue<Batch>(queueSize);
        this.batchPool = new SpmcArrayQueue<Batch>(maxAggregates);
        this.pending = new NonBlockingHashMap(maxAggregates * 4 / 3);
        this.keys = new NonBlockingHashMap();
        this.features = features;
        this.sink = sink;
        this.aggregator = new Aggregator(metricWriter, this.batchPool, this.inbox, this.pending, this.keys.keySet(), maxAggregates, reportingInterval, timeUnit);
        this.thread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.METRICS_AGGREGATOR, this.aggregator);
        this.reportingInterval = reportingInterval;
        this.reportingIntervalTimeUnit = timeUnit;
    }

    @Override
    public void start() {
        if (this.features.getMetricsEndpoint() == null) {
            this.features.discoverIfOutdated();
        }
        if (this.features.supportsMetrics()) {
            this.sink.register(this);
            this.thread.start();
            this.cancellation = AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(new ReportTask(), this, this.reportingInterval, this.reportingInterval, this.reportingIntervalTimeUnit);
            log.debug("started metrics aggregator");
        } else {
            log.debug("metrics not supported by trace agent");
        }
    }

    @Override
    public boolean report() {
        boolean published;
        int attempts = 0;
        while (!(published = this.inbox.offer(Batch.REPORT)) && ++attempts < 10) {
        }
        if (!published) {
            log.debug("Skipped metrics reporting because the queue is full");
        }
        return published;
    }

    @Override
    public boolean publish(List<? extends CoreSpan<?>> trace) {
        boolean forceKeep = false;
        if (this.features.supportsMetrics()) {
            for (CoreSpan<?> span : trace) {
                boolean isTopLevel = span.isTopLevel();
                if (!isTopLevel && !span.isMeasured()) continue;
                if (this.ignoredResources.contains(span.getResourceName().toString())) {
                    return false;
                }
                forceKeep |= this.publish(span, isTopLevel);
            }
        }
        return forceKeep;
    }

    private boolean publish(CoreSpan<?> span, boolean isTopLevel) {
        MetricKey newKey = new MetricKey(span.getResourceName(), SERVICE_NAMES.computeIfAbsent(span.getServiceName(), Functions.UTF8_ENCODE), span.getOperationName(), span.getType(), span.getHttpStatusCode(), ConflatingMetricsAggregator.isSynthetic(span));
        boolean isNewKey = false;
        MetricKey key = this.keys.putIfAbsent(newKey, newKey);
        if (null == key) {
            key = newKey;
            isNewKey = true;
        }
        long tag = (span.getError() > 0 ? Long.MIN_VALUE : 0L) | (isTopLevel ? 0x4000000000000000L : 0L);
        long durationNanos = span.getDurationNano();
        Batch batch = this.pending.get(key);
        if (null != batch) {
            if (batch.add(tag, durationNanos)) {
                return false;
            }
            key = batch.getKey();
            isNewKey = false;
        }
        batch = this.newBatch(key);
        batch.add(tag, durationNanos);
        this.pending.put(key, batch);
        this.inbox.offer(batch);
        return isNewKey || span.getError() > 0;
    }

    private static boolean isSynthetic(CoreSpan<?> span) {
        return span.getOrigin() != null && SYNTHETICS_ORIGIN.equals(span.getOrigin().toString());
    }

    private Batch newBatch(MetricKey key) {
        Batch batch = this.batchPool.poll();
        if (null == batch) {
            return new Batch(key);
        }
        return batch.reset(key);
    }

    public void stop() {
        if (null != this.cancellation) {
            this.cancellation.cancel();
        }
        this.inbox.offer(POISON_PILL);
    }

    @Override
    public void close() {
        this.stop();
        try {
            this.thread.join(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void onEvent(EventListener.EventType eventType, String message) {
        switch (eventType) {
            case DOWNGRADED: {
                log.debug("Agent downgrade was detected");
                this.disable();
                break;
            }
            case BAD_PAYLOAD: {
                log.debug("bad metrics payload sent to trace agent: {}", (Object)message);
                break;
            }
            case ERROR: {
                log.debug("trace agent errored receiving metrics payload: {}", (Object)message);
                break;
            }
        }
    }

    private void disable() {
        this.features.discover();
        if (!this.features.supportsMetrics()) {
            log.debug("Disabling metric reporting because an agent downgrade was detected");
            AgentTaskScheduler.Scheduled<?> cancellation = this.cancellation;
            if (null != cancellation) {
                cancellation.cancel();
            }
            this.thread.interrupt();
            this.pending.clear();
            this.batchPool.clear();
            this.inbox.clear();
            this.aggregator.clearAggregates();
        }
    }

    private static final class ReportTask
    implements AgentTaskScheduler.Task<ConflatingMetricsAggregator> {
        private ReportTask() {
        }

        @Override
        public void run(ConflatingMetricsAggregator target) {
            target.report();
        }
    }
}

