/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.com.squareup.moshi.FromJson;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSamplingRules {
    private static final Logger log = LoggerFactory.getLogger(TraceSamplingRules.class);
    private static final Moshi MOSHI = new Moshi.Builder().add(new RuleAdapter()).build();
    private static final ParameterizedType LIST_OF_RULES = Types.newParameterizedType(List.class, new Type[]{Rule.class});
    private static final JsonAdapter<List<Rule>> LIST_OF_RULES_ADAPTER = MOSHI.adapter(LIST_OF_RULES);
    private final List<Rule> rules;

    public static TraceSamplingRules deserialize(String json) throws IOException {
        return new TraceSamplingRules(LIST_OF_RULES_ADAPTER.fromJson(json));
    }

    public TraceSamplingRules(List<Rule> rules) {
        ArrayList<Rule> notNullRules = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule == null) continue;
            notNullRules.add(rule);
        }
        this.rules = notNullRules;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    private static final class RuleAdapter {
        private RuleAdapter() {
        }

        @FromJson
        Rule fromJson(JsonRule jsonRule) {
            return jsonRule.toRule();
        }
    }

    private static final class JsonRule {
        String service;
        String name;
        String sample_rate;

        private JsonRule() {
        }

        private Rule toRule() {
            return Rule.create(this.service, this.name, this.sample_rate);
        }
    }

    public static final class Rule {
        private final String service;
        private final String name;
        private final double sampleRate;

        public static Rule create(String service, String name, double sampleRate) {
            if (sampleRate < 0.0 || sampleRate > 1.0) {
                Rule.logError(service, name, Double.toString(sampleRate), "sample_rate must be between 0.0 and 1.0");
                return null;
            }
            return new Rule(service, name, sampleRate);
        }

        public static Rule create(String service, String name, String sample_rate) {
            if (sample_rate == null) {
                Rule.logError(service, name, null, "missing mandatory sample_rate");
                return null;
            }
            try {
                return Rule.create(service, name, Double.parseDouble(sample_rate));
            }
            catch (NumberFormatException ex) {
                Rule.logError(service, name, sample_rate, "sample_rate must be a number between 0.0 and 1.0");
                return null;
            }
        }

        private static void logError(String service, String name, String sample_rate, String error) {
            log.error("Skipping invalid Trace Sampling Rule: { \"service\": \"" + service + "\", \"name\": \"" + name + "\", \"sample_rate\": " + sample_rate + " } - " + error);
        }

        private Rule(String service, String name, double sampleRate) {
            this.service = service;
            this.name = name;
            this.sampleRate = sampleRate;
        }

        public String getService() {
            return this.service;
        }

        public String getName() {
            return this.name;
        }

        public double getSampleRate() {
            return this.sampleRate;
        }
    }
}

