/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.dd.trace.bootstrap.instrumentation.api.StatsPoint;
import ddtrot.dd.trace.core.datastreams.StatsGroup;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StatsBucket {
    private final long startTimeNanos;
    private final long bucketDurationNanos;
    private final Map<Long, StatsGroup> hashToGroup = new HashMap<Long, StatsGroup>();

    public StatsBucket(long startTimeNanos, long bucketDurationNanos) {
        this.startTimeNanos = startTimeNanos;
        this.bucketDurationNanos = bucketDurationNanos;
    }

    public void addPoint(StatsPoint statsPoint) {
        StatsGroup statsGroup = this.hashToGroup.get(statsPoint.getHash());
        if (statsGroup == null) {
            statsGroup = new StatsGroup(statsPoint.getEdgeTags(), statsPoint.getHash(), statsPoint.getParentHash());
            this.hashToGroup.put(statsPoint.getHash(), statsGroup);
        }
        statsGroup.add(statsPoint.getPathwayLatencyNano(), statsPoint.getEdgeLatencyNano());
    }

    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public long getBucketDurationNanos() {
        return this.bucketDurationNanos;
    }

    public Collection<StatsGroup> getGroups() {
        return this.hashToGroup.values();
    }
}

