/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.monitor;

import datadog.trace.api.Config;
import datadog.trace.api.Platform;
import ddtrot.com.timgroup.statsd.NoOpStatsDClient;
import ddtrot.com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import ddtrot.com.timgroup.statsd.StatsDClient;
import ddtrot.com.timgroup.statsd.StatsDClientErrorHandler;
import ddtrot.dd.communication.monitor.DDAgentStatsDClientManager;
import ddtrot.dd.trace.relocate.api.IOLogger;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DDAgentStatsDConnection
implements StatsDClientErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(DDAgentStatsDConnection.class);
    private static final IOLogger ioLogger = new IOLogger(log);
    private static final StatsDClient NO_OP = new NoOpStatsDClient();
    private static final String UNIX_DOMAIN_SOCKET_PREFIX = "unix://";
    private static final AgentThreadFactory STATSD_CLIENT_THREAD_FACTORY = new AgentThreadFactory(AgentThreadFactory.AgentThread.STATSD_CLIENT);
    private static final int RETRY_DELAY = 10;
    private static final int MAX_RETRIES = 20;
    private boolean usingDefaultPort;
    private volatile String host;
    private volatile Integer port;
    private final String namedPipe;
    private final AtomicInteger clientCount = new AtomicInteger(0);
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private final AtomicInteger retries = new AtomicInteger(0);
    volatile StatsDClient statsd = NO_OP;

    DDAgentStatsDConnection(String host, Integer port, String namedPipe) {
        this.host = host;
        this.port = port;
        this.namedPipe = namedPipe;
    }

    @Override
    public void handle(Exception e) {
        this.errorCount.incrementAndGet();
        String message = e.getClass().getSimpleName() + " in StatsD client - " + this.statsDAddress();
        ioLogger.error(message, e);
    }

    public void acquire() {
        if (this.clientCount.getAndIncrement() == 0) {
            this.scheduleConnect();
        }
    }

    public void release() {
        if (this.clientCount.decrementAndGet() == 0) {
            this.doClose();
        }
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    private void scheduleConnect() {
        long remainingDelay = (long)Config.get().getDogStatsDStartDelay() - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - Config.get().getStartTimeMillis());
        if (remainingDelay > 0L) {
            if (log.isDebugEnabled()) {
                log.debug("Scheduling StatsD connection in {} seconds - {}", (Object)remainingDelay, (Object)this.statsDAddress());
            }
            AgentTaskScheduler.INSTANCE.scheduleWithJitter(ConnectTask.INSTANCE, this, remainingDelay, TimeUnit.SECONDS);
        } else {
            this.doConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect() {
        DDAgentStatsDConnection dDAgentStatsDConnection = this;
        synchronized (dDAgentStatsDConnection) {
            if (NO_OP == this.statsd && this.clientCount.get() > 0) {
                this.discoverConnectionSettings();
                if (log.isDebugEnabled()) {
                    log.debug("Creating StatsD client - {}", (Object)this.statsDAddress());
                }
                String entityID = this.port == 0 ? "none" : null;
                NonBlockingStatsDClientBuilder clientBuilder = new NonBlockingStatsDClientBuilder().threadFactory(STATSD_CLIENT_THREAD_FACTORY).enableTelemetry(false).hostname(this.host).port(this.port).namedPipe(this.namedPipe).errorHandler(this).entityID(entityID);
                if (this.port == 0) {
                    clientBuilder.maxPacketSizeBytes(Platform.isMac() ? 2048 : 8192);
                }
                try {
                    this.statsd = clientBuilder.build();
                    if (log.isDebugEnabled()) {
                        log.debug("StatsD connected to {}", (Object)this.statsDAddress());
                    }
                }
                catch (Exception e) {
                    log.error("Unable to create StatsD client - {}", (Object)this.statsDAddress(), (Object)e);
                    if (this.retries.getAndIncrement() < 20) {
                        if (log.isDebugEnabled()) {
                            log.debug("Scheduling StatsD connection in {} seconds - {}", (Object)10, (Object)this.statsDAddress());
                        }
                        AgentTaskScheduler.INSTANCE.scheduleWithJitter(ConnectTask.INSTANCE, this, 10L, TimeUnit.SECONDS);
                    }
                    log.debug("Max retries have been reached. Will not attempt again.");
                }
            }
        }
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private void discoverConnectionSettings() {
        if (this.namedPipe != null) {
            return;
        }
        if (null == this.host) {
            if (!Platform.isWindows() && new File("/var/run/datadog/dsd.socket").exists()) {
                log.info("Detected {}.  Using it to send StatsD data.", (Object)"/var/run/datadog/dsd.socket");
                this.host = "/var/run/datadog/dsd.socket";
                this.port = 0;
            } else {
                this.host = Config.get().getAgentHost();
            }
        }
        if (this.host.startsWith(UNIX_DOMAIN_SOCKET_PREFIX)) {
            this.host = this.host.substring(UNIX_DOMAIN_SOCKET_PREFIX.length());
            this.port = 0;
        }
        if (null == this.port) {
            this.port = DDAgentStatsDClientManager.getDefaultStatsDPort();
            this.usingDefaultPort = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDefaultPortChange(int newPort) {
        DDAgentStatsDConnection dDAgentStatsDConnection = this;
        synchronized (dDAgentStatsDConnection) {
            if (NO_OP != this.statsd && this.usingDefaultPort && newPort != this.port) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing StatsD client - {}", (Object)this.statsDAddress());
                }
                try {
                    this.statsd.close();
                }
                finally {
                    this.statsd = NO_OP;
                    this.port = null;
                    this.doConnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        DDAgentStatsDConnection dDAgentStatsDConnection = this;
        synchronized (dDAgentStatsDConnection) {
            if (NO_OP != this.statsd && 0 == this.clientCount.get()) {
                if (log.isDebugEnabled()) {
                    log.debug("Closing StatsD client - {}", (Object)this.statsDAddress());
                }
                try {
                    this.statsd.close();
                }
                catch (Exception e) {
                    log.debug("Problem closing StatsD client - {}", (Object)this.statsDAddress(), (Object)e);
                }
                finally {
                    this.statsd = NO_OP;
                }
            }
        }
    }

    private String statsDAddress() {
        if (this.namedPipe != null) {
            return this.namedPipe;
        }
        return (null != this.host ? this.host : "<auto-detect>") + (null != this.port && this.port > 0 ? ":" + this.port : "");
    }

    private static final class ConnectTask
    implements AgentTaskScheduler.Task<DDAgentStatsDConnection> {
        public static final ConnectTask INSTANCE = new ConnectTask();

        private ConnectTask() {
        }

        @Override
        public void run(DDAgentStatsDConnection target) {
            target.doConnect();
        }
    }
}

