/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast;

import ddtrot.dd.trace.api.iast.IastModule;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstrumentationBridge {
    private static final Logger LOG = LoggerFactory.getLogger(InstrumentationBridge.class);
    private static volatile IastModule MODULE;

    private InstrumentationBridge() {
    }

    public static void registerIastModule(IastModule module) {
        MODULE = module;
    }

    public static void onCipherGetInstance(@Nonnull String algorithm) {
        try {
            if (MODULE != null) {
                MODULE.onCipherAlgorithm(algorithm);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onCipher threw.", t);
        }
    }

    public static void onMessageDigestGetInstance(@Nonnull String algorithm) {
        try {
            if (MODULE != null) {
                MODULE.onHashingAlgorithm(algorithm);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onHash threw.", t);
        }
    }

    public static void onParameterName(String parameterName) {
        try {
            if (MODULE != null) {
                MODULE.onParameterName(parameterName);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onParameterName threw.", t);
        }
    }

    public static void onParameterValue(String paramName, String paramValue) {
        try {
            if (MODULE != null) {
                MODULE.onParameterValue(paramName, paramValue);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onParameterValue threw.", t);
        }
    }

    public static void onStringConcat(@Nonnull String self, @Nullable String param, @Nonnull String result) {
        try {
            if (MODULE != null) {
                MODULE.onStringConcat(self, param, result);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onStringConcat threw.", t);
        }
    }

    public static void onStringBuilderInit(@Nonnull StringBuilder self, @Nullable CharSequence param) {
        try {
            if (MODULE != null) {
                MODULE.onStringBuilderInit(self, param);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onStringBuilderInit threw.", t);
        }
    }

    public static void onStringBuilderAppend(@Nonnull StringBuilder self, @Nullable CharSequence param) {
        try {
            if (MODULE != null) {
                MODULE.onStringBuilderAppend(self, param);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onStringBuilderAppend threw.", t);
        }
    }

    public static void onStringBuilderToString(@Nonnull StringBuilder self, @Nonnull String result) {
        try {
            if (MODULE != null) {
                MODULE.onStringBuilderToString(self, result);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onStringBuilderToString threw.", t);
        }
    }

    public static String onStringConcatFactory(String result, String[] arguments, String recipe, Object[] constants, int[] recipeOffsets) {
        try {
            if (MODULE != null) {
                MODULE.onStringConcatFactory(result, arguments, recipe, constants, recipeOffsets);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onStringConcatFactory threw.", t);
        }
        return result;
    }

    public static void onJdbcQuery(String query) {
        try {
            if (MODULE != null) {
                MODULE.onJdbcQuery(query);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onJdbcQuery threw.", t);
        }
    }

    public static void onRuntimeExec(String ... command) {
        try {
            if (MODULE != null) {
                MODULE.onRuntimeExec(command);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onRuntimeExec threw.", t);
        }
    }

    public static void onProcessBuilderStart(@Nonnull List<String> command) {
        try {
            if (MODULE != null) {
                MODULE.onProcessBuilderStart(command);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onProcessBuilderStart threw.", t);
        }
    }

    public static void onPathTraversal(@Nonnull String path) {
        try {
            if (MODULE != null) {
                MODULE.onPathTraversal(path);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onPathTraversal threw.", t);
        }
    }

    public static void onPathTraversal(@Nullable String parent, @Nonnull String child) {
        try {
            if (MODULE != null) {
                MODULE.onPathTraversal(parent, child);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onPathTraversal threw.", t);
        }
    }

    public static void onPathTraversal(@Nonnull String first, @Nonnull String[] more) {
        try {
            if (MODULE != null) {
                MODULE.onPathTraversal(first, more);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onPathTraversal threw.", t);
        }
    }

    public static void onPathTraversal(@Nullable File parent, @Nonnull String path) {
        try {
            if (MODULE != null) {
                MODULE.onPathTraversal(parent, path);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onPathTraversal threw.", t);
        }
    }

    public static void onPathTraversal(@Nonnull URI uri) {
        try {
            if (MODULE != null) {
                MODULE.onPathTraversal(uri);
            }
        }
        catch (Throwable t) {
            InstrumentationBridge.onUnexpectedException("Callback for onPathTraversal threw.", t);
        }
    }

    private static void onUnexpectedException(String message, Throwable error) {
        LOG.warn(message, error);
    }
}

