/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.metrics;

import ddtrot.dd.trace.common.metrics.AggregateMetric;
import ddtrot.dd.trace.common.metrics.MetricKey;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongArray;

public final class Batch {
    private static final int MAX_BATCH_SIZE = 64;
    private static final AtomicIntegerFieldUpdater<Batch> COUNT = AtomicIntegerFieldUpdater.newUpdater(Batch.class, "count");
    private static final AtomicIntegerFieldUpdater<Batch> COMMITTED = AtomicIntegerFieldUpdater.newUpdater(Batch.class, "committed");
    static final Batch NULL = new Batch((AtomicLongArray)null);
    static final Batch REPORT = new Batch((AtomicLongArray)null);
    private volatile int count = 0;
    private volatile int committed = 0;
    private MetricKey key;
    private final AtomicLongArray durations;

    Batch(MetricKey key) {
        this(new AtomicLongArray(64));
        this.key = key;
    }

    Batch() {
        this(new AtomicLongArray(64));
    }

    private Batch(AtomicLongArray durations) {
        this.durations = durations;
    }

    public MetricKey getKey() {
        return this.key;
    }

    public Batch reset(MetricKey key) {
        this.key = key;
        COUNT.lazySet(this, 0);
        return this;
    }

    public boolean isUsed() {
        return this.count < 0;
    }

    public boolean add(long tag, long durationNanos) {
        int position = COUNT.getAndIncrement(this);
        if (position >= 0 && position < this.durations.length()) {
            this.durations.set(position, tag | durationNanos);
            COMMITTED.getAndIncrement(this);
            return true;
        }
        return false;
    }

    public void contributeTo(AggregateMetric aggregate) {
        int count = Math.min(COUNT.getAndSet(this, Integer.MIN_VALUE), 64);
        if (count >= 0) {
            while (this.committed != count) {
                Thread.yield();
            }
            COMMITTED.lazySet(this, 0);
            aggregate.recordDurations(count, this.durations);
        }
    }
}

