/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import datadog.trace.api.Config;
import datadog.trace.api.StatsDClient;
import ddtrot.dd.trace.api.scopemanager.ExtendedScopeListener;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScopeManager;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTrace;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AttachableWrapper;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ContextThreadListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContinuableScopeManager
implements AgentScopeManager {
    static final Logger log = LoggerFactory.getLogger(ContinuableScopeManager.class);
    final ScopeStackThreadLocal tlsScopeStack;
    static final long iterationKeepAlive = TimeUnit.SECONDS.toMillis(Config.get().getScopeIterationKeepAlive());
    volatile ConcurrentMap<ScopeStack, ContinuableScope> rootIterationScopes;
    final List<ScopeListener> scopeListeners;
    final List<ExtendedScopeListener> extendedScopeListeners;
    final StatsDClient statsDClient;
    private final int depthLimit;
    private final boolean strictMode;
    private final boolean inheritAsyncPropagation;

    public ContinuableScopeManager(int depthLimit, StatsDClient statsDClient, boolean strictMode, boolean inheritAsyncPropagation) {
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.statsDClient = statsDClient;
        this.strictMode = strictMode;
        this.inheritAsyncPropagation = inheritAsyncPropagation;
        this.scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
        this.extendedScopeListeners = new CopyOnWriteArrayList<ExtendedScopeListener>();
        this.tlsScopeStack = new ScopeStackThreadLocal();
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source) {
        return this.activate(span, source.id(), false, false);
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.activate(span, source.id(), true, isAsyncPropagating);
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
        SingleContinuation continuation = new SingleContinuation(this, span, source.id());
        continuation.register();
        return continuation;
    }

    private AgentScope activate(AgentSpan span, byte source, boolean overrideAsyncPropagation, boolean isAsyncPropagating) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.span.equals(span)) {
            top.incrementReferences();
            return top;
        }
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        boolean asyncPropagation = overrideAsyncPropagation ? isAsyncPropagating : (this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true);
        ContinuableScope scope = new ContinuableScope(this, span, source, asyncPropagation);
        scopeStack.push(scope);
        return scope;
    }

    ContinuableScope continueSpan(Continuation continuation, AgentSpan span, byte source) {
        ContinuableScope scope = continuation != null ? new ContinuingScope(this, span, source, true, continuation) : new ContinuableScope(this, span, source, true);
        this.scopeStack().push(scope);
        return scope;
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        ScopeStack scopeStack = this.scopeStack();
        ContinuableScope top = scopeStack.top;
        if (top != null && top.source() == ScopeSource.ITERATION.id()) {
            if (iterationKeepAlive > 0L) {
                this.cancelRootIterationScopeCleanup(scopeStack, top);
            }
            top.close();
            scopeStack.cleanup();
            if (finishSpan) {
                top.span.finishWithEndToEnd();
            }
        }
    }

    public void detach() {
        this.tlsScopeStack.detach();
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        ScopeStack scopeStack = this.scopeStack();
        int currentDepth = scopeStack.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        assert (span != null);
        ContinuableScope top = scopeStack.top;
        boolean asyncPropagation = this.inheritAsyncPropagation && top != null ? top.isAsyncPropagating() : true;
        ContinuableScope scope = new ContinuableScope(this, span, ScopeSource.ITERATION.id(), asyncPropagation);
        if (iterationKeepAlive > 0L && currentDepth == 0) {
            this.scheduleRootIterationScopeCleanup(scopeStack, scope);
        }
        scopeStack.push(scope);
        return scope;
    }

    @Override
    public AgentScope active() {
        return this.scopeStack().active();
    }

    @Override
    public AgentSpan activeSpan() {
        ContinuableScope active = this.scopeStack().active();
        return active == null ? null : active.span;
    }

    public void addContextThreadListener(ContextThreadListener listener) {
        this.tlsScopeStack.register(listener);
    }

    public void addScopeListener(ScopeListener listener) {
        if (listener instanceof ExtendedScopeListener) {
            this.addExtendedScopeListener((ExtendedScopeListener)listener);
        } else {
            this.scopeListeners.add(listener);
            log.debug("Added scope listener {}", (Object)listener);
            AgentSpan activeSpan = this.activeSpan();
            if (activeSpan != null) {
                listener.afterScopeActivated();
            }
        }
    }

    private void addExtendedScopeListener(ExtendedScopeListener listener) {
        this.extendedScopeListeners.add(listener);
        log.debug("Added scope listener {}", (Object)listener);
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan != null && activeSpan != AgentTracer.NoopAgentSpan.INSTANCE) {
            listener.afterScopeActivated(activeSpan.getTraceId(), activeSpan.getLocalRootSpan().getSpanId(), activeSpan.context().getSpanId());
        }
    }

    ScopeStack scopeStack() {
        return (ScopeStack)this.tlsScopeStack.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes == null) {
            ContinuableScopeManager continuableScopeManager = this;
            synchronized (continuableScopeManager) {
                if (this.rootIterationScopes == null) {
                    this.rootIterationScopes = new ConcurrentHashMap<ScopeStack, ContinuableScope>();
                    RootIterationCleaner.scheduleFor(this.rootIterationScopes);
                }
            }
        }
        this.rootIterationScopes.put(scopeStack, scope);
    }

    private void cancelRootIterationScopeCleanup(ScopeStack scopeStack, ContinuableScope scope) {
        if (this.rootIterationScopes != null) {
            this.rootIterationScopes.remove(scopeStack, scope);
        }
    }

    private static final class RootIterationCleaner
    implements AgentTaskScheduler.Task<Map<ScopeStack, ContinuableScope>> {
        private static final RootIterationCleaner CLEANER = new RootIterationCleaner();

        private RootIterationCleaner() {
        }

        public static void scheduleFor(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            long period = Math.min(iterationKeepAlive, 10000L);
            AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(CLEANER, rootIterationScopes, iterationKeepAlive, period, TimeUnit.MILLISECONDS);
        }

        @Override
        public void run(Map<ScopeStack, ContinuableScope> rootIterationScopes) {
            Iterator<Map.Entry<ScopeStack, ContinuableScope>> itr = rootIterationScopes.entrySet().iterator();
            long cutOff = System.currentTimeMillis() - iterationKeepAlive;
            while (itr.hasNext()) {
                Map.Entry<ScopeStack, ContinuableScope> entry = itr.next();
                ScopeStack scopeStack = entry.getKey();
                ContinuableScope rootScope = entry.getValue();
                if (!rootScope.alive()) {
                    itr.remove();
                    continue;
                }
                if (TimeUnit.NANOSECONDS.toMillis(rootScope.span.getStartTime()) >= cutOff) continue;
                scopeStack.overdueRootScope = rootScope;
                rootScope.span.finishWithEndToEnd();
                itr.remove();
            }
        }
    }

    private static final class ConcurrentContinuation
    extends Continuation {
        private static final int START = 1;
        private static final int CLOSED = -1073741824;
        private static final int BARRIER = -536870912;
        private volatile int count = 1;
        private static final AtomicIntegerFieldUpdater<ConcurrentContinuation> COUNT = AtomicIntegerFieldUpdater.newUpdater(ConcurrentContinuation.class, "count");

        public ConcurrentContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            super(scopeManager, spanUnderScope, source);
        }

        private boolean tryActivate() {
            int current = COUNT.incrementAndGet(this);
            if (current < 1) {
                COUNT.decrementAndGet(this);
            }
            return current > 1;
        }

        private boolean tryClose() {
            int current = COUNT.get(this);
            if (current < -536870912) {
                return false;
            }
            current = COUNT.decrementAndGet(this);
            while (current < 1 && current > -536870912) {
                if (COUNT.compareAndSet(this, current, -1073741824)) {
                    return true;
                }
                current = COUNT.get(this);
            }
            return false;
        }

        @Override
        public AgentScope activate() {
            if (this.tryActivate()) {
                ContinuableScope scope = this.scopeManager.continueSpan(this, this.spanUnderScope, this.source);
                this.spanUnderScope.startWork();
                return scope;
            }
            return null;
        }

        @Override
        public void cancel() {
            if (this.tryClose()) {
                this.trace.cancelContinuation(this);
            }
            log.debug("t_id={} -> canceling continuation {}", (Object)this.spanUnderScope.getTraceId(), (Object)this);
        }

        @Override
        public AgentSpan getSpan() {
            return this.spanUnderScope;
        }

        @Override
        void cancelFromContinuedScopeClose() {
            this.spanUnderScope.finishWork();
            this.cancel();
        }

        public String toString() {
            int c = COUNT.get(this);
            String s = c < -536870912 ? "CANCELED" : String.valueOf(c);
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "(" + s + ")->" + this.spanUnderScope;
        }
    }

    private static final class SingleContinuation
    extends Continuation {
        private static final AtomicIntegerFieldUpdater<SingleContinuation> USED = AtomicIntegerFieldUpdater.newUpdater(SingleContinuation.class, "used");
        private volatile int used = 0;

        private SingleContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            super(scopeManager, spanUnderScope, source);
        }

        @Override
        public AgentScope activate() {
            if (USED.compareAndSet(this, 0, 1)) {
                return this.scopeManager.continueSpan(this, this.spanUnderScope, this.source);
            }
            log.debug("Failed to activate continuation. Reusing a continuation not allowed. Spans may be reported separately.");
            return this.scopeManager.continueSpan(null, this.spanUnderScope, this.source);
        }

        @Override
        public void cancel() {
            if (USED.compareAndSet(this, 0, 1)) {
                this.trace.cancelContinuation(this);
            } else {
                log.debug("Failed to close continuation {}. Already used.", (Object)this);
            }
        }

        @Override
        public AgentSpan getSpan() {
            return this.spanUnderScope;
        }

        @Override
        void cancelFromContinuedScopeClose() {
            this.trace.cancelContinuation(this);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.spanUnderScope;
        }
    }

    private static abstract class Continuation
    implements AgentScope.Continuation {
        final ContinuableScopeManager scopeManager;
        final AgentSpan spanUnderScope;
        final byte source;
        final AgentTrace trace;

        public Continuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
            this.scopeManager = scopeManager;
            this.spanUnderScope = spanUnderScope;
            this.source = source;
            this.trace = spanUnderScope.context().getTrace();
        }

        Continuation register() {
            this.trace.registerContinuation(this);
            return this;
        }

        abstract void cancelFromContinuedScopeClose();
    }

    static final class ScopeStack {
        private final Runnable onFirstUsage;
        private boolean used = false;
        private final ArrayDeque<ContinuableScope> stack = new ArrayDeque();
        ContinuableScope top;
        volatile ContinuableScope overdueRootScope;

        ScopeStack(Runnable onFirstUsage) {
            this.onFirstUsage = onFirstUsage;
        }

        ContinuableScope active() {
            return this.top != this.overdueRootScope ? this.top : null;
        }

        void cleanup() {
            ContinuableScope curScope = this.top;
            boolean changedTop = false;
            while (curScope != null && !curScope.alive()) {
                curScope.onProperClose();
                changedTop = true;
                curScope = this.stack.poll();
            }
            if (curScope != null && curScope == this.overdueRootScope) {
                curScope.onProperClose();
                this.overdueRootScope = null;
                this.top = null;
            } else if (changedTop) {
                this.top = curScope;
                if (curScope != null) {
                    curScope.afterActivated();
                }
            }
        }

        void push(ContinuableScope scope) {
            this.notifyOnFirstPush();
            if (this.top != null) {
                this.stack.push(this.top);
            }
            this.top = scope;
            scope.afterActivated();
            this.top.span.startWork();
        }

        boolean checkTop(ContinuableScope expectedScope) {
            return expectedScope.equals(this.top);
        }

        final boolean checkOverdueScopes(ContinuableScope expectedScope) {
            if (this.top == null || this.top.source() != ScopeSource.ITERATION.id()) {
                return false;
            }
            this.top.clearReferences();
            this.top.span.finishWithEndToEnd();
            for (ContinuableScope scope : this.stack) {
                if (scope.source() != ScopeSource.ITERATION.id()) {
                    return expectedScope.equals(scope);
                }
                scope.clearReferences();
                scope.span.finishWithEndToEnd();
            }
            return false;
        }

        int depth() {
            return this.top != null ? 1 + this.stack.size() : 0;
        }

        void clear() {
            this.stack.clear();
            this.top = null;
        }

        private void notifyOnFirstPush() {
            if (!this.used) {
                this.used = true;
                this.onFirstUsage.run();
            }
        }
    }

    static final class ScopeStackThreadLocal
    extends ThreadLocal<ScopeStack> {
        private final List<ContextThreadListener> listeners = new CopyOnWriteArrayList<ContextThreadListener>();

        ScopeStackThreadLocal() {
        }

        public void register(ContextThreadListener listener) {
            this.listeners.add(listener);
        }

        @Override
        protected ScopeStack initialValue() {
            return new ScopeStack(new Runnable(){

                @Override
                public void run() {
                    for (ContextThreadListener listener : listeners) {
                        listener.onAttach();
                    }
                }
            });
        }

        @Override
        public void remove() {
            this.detach();
            super.remove();
        }

        private void detach() {
            for (ContextThreadListener listener : this.listeners) {
                listener.onDetach();
            }
        }
    }

    private static final class ContinuingScope
    extends ContinuableScope {
        private final Continuation continuation;

        ContinuingScope(ContinuableScopeManager scopeManager, AgentSpan span, byte source, boolean isAsyncPropagating, Continuation continuation) {
            super(scopeManager, span, source, isAsyncPropagating);
            this.continuation = continuation;
        }

        @Override
        void cleanup(ScopeStack scopeStack) {
            super.cleanup(scopeStack);
            this.continuation.cancelFromContinuedScopeClose();
        }
    }

    private static class ContinuableScope
    implements AgentScope,
    AttachableWrapper {
        private final ContinuableScopeManager scopeManager;
        final AgentSpan span;
        private boolean isAsyncPropagating;
        private final byte flags;
        private short referenceCount = 1;
        private volatile Object wrapper;
        private static final AtomicReferenceFieldUpdater<ContinuableScope, Object> WRAPPER_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ContinuableScope.class, Object.class, "wrapper");

        ContinuableScope(ContinuableScopeManager scopeManager, AgentSpan span, byte source, boolean isAsyncPropagating) {
            this.scopeManager = scopeManager;
            this.span = span;
            this.flags = source;
            this.isAsyncPropagating = isAsyncPropagating;
        }

        @Override
        public final void close() {
            boolean alive;
            ScopeStack scopeStack = this.scopeManager.scopeStack();
            if (!scopeStack.checkTop(this) && !scopeStack.checkOverdueScopes(this)) {
                if (log.isDebugEnabled()) {
                    log.debug("Tried to close {} scope when not on top.  Current top: {}", (Object)this, (Object)scopeStack.top);
                }
                this.scopeManager.statsDClient.incrementCounter("scope.close.error", new String[0]);
                if (this.source() == ScopeSource.MANUAL.id()) {
                    this.scopeManager.statsDClient.incrementCounter("scope.user.close.error", new String[0]);
                    if (this.scopeManager.strictMode) {
                        throw new RuntimeException("Tried to close scope when not on top");
                    }
                }
            }
            if (!(alive = this.decrementReferences())) {
                this.cleanup(scopeStack);
            }
        }

        void cleanup(ScopeStack scopeStack) {
            scopeStack.cleanup();
        }

        final void onProperClose() {
            this.span.finishWork();
            for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
                try {
                    scopeListener.afterScopeClosed();
                }
                catch (Exception e) {
                    log.debug("ScopeListener threw exception in close()", (Throwable)e);
                }
            }
            for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
                try {
                    extendedScopeListener.afterScopeClosed();
                }
                catch (Exception e) {
                    log.debug("ScopeListener threw exception in close()", (Throwable)e);
                }
            }
        }

        final void incrementReferences() {
            this.referenceCount = (short)(this.referenceCount + 1);
        }

        final boolean decrementReferences() {
            this.referenceCount = (short)(this.referenceCount - 1);
            return this.referenceCount > 0;
        }

        final void clearReferences() {
            this.referenceCount = 0;
        }

        final boolean alive() {
            return this.referenceCount > 0;
        }

        @Override
        public final boolean isAsyncPropagating() {
            return this.isAsyncPropagating;
        }

        @Override
        public final AgentSpan span() {
            return this.span;
        }

        @Override
        public final void setAsyncPropagation(boolean value) {
            this.isAsyncPropagating = value;
        }

        @Override
        public final Continuation capture() {
            return this.isAsyncPropagating ? new SingleContinuation(this.scopeManager, this.span, this.source()).register() : null;
        }

        @Override
        public final Continuation captureConcurrent() {
            return this.isAsyncPropagating ? new ConcurrentContinuation(this.scopeManager, this.span, this.source()).register() : null;
        }

        public final String toString() {
            return super.toString() + "->" + this.span;
        }

        public final void afterActivated() {
            for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
                try {
                    scopeListener.afterScopeActivated();
                }
                catch (Throwable e) {
                    log.debug("ScopeListener threw exception in afterActivated()", e);
                }
            }
            for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
                try {
                    extendedScopeListener.afterScopeActivated(this.span.getTraceId(), this.span.getLocalRootSpan().getSpanId(), this.span.context().getSpanId());
                }
                catch (Throwable e) {
                    log.debug("ExtendedScopeListener threw exception in afterActivated()", e);
                }
            }
        }

        @Override
        public byte source() {
            return (byte)(this.flags & 0x7F);
        }

        @Override
        public void attachWrapper(@Nonnull Object wrapper) {
            WRAPPER_FIELD_UPDATER.set(this, wrapper);
        }

        @Override
        public Object getWrapper() {
            return WRAPPER_FIELD_UPDATER.get(this);
        }
    }
}

