/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.jnr.constants.platform.dragonflybsd;

import ddtrot.jnr.constants.Constant;
import java.util.EnumMap;
import java.util.Map;

public enum WaitFlags implements Constant
{
    WNOHANG(1L),
    WUNTRACED(2L),
    WSTOPPED(2L),
    WEXITED(16L),
    WCONTINUED(4L),
    WNOWAIT(8L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 16L;

    private WaitFlags(long value) {
        this.value = value;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<WaitFlags, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<WaitFlags, String> generateTable() {
            EnumMap<WaitFlags, String> map = new EnumMap<WaitFlags, String>(WaitFlags.class);
            map.put(WNOHANG, "WNOHANG");
            map.put(WUNTRACED, "WUNTRACED");
            map.put(WSTOPPED, "WSTOPPED");
            map.put(WEXITED, "WEXITED");
            map.put(WCONTINUED, "WCONTINUED");
            map.put(WNOWAIT, "WNOWAIT");
            return map;
        }
    }
}

