/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigCollector;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.InstrumenterConfig;
import datadog.trace.api.Platform;
import datadog.trace.api.ProductActivationConfig;
import datadog.trace.api.PropagationStyle;
import datadog.trace.api.WellKnownTags;
import ddtrot.dd.trace.bootstrap.config.provider.CapturedEnvironmentConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.ConfigProvider;
import ddtrot.dd.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import ddtrot.dd.trace.util.CollectionUtils;
import ddtrot.dd.trace.util.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private final InstrumenterConfig instrumenterConfig = InstrumenterConfig.get();
    private final long startTimeMillis = System.currentTimeMillis();
    private final String runtimeId;
    private final String runtimeVersion;
    private final String apiKey;
    private final String site;
    private final String hostName;
    private final String serviceName;
    private final boolean serviceNameSetByUser;
    private final String rootContextServiceName;
    private final boolean traceEnabled;
    private final boolean integrationSynapseLegacyOperationName;
    private final String writerType;
    private final boolean agentConfiguredUsingDefault;
    private final String agentUrl;
    private final String agentHost;
    private final int agentPort;
    private final String agentUnixDomainSocket;
    private final String agentNamedPipe;
    private final int agentTimeout;
    private final Set<String> noProxyHosts;
    private final boolean prioritySamplingEnabled;
    private final String prioritySamplingForce;
    private final boolean traceResolverEnabled;
    private final Map<String, String> serviceMapping;
    private final Map<String, String> tags;
    private final Map<String, String> spanTags;
    private final Map<String, String> jmxTags;
    private final Map<String, String> requestHeaderTags;
    private final Map<String, String> responseHeaderTags;
    private final BitSet httpServerErrorStatuses;
    private final BitSet httpClientErrorStatuses;
    private final boolean httpServerTagQueryString;
    private final boolean httpServerRawQueryString;
    private final boolean httpServerRawResource;
    private final boolean httpServerRouteBasedNaming;
    private final Map<String, String> httpServerPathResourceNameMapping;
    private final boolean httpClientTagQueryString;
    private final boolean httpClientSplitByDomain;
    private final boolean dbClientSplitByInstance;
    private final boolean dbClientSplitByInstanceTypeSuffix;
    private final Set<String> splitByTags;
    private final int scopeDepthLimit;
    private final boolean scopeStrictMode;
    private final boolean scopeInheritAsyncPropagation;
    private final int scopeIterationKeepAlive;
    private final int partialFlushMinSpans;
    private final boolean traceStrictWritesEnabled;
    private final boolean logExtractHeaderNames;
    private final Set<PropagationStyle> propagationStylesToExtract;
    private final Set<PropagationStyle> propagationStylesToInject;
    private final int clockSyncPeriod;
    private final String dogStatsDNamedPipe;
    private final int dogStatsDStartDelay;
    private final boolean jmxFetchEnabled;
    private final String jmxFetchConfigDir;
    private final List<String> jmxFetchConfigs;
    @Deprecated
    private final List<String> jmxFetchMetricsConfigs;
    private final Integer jmxFetchCheckPeriod;
    private final Integer jmxFetchInitialRefreshBeansPeriod;
    private final Integer jmxFetchRefreshBeansPeriod;
    private final String jmxFetchStatsdHost;
    private final Integer jmxFetchStatsdPort;
    private final boolean jmxFetchMultipleRuntimeServicesEnabled;
    private final int jmxFetchMultipleRuntimeServicesLimit;
    private final boolean healthMetricsEnabled;
    private final String healthMetricsStatsdHost;
    private final Integer healthMetricsStatsdPort;
    private final boolean perfMetricsEnabled;
    private final boolean tracerMetricsEnabled;
    private final boolean tracerMetricsBufferingEnabled;
    private final int tracerMetricsMaxAggregates;
    private final int tracerMetricsMaxPending;
    private final boolean logsMDCTagsInjectionEnabled;
    private final boolean reportHostName;
    private final boolean traceAnalyticsEnabled;
    private final String traceClientIpHeader;
    private final boolean traceClientIpResolverEnabled;
    private final Map<String, String> traceSamplingServiceRules;
    private final Map<String, String> traceSamplingOperationRules;
    private final String traceSamplingRules;
    private final Double traceSampleRate;
    private final int traceRateLimit;
    private final boolean profilingEnabled;
    private final boolean profilingAgentless;
    private final boolean isAsyncProfilerEnabled;
    private final boolean isDirectAllocationProfilingEnabled;
    @Deprecated
    private final String profilingUrl;
    private final Map<String, String> profilingTags;
    private final int profilingStartDelay;
    private final boolean profilingStartForceFirst;
    private final int profilingUploadPeriod;
    private final String profilingTemplateOverrideFile;
    private final int profilingUploadTimeout;
    private final String profilingUploadCompression;
    private final String profilingProxyHost;
    private final int profilingProxyPort;
    private final String profilingProxyUsername;
    private final String profilingProxyPassword;
    private final int profilingExceptionSampleLimit;
    private final int profilingDirectAllocationSampleLimit;
    private final int profilingExceptionHistogramTopItems;
    private final int profilingExceptionHistogramMaxCollectionSize;
    private final boolean profilingExcludeAgentThreads;
    private final boolean profilingHotspotsEnabled;
    private final boolean profilingUploadSummaryOn413Enabled;
    private final boolean crashTrackingAgentless;
    private final Map<String, String> crashTrackingTags;
    private final boolean clientIpEnabled;
    private final ProductActivationConfig appSecEnabled;
    private final boolean appSecReportingInband;
    private final String appSecRulesFile;
    private final int appSecReportMinTimeout;
    private final int appSecReportMaxTimeout;
    private final int appSecTraceRateLimit;
    private final boolean appSecWafMetrics;
    private final String appSecObfuscationParameterKeyRegexp;
    private final String appSecObfuscationParameterValueRegexp;
    private final String appSecHttpBlockedTemplateHtml;
    private final String appSecHttpBlockedTemplateJson;
    private final boolean iastEnabled;
    private final int iastMaxConcurrentRequests;
    private final int iastVulnerabilitiesPerRequest;
    private final float iastRequestSampling;
    private final boolean iastTaintTrackingDebugEnabled;
    private final boolean ciVisibilityEnabled;
    private final boolean ciVisibilityAgentlessEnabled;
    private final String ciVisibilityAgentlessUrl;
    private final boolean remoteConfigEnabled;
    private final boolean remoteConfigIntegrityCheckEnabled;
    private final String remoteConfigUrl;
    private final int remoteConfigInitialPollInterval;
    private final long remoteConfigMaxPayloadSize;
    private final String remoteConfigTargetsKeyId;
    private final String remoteConfigTargetsKey;
    private final boolean debuggerEnabled;
    private final int debuggerUploadTimeout;
    private final int debuggerUploadFlushInterval;
    private final boolean debuggerClassFileDumpEnabled;
    private final int debuggerPollInterval;
    private final int debuggerDiagnosticsInterval;
    private final boolean debuggerMetricEnabled;
    private final String debuggerProbeFileLocation;
    private final int debuggerUploadBatchSize;
    private final long debuggerMaxPayloadSize;
    private final boolean debuggerVerifyByteCode;
    private final boolean debuggerInstrumentTheWorld;
    private final String debuggerExcludeFile;
    private final boolean awsPropagationEnabled;
    private final boolean sqsPropagationEnabled;
    private final boolean kafkaClientPropagationEnabled;
    private final Set<String> kafkaClientPropagationDisabledTopics;
    private final boolean kafkaClientBase64DecodingEnabled;
    private final boolean jmsPropagationEnabled;
    private final Set<String> jmsPropagationDisabledTopics;
    private final Set<String> jmsPropagationDisabledQueues;
    private final boolean rabbitPropagationEnabled;
    private final Set<String> rabbitPropagationDisabledQueues;
    private final Set<String> rabbitPropagationDisabledExchanges;
    private final boolean rabbitIncludeRoutingKeyInResource;
    private final boolean messageBrokerSplitByDestination;
    private final boolean hystrixTagsEnabled;
    private final boolean hystrixMeasuredEnabled;
    private final boolean igniteCacheIncludeKeys;
    private final String obfuscationQueryRegexp;
    private final boolean playReportHttpStatus;
    private final boolean servletPrincipalEnabled;
    private final boolean servletAsyncTimeoutError;
    private final int xDatadogTagsMaxLength;
    private final boolean traceAgentV05Enabled;
    private final boolean debugEnabled;
    private final String configFileStatus;
    private final IdGenerationStrategy idGenerationStrategy;
    private final boolean secureRandom;
    private final Set<String> grpcIgnoredInboundMethods;
    private final Set<String> grpcIgnoredOutboundMethods;
    private final boolean grpcServerTrimPackageResource;
    private final BitSet grpcServerErrorStatuses;
    private final BitSet grpcClientErrorStatuses;
    private final boolean cwsEnabled;
    private final int cwsTlsRefresh;
    private final boolean dataStreamsEnabled;
    private final Set<String> iastWeakHashAlgorithms;
    private final Pattern iastWeakCipherAlgorithms;
    private final boolean iastDeduplicationEnabled;
    private final boolean telemetryEnabled;
    private final int telemetryHeartbeatInterval;
    private final boolean azureAppServices;
    private final String traceAgentPath;
    private final List<String> traceAgentArgs;
    private final String dogStatsDPath;
    private final List<String> dogStatsDArgs;
    private String env;
    private String version;
    private final String primaryTag;
    private final ConfigProvider configProvider;
    private static final String PREFIX = "dd.";
    @SuppressFBWarnings(value={"SI_INSTANCE_BEFORE_FINALS_ASSIGNED"})
    private static final Config INSTANCE = new Config(ConfigProvider.getInstance());

    private Config() {
        this(ConfigProvider.createDefault());
    }

    private Config(ConfigProvider configProvider) {
        IdGenerationStrategy strategy;
        this.configProvider = configProvider;
        this.configFileStatus = configProvider.getConfigFileStatus();
        this.runtimeId = null != INSTANCE ? Config.INSTANCE.runtimeId : (configProvider.getBoolean("runtime-id.enabled", true, new String[0]) ? UUID.randomUUID().toString() : "");
        this.runtimeVersion = System.getProperty("java.version", "unknown");
        String apiKeyFile = configProvider.getString("api-key-file");
        String tmpApiKey = configProvider.getStringExcludingSource("api-key", null, SystemPropertiesConfigSource.class, new String[0]);
        if (apiKeyFile != null) {
            try {
                tmpApiKey = new String(Files.readAllBytes(Paths.get(apiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
            }
            catch (IOException e) {
                log.error("Cannot read API key from file {}, skipping", (Object)apiKeyFile, (Object)e);
            }
        }
        this.site = configProvider.getString("site", "datadoghq.com", new String[0]);
        this.hostName = Config.initHostName();
        String userProvidedServiceName = configProvider.getStringExcludingSource("service", null, CapturedEnvironmentConfigSource.class, "service.name");
        if (userProvidedServiceName == null) {
            this.serviceNameSetByUser = false;
            this.serviceName = configProvider.getString("service", "unnamed-java-app", "service.name");
        } else {
            this.serviceNameSetByUser = true;
            this.serviceName = userProvidedServiceName;
        }
        this.rootContextServiceName = configProvider.getString("trace.servlet.root-context.service.name", "root-servlet", new String[0]);
        this.traceEnabled = configProvider.getBoolean("trace.enabled", true, new String[0]);
        this.integrationSynapseLegacyOperationName = configProvider.getBoolean("integration.synapse.legacy-operation-name", false, new String[0]);
        this.writerType = configProvider.getString("writer.type", "DDAgentWriter", new String[0]);
        String lambdaInitType = Config.getEnv("AWS_LAMBDA_INITIALIZATION_TYPE");
        this.secureRandom = lambdaInitType != null && lambdaInitType.equals("snap-start") ? true : configProvider.getBoolean("trace.secure-random", false, new String[0]);
        String strategyName = configProvider.getString("id.generation.strategy");
        if (this.secureRandom) {
            strategyName = "SECURE_RANDOM";
        }
        if (strategyName == null) {
            strategyName = "RANDOM";
        }
        if ((strategy = IdGenerationStrategy.fromName(strategyName)) == null) {
            log.warn("*** you are trying to use an unknown id generation strategy {} - falling back to RANDOM", (Object)strategyName);
            strategyName = "RANDOM";
            strategy = IdGenerationStrategy.fromName(strategyName);
        }
        if (!strategyName.equals("RANDOM") && !strategyName.equals("SECURE_RANDOM")) {
            log.warn("*** you are using an unsupported id generation strategy {} - this can impact correctness of traces", (Object)strategyName);
        }
        this.idGenerationStrategy = strategy;
        String agentHostFromEnvironment = null;
        int agentPortFromEnvironment = -1;
        String unixSocketFromEnvironment = null;
        boolean rebuildAgentUrl = false;
        String agentUrlFromEnvironment = configProvider.getString("trace.agent.url");
        if (agentUrlFromEnvironment != null) {
            try {
                URI parsedAgentUrl = new URI(agentUrlFromEnvironment);
                agentHostFromEnvironment = parsedAgentUrl.getHost();
                agentPortFromEnvironment = parsedAgentUrl.getPort();
                if ("unix".equals(parsedAgentUrl.getScheme())) {
                    unixSocketFromEnvironment = parsedAgentUrl.getPath();
                }
            }
            catch (URISyntaxException e) {
                log.warn("{} not configured correctly: {}. Ignoring", (Object)"trace.agent.url", (Object)e.getMessage());
            }
        }
        if (agentHostFromEnvironment == null) {
            agentHostFromEnvironment = configProvider.getString("agent.host");
            rebuildAgentUrl = true;
        }
        if (agentPortFromEnvironment < 0) {
            agentPortFromEnvironment = configProvider.getInteger("trace.agent.port", -1, "agent.port");
            rebuildAgentUrl = true;
        }
        this.agentHost = agentHostFromEnvironment == null ? "localhost" : agentHostFromEnvironment;
        this.agentPort = agentPortFromEnvironment < 0 ? 8126 : agentPortFromEnvironment;
        this.agentUrl = rebuildAgentUrl ? "http://" + this.agentHost + ":" + this.agentPort : agentUrlFromEnvironment;
        if (unixSocketFromEnvironment == null) {
            unixSocketFromEnvironment = configProvider.getString("trace.agent.unix.domain.socket");
            String unixPrefix = "unix://";
            if (unixSocketFromEnvironment != null && unixSocketFromEnvironment.startsWith(unixPrefix)) {
                unixSocketFromEnvironment = unixSocketFromEnvironment.substring(unixPrefix.length());
            }
        }
        this.agentUnixDomainSocket = unixSocketFromEnvironment;
        this.agentNamedPipe = configProvider.getString("trace.pipe.name");
        this.agentConfiguredUsingDefault = agentHostFromEnvironment == null && agentPortFromEnvironment < 0 && unixSocketFromEnvironment == null && this.agentNamedPipe == null;
        this.agentTimeout = configProvider.getInteger("trace.agent.timeout", 10, new String[0]);
        this.noProxyHosts = CollectionUtils.tryMakeImmutableSet(configProvider.getSpacedList("proxy.no_proxy"));
        this.prioritySamplingEnabled = configProvider.getBoolean("priority.sampling", true, new String[0]);
        this.prioritySamplingForce = configProvider.getString("priority.sampling.force", ConfigDefaults.DEFAULT_PRIORITY_SAMPLING_FORCE, new String[0]);
        this.traceResolverEnabled = configProvider.getBoolean("trace.resolver.enabled", true, new String[0]);
        this.serviceMapping = configProvider.getMergedMap("service.mapping");
        HashMap<String, String> tags = new HashMap<String, String>(configProvider.getMergedMap("trace.global.tags"));
        tags.putAll(configProvider.getMergedMap("tags"));
        this.tags = this.getMapWithPropertiesDefinedByEnvironment(tags, "env", "version");
        this.spanTags = configProvider.getMergedMap("trace.span.tags");
        this.jmxTags = configProvider.getMergedMap("trace.jmx.tags");
        this.primaryTag = configProvider.getString("primary.tag");
        if (this.isEnabled(false, "trace.header.tags", ".legacy.parsing.enabled")) {
            this.requestHeaderTags = configProvider.getMergedMap("trace.header.tags");
            this.responseHeaderTags = Collections.emptyMap();
            if (configProvider.isSet("trace.request_header.tags")) {
                this.logIngoredSettingWarning("trace.request_header.tags", "trace.header.tags", ".legacy.parsing.enabled");
            }
            if (configProvider.isSet("trace.response_header.tags")) {
                this.logIngoredSettingWarning("trace.response_header.tags", "trace.header.tags", ".legacy.parsing.enabled");
            }
        } else {
            this.requestHeaderTags = configProvider.getMergedMapWithOptionalMappings("http.request.headers.", true, "trace.header.tags", "trace.request_header.tags");
            this.responseHeaderTags = configProvider.getMergedMapWithOptionalMappings("http.response.headers.", true, "trace.header.tags", "trace.response_header.tags");
        }
        this.httpServerPathResourceNameMapping = configProvider.getOrderedMap("trace.http.server.path-resource-name-mapping");
        this.httpServerErrorStatuses = configProvider.getIntegerRange("http.server.error.statuses", ConfigDefaults.DEFAULT_HTTP_SERVER_ERROR_STATUSES);
        this.httpClientErrorStatuses = configProvider.getIntegerRange("http.client.error.statuses", ConfigDefaults.DEFAULT_HTTP_CLIENT_ERROR_STATUSES);
        this.httpServerTagQueryString = configProvider.getBoolean("http.server.tag.query-string", true, new String[0]);
        this.httpServerRawQueryString = configProvider.getBoolean("http.server.raw.query-string", true, new String[0]);
        this.httpServerRawResource = configProvider.getBoolean("http.server.raw.resource", false, new String[0]);
        this.httpServerRouteBasedNaming = configProvider.getBoolean("http.server.route-based-naming", true, new String[0]);
        this.httpClientTagQueryString = configProvider.getBoolean("http.client.tag.query-string", false, new String[0]);
        this.httpClientSplitByDomain = configProvider.getBoolean("trace.http.client.split-by-domain", false, new String[0]);
        this.dbClientSplitByInstance = configProvider.getBoolean("trace.db.client.split-by-instance", false, new String[0]);
        this.dbClientSplitByInstanceTypeSuffix = configProvider.getBoolean("trace.db.client.split-by-instance.type.suffix", false, new String[0]);
        this.splitByTags = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.split-by-tags"));
        this.scopeDepthLimit = configProvider.getInteger("trace.scope.depth.limit", 100, new String[0]);
        this.scopeStrictMode = configProvider.getBoolean("trace.scope.strict.mode", false, new String[0]);
        this.scopeInheritAsyncPropagation = configProvider.getBoolean("trace.scope.inherit.async.propagation", true, new String[0]);
        this.scopeIterationKeepAlive = configProvider.getInteger("trace.scope.iteration.keep.alive", 30, new String[0]);
        this.partialFlushMinSpans = configProvider.getInteger("trace.partial.flush.min.spans", 1000, new String[0]);
        this.traceStrictWritesEnabled = configProvider.getBoolean("trace.strict.writes.enabled", false, new String[0]);
        this.logExtractHeaderNames = configProvider.getBoolean("propagation.extract.log_header_names.enabled", false, new String[0]);
        this.propagationStylesToExtract = this.getPropagationStyleSetSettingFromEnvironmentOrDefault("propagation.style.extract", ConfigDefaults.DEFAULT_PROPAGATION_STYLE_EXTRACT);
        this.propagationStylesToInject = this.getPropagationStyleSetSettingFromEnvironmentOrDefault("propagation.style.inject", ConfigDefaults.DEFAULT_PROPAGATION_STYLE_INJECT);
        this.clockSyncPeriod = configProvider.getInteger("trace.clock.sync.period", 30, new String[0]);
        this.dogStatsDNamedPipe = configProvider.getString("ddtrot.dogstatsd.pipe.name");
        this.dogStatsDStartDelay = configProvider.getInteger("ddtrot.dogstatsd.start-delay", 15, "jmxfetch.start-delay");
        boolean runtimeMetricsEnabled = configProvider.getBoolean("runtime.metrics.enabled", true, new String[0]);
        this.jmxFetchEnabled = runtimeMetricsEnabled && configProvider.getBoolean("jmxfetch.enabled", true, new String[0]);
        this.jmxFetchConfigDir = configProvider.getString("jmxfetch.config.dir");
        this.jmxFetchConfigs = CollectionUtils.tryMakeImmutableList(configProvider.getList("jmxfetch.config"));
        this.jmxFetchMetricsConfigs = CollectionUtils.tryMakeImmutableList(configProvider.getList("jmxfetch.metrics-configs"));
        this.jmxFetchCheckPeriod = configProvider.getInteger("jmxfetch.check-period");
        this.jmxFetchInitialRefreshBeansPeriod = configProvider.getInteger("jmxfetch.initial-refresh-beans-period");
        this.jmxFetchRefreshBeansPeriod = configProvider.getInteger("jmxfetch.refresh-beans-period");
        this.jmxFetchStatsdPort = configProvider.getInteger("jmxfetch.statsd.port", "ddtrot.dogstatsd.port");
        this.jmxFetchStatsdHost = configProvider.getString("jmxfetch.statsd.host", null != this.jmxFetchStatsdPort && this.jmxFetchStatsdPort > 0 ? this.agentHost : null, "ddtrot.dogstatsd.host");
        this.jmxFetchMultipleRuntimeServicesEnabled = configProvider.getBoolean("jmxfetch.multiple-runtime-services.enabled", false, new String[0]);
        this.jmxFetchMultipleRuntimeServicesLimit = configProvider.getInteger("jmxfetch.multiple-runtime-services.limit", 10, new String[0]);
        this.healthMetricsEnabled = runtimeMetricsEnabled && configProvider.getBoolean("trace.health.metrics.enabled", true, new String[0]);
        this.healthMetricsStatsdHost = configProvider.getString("trace.health.metrics.statsd.host");
        this.healthMetricsStatsdPort = configProvider.getInteger("trace.health.metrics.statsd.port");
        this.perfMetricsEnabled = runtimeMetricsEnabled && Platform.isJavaVersionAtLeast(8) && configProvider.getBoolean("trace.perf.metrics.enabled", false, new String[0]);
        this.tracerMetricsEnabled = Platform.isJavaVersionAtLeast(8) && configProvider.getBoolean("trace.tracer.metrics.enabled", false, new String[0]);
        this.tracerMetricsBufferingEnabled = configProvider.getBoolean("trace.tracer.metrics.buffering.enabled", false, new String[0]);
        this.tracerMetricsMaxAggregates = configProvider.getInteger("trace.tracer.metrics.max.aggregates", 2048, new String[0]);
        this.tracerMetricsMaxPending = configProvider.getInteger("trace.tracer.metrics.max.pending", 2048, new String[0]);
        this.logsMDCTagsInjectionEnabled = configProvider.getBoolean("logs.mdc.tags.injection", true, new String[0]);
        this.reportHostName = configProvider.getBoolean("trace.report-hostname", false, new String[0]);
        this.traceAgentV05Enabled = configProvider.getBoolean("trace.agent.v0.5.enabled", false, new String[0]);
        this.traceAnalyticsEnabled = configProvider.getBoolean("trace.analytics.enabled", false, new String[0]);
        String traceClientIpHeader = configProvider.getString("trace.client-ip-header");
        if (traceClientIpHeader == null) {
            traceClientIpHeader = configProvider.getString("appsec.ipheader");
        }
        if (traceClientIpHeader != null) {
            traceClientIpHeader = traceClientIpHeader.toLowerCase(Locale.ROOT);
        }
        this.traceClientIpHeader = traceClientIpHeader;
        this.traceClientIpResolverEnabled = configProvider.getBoolean("trace.client-ip.resolver.enabled", true, new String[0]);
        this.traceSamplingServiceRules = configProvider.getMergedMap("trace.sampling.service.rules");
        this.traceSamplingOperationRules = configProvider.getMergedMap("trace.sampling.operation.rules");
        this.traceSamplingRules = configProvider.getString("trace.sampling.rules");
        this.traceSampleRate = configProvider.getDouble("trace.sample.rate");
        this.traceRateLimit = configProvider.getInteger("trace.rate.limit", 100, new String[0]);
        this.profilingEnabled = configProvider.getBoolean("profiling.enabled", false, new String[0]);
        this.profilingAgentless = configProvider.getBoolean("profiling.agentless", false, new String[0]);
        this.isAsyncProfilerEnabled = configProvider.getBoolean("profiling.async.enabled", false, new String[0]);
        this.isDirectAllocationProfilingEnabled = configProvider.getBoolean("profiling.directallocation.enabled", false, new String[0]);
        this.profilingUrl = configProvider.getString("profiling.url");
        if (tmpApiKey == null) {
            String oldProfilingApiKeyFile = configProvider.getString("profiling.api-key-file");
            tmpApiKey = Config.getEnv(Strings.propertyNameToEnvironmentVariableName("profiling.api-key"));
            if (oldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(oldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)oldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        if (tmpApiKey == null) {
            String veryOldProfilingApiKeyFile = configProvider.getString("profiling.apikey.file");
            tmpApiKey = Config.getEnv(Strings.propertyNameToEnvironmentVariableName("profiling.apikey"));
            if (veryOldProfilingApiKeyFile != null) {
                try {
                    tmpApiKey = new String(Files.readAllBytes(Paths.get(veryOldProfilingApiKeyFile, new String[0])), StandardCharsets.UTF_8).trim();
                }
                catch (IOException e) {
                    log.error("Cannot read API key from file {}, skipping", (Object)veryOldProfilingApiKeyFile, (Object)e);
                }
            }
        }
        this.profilingTags = configProvider.getMergedMap("profiling.tags");
        this.profilingStartDelay = configProvider.getInteger("profiling.start-delay", 10, new String[0]);
        this.profilingStartForceFirst = configProvider.getBoolean("profiling.start-force-first", false, new String[0]);
        this.profilingUploadPeriod = configProvider.getInteger("profiling.upload.period", 60, new String[0]);
        this.profilingTemplateOverrideFile = configProvider.getString("profiling.jfr-template-override-file");
        this.profilingUploadTimeout = configProvider.getInteger("profiling.upload.timeout", 30, new String[0]);
        this.profilingUploadCompression = configProvider.getString("profiling.upload.compression", "on", new String[0]);
        this.profilingProxyHost = configProvider.getString("profiling.proxy.host");
        this.profilingProxyPort = configProvider.getInteger("profiling.proxy.port", 8080, new String[0]);
        this.profilingProxyUsername = configProvider.getString("profiling.proxy.username");
        this.profilingProxyPassword = configProvider.getString("profiling.proxy.password");
        this.profilingExceptionSampleLimit = configProvider.getInteger("profiling.exception.sample.limit", 10000, new String[0]);
        this.profilingDirectAllocationSampleLimit = configProvider.getInteger("profiling.direct.allocation.sample.limit", 10000, new String[0]);
        this.profilingExceptionHistogramTopItems = configProvider.getInteger("profiling.exception.histogram.top-items", 50, new String[0]);
        this.profilingExceptionHistogramMaxCollectionSize = configProvider.getInteger("profiling.exception.histogram.max-collection-size", 10000, new String[0]);
        this.profilingExcludeAgentThreads = configProvider.getBoolean("profiling.exclude.agent-threads", true, new String[0]);
        this.profilingHotspotsEnabled = configProvider.getBoolean("profiling.hotspots.enabled", false, new String[0]);
        this.profilingUploadSummaryOn413Enabled = configProvider.getBoolean("profiling.upload.summary-on-413", false, new String[0]);
        this.crashTrackingAgentless = configProvider.getBoolean("crashtracking.agentless", false, new String[0]);
        this.crashTrackingTags = configProvider.getMergedMap("crashtracking.tags");
        this.telemetryEnabled = configProvider.getBoolean("instrumentation.telemetry.enabled", true, new String[0]);
        int telemetryInterval = configProvider.getInteger("telemetry.heartbeat.interval", 60, new String[0]);
        if (telemetryInterval < 1 || telemetryInterval > 3600) {
            log.warn("Wrong Telemetry heartbeat interval: {}. The value must be in range 1-3600", (Object)telemetryInterval);
            telemetryInterval = 60;
        }
        this.telemetryHeartbeatInterval = telemetryInterval;
        this.clientIpEnabled = configProvider.getBoolean("trace.client-ip.enabled", false, new String[0]);
        String appSecEnabled = configProvider.getString("appsec.enabled");
        if ((appSecEnabled == null || appSecEnabled.isEmpty()) && (appSecEnabled = configProvider.getStringExcludingSource("appsec.enabled", "inactive", SystemPropertiesConfigSource.class, new String[0])).isEmpty()) {
            appSecEnabled = "inactive";
        }
        this.appSecEnabled = ProductActivationConfig.fromString(appSecEnabled);
        this.appSecReportingInband = configProvider.getBoolean("appsec.reporting.inband", false, new String[0]);
        this.appSecRulesFile = configProvider.getString("appsec.rules", null, new String[0]);
        this.appSecReportMaxTimeout = configProvider.getInteger("appsec.report.timeout", 60, new String[0]);
        this.appSecReportMinTimeout = Math.min(this.appSecReportMaxTimeout, 5);
        this.appSecTraceRateLimit = configProvider.getInteger("appsec.trace.rate.limit", 100, new String[0]);
        this.appSecWafMetrics = configProvider.getBoolean("appsec.waf.metrics", true, new String[0]);
        this.appSecObfuscationParameterKeyRegexp = configProvider.getString("appsec.obfuscation.parameter_key_regexp", null, new String[0]);
        this.appSecObfuscationParameterValueRegexp = configProvider.getString("appsec.obfuscation.parameter_value_regexp", null, new String[0]);
        this.appSecHttpBlockedTemplateHtml = configProvider.getString("appsec.http.blocked.template.html", null, new String[0]);
        this.appSecHttpBlockedTemplateJson = configProvider.getString("appsec.http.blocked.template.json", null, new String[0]);
        this.iastEnabled = configProvider.getBoolean("iast.enabled", false, new String[0]);
        this.iastTaintTrackingDebugEnabled = configProvider.getBoolean("iast.taint-tracking.debug.enabled", false, new String[0]);
        this.iastMaxConcurrentRequests = configProvider.getInteger("iast.max-concurrent-request", 2, new String[0]);
        this.iastVulnerabilitiesPerRequest = configProvider.getInteger("iast.vulnerabilities-per-request", 2, new String[0]);
        this.iastRequestSampling = configProvider.getFloat("iast.request-sampling", 30.0f);
        this.iastWeakHashAlgorithms = CollectionUtils.tryMakeImmutableSet(configProvider.getSet("iast.weak-hash.algorithms", ConfigDefaults.DEFAULT_IAST_WEAK_HASH_ALGORITHMS));
        this.iastWeakCipherAlgorithms = Config.getPattern("^(?:PBEWITH(?:HMACSHA(?:2(?:24ANDAES_(?:128|256)|56ANDAES_(?:128|256))|384ANDAES_(?:128|256)|512ANDAES_(?:128|256)|1ANDAES_(?:128|256))|SHA1AND(?:RC(?:2_(?:128|40)|4_(?:128|40))|DESEDE)|MD5AND(?:TRIPLEDES|DES))|DES(?:EDE(?:WRAP)?)?|BLOWFISH|ARCFOUR|RC2).*$", configProvider.getString("iast.weak-cipher.algorithms"));
        this.iastDeduplicationEnabled = configProvider.getBoolean("iast.deduplication.enabled", true, new String[0]);
        this.ciVisibilityEnabled = configProvider.getBoolean("civisibility.enabled", false, new String[0]);
        this.ciVisibilityAgentlessEnabled = configProvider.getBoolean("civisibility.agentless.enabled", false, new String[0]);
        String ciVisibilityAgentlessUrlStr = configProvider.getString("civisibility.agentless.url");
        URI parsedCiVisibilityUri = null;
        if (ciVisibilityAgentlessUrlStr != null && !ciVisibilityAgentlessUrlStr.isEmpty()) {
            try {
                parsedCiVisibilityUri = new URL(ciVisibilityAgentlessUrlStr).toURI();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                log.error("Cannot parse CI Visibility agentless URL '{}', skipping", (Object)ciVisibilityAgentlessUrlStr);
            }
        }
        this.ciVisibilityAgentlessUrl = parsedCiVisibilityUri != null ? ciVisibilityAgentlessUrlStr : null;
        this.remoteConfigEnabled = configProvider.getBoolean("remote_config.enabled", true, new String[0]);
        this.remoteConfigIntegrityCheckEnabled = configProvider.getBoolean("remote_config.integrity_check.enabled", false, new String[0]);
        this.remoteConfigUrl = configProvider.getString("remote_config.url");
        this.remoteConfigInitialPollInterval = configProvider.getInteger("remote_config.initial.poll.interval", 5, new String[0]);
        this.remoteConfigMaxPayloadSize = configProvider.getInteger("remote_config.max.payload.size", 1024, new String[0]) * 1024;
        this.remoteConfigTargetsKeyId = configProvider.getString("rc.targets.key.id", "5c4ece41241a1bb513f6e3e5df74ab7d5183dfffbd71bfd43127920d880569fd", new String[0]);
        this.remoteConfigTargetsKey = configProvider.getString("rc.targets.key", "e3f1f98c9da02a93bb547f448b472d727e14b22455235796fe49863856252508", new String[0]);
        this.debuggerEnabled = configProvider.getBoolean("dynamic.instrumentation.enabled", false, new String[0]);
        this.debuggerUploadTimeout = configProvider.getInteger("dynamic.instrumentation.upload.timeout", 30, new String[0]);
        this.debuggerUploadFlushInterval = configProvider.getInteger("dynamic.instrumentation.upload.flush.interval", 0, new String[0]);
        this.debuggerClassFileDumpEnabled = configProvider.getBoolean("dynamic.instrumentation.classfile.dump.enabled", false, new String[0]);
        this.debuggerPollInterval = configProvider.getInteger("dynamic.instrumentation.poll.interval", 1, new String[0]);
        this.debuggerDiagnosticsInterval = configProvider.getInteger("dynamic.instrumentation.diagnostics.interval", 3600, new String[0]);
        this.debuggerMetricEnabled = runtimeMetricsEnabled && configProvider.getBoolean("dynamic.instrumentation.metrics.enabled", true, new String[0]);
        this.debuggerProbeFileLocation = configProvider.getString("dynamic.instrumentation.probe.file");
        this.debuggerUploadBatchSize = configProvider.getInteger("dynamic.instrumentation.upload.batch.size", 100, new String[0]);
        this.debuggerMaxPayloadSize = configProvider.getInteger("dynamic.instrumentation.max.payload.size", 1024, new String[0]) * 1024;
        this.debuggerVerifyByteCode = configProvider.getBoolean("dynamic.instrumentation.verify.bytecode", false, new String[0]);
        this.debuggerInstrumentTheWorld = configProvider.getBoolean("dynamic.instrumentation.instrument.the.world", false, new String[0]);
        this.debuggerExcludeFile = configProvider.getString("dynamic.instrumentation.exclude.file");
        this.awsPropagationEnabled = this.isPropagationEnabled(true, "aws");
        this.sqsPropagationEnabled = this.awsPropagationEnabled && this.isPropagationEnabled(true, "sqs");
        this.kafkaClientPropagationEnabled = this.isPropagationEnabled(true, "kafka", "kafka.client");
        this.kafkaClientPropagationDisabledTopics = CollectionUtils.tryMakeImmutableSet(configProvider.getList("kafka.client.propagation.disabled.topics"));
        this.kafkaClientBase64DecodingEnabled = configProvider.getBoolean("kafka.client.base64.decoding.enabled", false, new String[0]);
        this.jmsPropagationEnabled = this.isPropagationEnabled(true, "jms");
        this.jmsPropagationDisabledTopics = CollectionUtils.tryMakeImmutableSet(configProvider.getList("jms.propagation.disabled.topics"));
        this.jmsPropagationDisabledQueues = CollectionUtils.tryMakeImmutableSet(configProvider.getList("jms.propagation.disabled.queues"));
        this.rabbitPropagationEnabled = this.isPropagationEnabled(true, "rabbit", "rabbitmq");
        this.rabbitPropagationDisabledQueues = CollectionUtils.tryMakeImmutableSet(configProvider.getList("rabbit.propagation.disabled.queues"));
        this.rabbitPropagationDisabledExchanges = CollectionUtils.tryMakeImmutableSet(configProvider.getList("rabbit.propagation.disabled.exchanges"));
        this.rabbitIncludeRoutingKeyInResource = configProvider.getBoolean("rabbit.include.routingkey.in.resource", true, new String[0]);
        this.messageBrokerSplitByDestination = configProvider.getBoolean("message.broker.split-by-destination", false, new String[0]);
        this.grpcIgnoredInboundMethods = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.grpc.ignored.inbound.methods"));
        this.grpcIgnoredOutboundMethods = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.grpc.ignored.outbound.methods"));
        this.grpcServerTrimPackageResource = configProvider.getBoolean("trace.grpc.server.trim-package-resource", false, new String[0]);
        this.grpcServerErrorStatuses = configProvider.getIntegerRange("grpc.server.error.statuses", ConfigDefaults.DEFAULT_GRPC_SERVER_ERROR_STATUSES);
        this.grpcClientErrorStatuses = configProvider.getIntegerRange("grpc.client.error.statuses", ConfigDefaults.DEFAULT_GRPC_CLIENT_ERROR_STATUSES);
        this.hystrixTagsEnabled = configProvider.getBoolean("hystrix.tags.enabled", false, new String[0]);
        this.hystrixMeasuredEnabled = configProvider.getBoolean("hystrix.measured.enabled", false, new String[0]);
        this.igniteCacheIncludeKeys = configProvider.getBoolean("ignite.cache.include_keys", false, new String[0]);
        this.obfuscationQueryRegexp = configProvider.getString("obfuscation.query.string.regexp");
        this.playReportHttpStatus = configProvider.getBoolean("trace.play.report-http-status", false, new String[0]);
        this.servletPrincipalEnabled = configProvider.getBoolean("trace.servlet.principal.enabled", false, new String[0]);
        this.xDatadogTagsMaxLength = configProvider.getInteger("trace.x-datadog-tags.max.length", 512, new String[0]);
        this.servletAsyncTimeoutError = configProvider.getBoolean("trace.servlet.async-timeout.error", true, new String[0]);
        this.debugEnabled = Config.isDebugMode();
        this.cwsEnabled = configProvider.getBoolean("cws.enabled", false, new String[0]);
        this.cwsTlsRefresh = configProvider.getInteger("cws.tls.refresh", 5000, new String[0]);
        this.dataStreamsEnabled = configProvider.getBoolean("data.streams.enabled", false, new String[0]);
        this.azureAppServices = configProvider.getBoolean("azure.app.services", false, new String[0]);
        this.traceAgentPath = configProvider.getString("trace.agent.path");
        String traceAgentArgsString = configProvider.getString("trace.agent.args");
        this.traceAgentArgs = traceAgentArgsString == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Config.parseStringIntoSetOfNonEmptyStrings(traceAgentArgsString)));
        this.dogStatsDPath = configProvider.getString("ddtrot.dogstatsd.path");
        String dogStatsDArgsString = configProvider.getString("ddtrot.dogstatsd.args");
        this.dogStatsDArgs = dogStatsDArgsString == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Config.parseStringIntoSetOfNonEmptyStrings(dogStatsDArgsString)));
        this.apiKey = tmpApiKey;
        if (this.profilingAgentless && this.apiKey == null) {
            log.warn("Agentless profiling activated but no api key provided. Profile uploading will likely fail");
        }
        log.debug("New instance: {}", (Object)this);
    }

    public ConfigProvider configProvider() {
        return this.configProvider;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getSite() {
        return this.site;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isServiceNameSetByUser() {
        return this.serviceNameSetByUser;
    }

    public String getRootContextServiceName() {
        return this.rootContextServiceName;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isIntegrationSynapseLegacyOperationName() {
        return this.integrationSynapseLegacyOperationName;
    }

    public String getWriterType() {
        return this.writerType;
    }

    public boolean isAgentConfiguredUsingDefault() {
        return this.agentConfiguredUsingDefault;
    }

    public String getAgentUrl() {
        return this.agentUrl;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentUnixDomainSocket() {
        return this.agentUnixDomainSocket;
    }

    public String getAgentNamedPipe() {
        return this.agentNamedPipe;
    }

    public int getAgentTimeout() {
        return this.agentTimeout;
    }

    public Set<String> getNoProxyHosts() {
        return this.noProxyHosts;
    }

    public boolean isPrioritySamplingEnabled() {
        return this.prioritySamplingEnabled;
    }

    public String getPrioritySamplingForce() {
        return this.prioritySamplingForce;
    }

    public boolean isTraceResolverEnabled() {
        return this.traceResolverEnabled;
    }

    public Set<String> getIastWeakHashAlgorithms() {
        return this.iastWeakHashAlgorithms;
    }

    public Pattern getIastWeakCipherAlgorithms() {
        return this.iastWeakCipherAlgorithms;
    }

    public boolean isIastDeduplicationEnabled() {
        return this.iastDeduplicationEnabled;
    }

    public Map<String, String> getServiceMapping() {
        return this.serviceMapping;
    }

    public Map<String, String> getRequestHeaderTags() {
        return this.requestHeaderTags;
    }

    public Map<String, String> getResponseHeaderTags() {
        return this.responseHeaderTags;
    }

    public Map<String, String> getHttpServerPathResourceNameMapping() {
        return this.httpServerPathResourceNameMapping;
    }

    public BitSet getHttpServerErrorStatuses() {
        return this.httpServerErrorStatuses;
    }

    public BitSet getHttpClientErrorStatuses() {
        return this.httpClientErrorStatuses;
    }

    public boolean isHttpServerTagQueryString() {
        return this.httpServerTagQueryString;
    }

    public boolean isHttpServerRawQueryString() {
        return this.httpServerRawQueryString;
    }

    public boolean isHttpServerRawResource() {
        return this.httpServerRawResource;
    }

    public boolean isHttpServerRouteBasedNaming() {
        return this.httpServerRouteBasedNaming;
    }

    public boolean isHttpClientTagQueryString() {
        return this.httpClientTagQueryString;
    }

    public boolean isHttpClientSplitByDomain() {
        return this.httpClientSplitByDomain;
    }

    public boolean isDbClientSplitByInstance() {
        return this.dbClientSplitByInstance;
    }

    public boolean isDbClientSplitByInstanceTypeSuffix() {
        return this.dbClientSplitByInstanceTypeSuffix;
    }

    public Set<String> getSplitByTags() {
        return this.splitByTags;
    }

    public int getScopeDepthLimit() {
        return this.scopeDepthLimit;
    }

    public boolean isScopeStrictMode() {
        return this.scopeStrictMode;
    }

    public boolean isScopeInheritAsyncPropagation() {
        return this.scopeInheritAsyncPropagation;
    }

    public int getScopeIterationKeepAlive() {
        return this.scopeIterationKeepAlive;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    public boolean isTraceStrictWritesEnabled() {
        return this.traceStrictWritesEnabled;
    }

    public boolean isLogExtractHeaderNames() {
        return this.logExtractHeaderNames;
    }

    public Set<PropagationStyle> getPropagationStylesToExtract() {
        return this.propagationStylesToExtract;
    }

    public Set<PropagationStyle> getPropagationStylesToInject() {
        return this.propagationStylesToInject;
    }

    public int getClockSyncPeriod() {
        return this.clockSyncPeriod;
    }

    public String getDogStatsDNamedPipe() {
        return this.dogStatsDNamedPipe;
    }

    public int getDogStatsDStartDelay() {
        return this.dogStatsDStartDelay;
    }

    public boolean isJmxFetchEnabled() {
        return this.jmxFetchEnabled;
    }

    public String getJmxFetchConfigDir() {
        return this.jmxFetchConfigDir;
    }

    public List<String> getJmxFetchConfigs() {
        return this.jmxFetchConfigs;
    }

    public List<String> getJmxFetchMetricsConfigs() {
        return this.jmxFetchMetricsConfigs;
    }

    public Integer getJmxFetchCheckPeriod() {
        return this.jmxFetchCheckPeriod;
    }

    public Integer getJmxFetchRefreshBeansPeriod() {
        return this.jmxFetchRefreshBeansPeriod;
    }

    public Integer getJmxFetchInitialRefreshBeansPeriod() {
        return this.jmxFetchInitialRefreshBeansPeriod;
    }

    public String getJmxFetchStatsdHost() {
        return this.jmxFetchStatsdHost;
    }

    public Integer getJmxFetchStatsdPort() {
        return this.jmxFetchStatsdPort;
    }

    public boolean isJmxFetchMultipleRuntimeServicesEnabled() {
        return this.jmxFetchMultipleRuntimeServicesEnabled;
    }

    public int getJmxFetchMultipleRuntimeServicesLimit() {
        return this.jmxFetchMultipleRuntimeServicesLimit;
    }

    public boolean isHealthMetricsEnabled() {
        return this.healthMetricsEnabled;
    }

    public String getHealthMetricsStatsdHost() {
        return this.healthMetricsStatsdHost;
    }

    public Integer getHealthMetricsStatsdPort() {
        return this.healthMetricsStatsdPort;
    }

    public boolean isPerfMetricsEnabled() {
        return this.perfMetricsEnabled;
    }

    public boolean isTracerMetricsEnabled() {
        return this.tracerMetricsEnabled;
    }

    public boolean isTracerMetricsBufferingEnabled() {
        return this.tracerMetricsBufferingEnabled;
    }

    public int getTracerMetricsMaxAggregates() {
        return this.tracerMetricsMaxAggregates;
    }

    public int getTracerMetricsMaxPending() {
        return this.tracerMetricsMaxPending;
    }

    public boolean isLogsInjectionEnabled() {
        return this.instrumenterConfig.isLogsInjectionEnabled();
    }

    public boolean isLogsMDCTagsInjectionEnabled() {
        return this.logsMDCTagsInjectionEnabled;
    }

    public boolean isReportHostName() {
        return this.reportHostName;
    }

    public boolean isTraceAnalyticsEnabled() {
        return this.traceAnalyticsEnabled;
    }

    public String getTraceClientIpHeader() {
        return this.traceClientIpHeader;
    }

    public boolean isTraceClientIpResolverEnabled() {
        return this.traceClientIpResolverEnabled;
    }

    public Map<String, String> getTraceSamplingServiceRules() {
        return this.traceSamplingServiceRules;
    }

    public Map<String, String> getTraceSamplingOperationRules() {
        return this.traceSamplingOperationRules;
    }

    public String getTraceSamplingRules() {
        return this.traceSamplingRules;
    }

    public Double getTraceSampleRate() {
        return this.traceSampleRate;
    }

    public int getTraceRateLimit() {
        return this.traceRateLimit;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public boolean isProfilingAgentless() {
        return this.profilingAgentless;
    }

    public int getProfilingStartDelay() {
        return this.profilingStartDelay;
    }

    public boolean isProfilingStartForceFirst() {
        return this.profilingStartForceFirst;
    }

    public int getProfilingUploadPeriod() {
        return this.profilingUploadPeriod;
    }

    public String getProfilingTemplateOverrideFile() {
        return this.profilingTemplateOverrideFile;
    }

    public int getProfilingUploadTimeout() {
        return this.profilingUploadTimeout;
    }

    public String getProfilingUploadCompression() {
        return this.profilingUploadCompression;
    }

    public String getProfilingProxyHost() {
        return this.profilingProxyHost;
    }

    public int getProfilingProxyPort() {
        return this.profilingProxyPort;
    }

    public String getProfilingProxyUsername() {
        return this.profilingProxyUsername;
    }

    public String getProfilingProxyPassword() {
        return this.profilingProxyPassword;
    }

    public int getProfilingExceptionSampleLimit() {
        return this.profilingExceptionSampleLimit;
    }

    public int getProfilingDirectAllocationSampleLimit() {
        return this.profilingDirectAllocationSampleLimit;
    }

    public int getProfilingExceptionHistogramTopItems() {
        return this.profilingExceptionHistogramTopItems;
    }

    public int getProfilingExceptionHistogramMaxCollectionSize() {
        return this.profilingExceptionHistogramMaxCollectionSize;
    }

    public boolean isProfilingExcludeAgentThreads() {
        return this.profilingExcludeAgentThreads;
    }

    public boolean isProfilingHotspotsEnabled() {
        return this.profilingHotspotsEnabled;
    }

    public boolean isProfilingUploadSummaryOn413Enabled() {
        return this.profilingUploadSummaryOn413Enabled;
    }

    public boolean isAsyncProfilerEnabled() {
        return this.isAsyncProfilerEnabled;
    }

    public boolean isDirectAllocationProfilingEnabled() {
        return this.isDirectAllocationProfilingEnabled;
    }

    public boolean isCrashTrackingAgentless() {
        return this.crashTrackingAgentless;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public int getTelemetryHeartbeatInterval() {
        return this.telemetryHeartbeatInterval;
    }

    public boolean isClientIpEnabled() {
        return this.clientIpEnabled;
    }

    public ProductActivationConfig getAppSecEnabledConfig() {
        return this.appSecEnabled;
    }

    public boolean isAppSecReportingInband() {
        return this.appSecReportingInband;
    }

    public int getAppSecReportMinTimeout() {
        return this.appSecReportMinTimeout;
    }

    public int getAppSecReportMaxTimeout() {
        return this.appSecReportMaxTimeout;
    }

    public int getAppSecTraceRateLimit() {
        return this.appSecTraceRateLimit;
    }

    public boolean isAppSecWafMetrics() {
        return this.appSecWafMetrics;
    }

    public String getAppSecObfuscationParameterKeyRegexp() {
        return this.appSecObfuscationParameterKeyRegexp;
    }

    public String getAppSecObfuscationParameterValueRegexp() {
        return this.appSecObfuscationParameterValueRegexp;
    }

    public String getAppSecHttpBlockedTemplateHtml() {
        return this.appSecHttpBlockedTemplateHtml;
    }

    public String getAppSecHttpBlockedTemplateJson() {
        return this.appSecHttpBlockedTemplateJson;
    }

    public boolean isIastEnabled() {
        return this.iastEnabled;
    }

    public boolean isIastTaintTrackingDebugEnabled() {
        return this.iastTaintTrackingDebugEnabled;
    }

    public int getIastMaxConcurrentRequests() {
        return this.iastMaxConcurrentRequests;
    }

    public int getIastVulnerabilitiesPerRequest() {
        return this.iastVulnerabilitiesPerRequest;
    }

    public float getIastRequestSampling() {
        return this.iastRequestSampling;
    }

    public boolean isCiVisibilityEnabled() {
        return this.ciVisibilityEnabled;
    }

    public boolean isCiVisibilityAgentlessEnabled() {
        return this.ciVisibilityAgentlessEnabled;
    }

    public String getCiVisibilityAgentlessUrl() {
        return this.ciVisibilityAgentlessUrl;
    }

    public String getAppSecRulesFile() {
        return this.appSecRulesFile;
    }

    public long getRemoteConfigMaxPayloadSizeBytes() {
        return this.remoteConfigMaxPayloadSize;
    }

    public boolean isRemoteConfigEnabled() {
        return this.remoteConfigEnabled;
    }

    public boolean isRemoteConfigIntegrityCheckEnabled() {
        return this.remoteConfigIntegrityCheckEnabled;
    }

    public String getFinalRemoteConfigUrl() {
        return this.remoteConfigUrl;
    }

    public int getRemoteConfigInitialPollInterval() {
        return this.remoteConfigInitialPollInterval;
    }

    public String getRemoteConfigTargetsKeyId() {
        return this.remoteConfigTargetsKeyId;
    }

    public String getRemoteConfigTargetsKey() {
        return this.remoteConfigTargetsKey;
    }

    public boolean isDebuggerEnabled() {
        return this.debuggerEnabled;
    }

    public int getDebuggerUploadTimeout() {
        return this.debuggerUploadTimeout;
    }

    public int getDebuggerUploadFlushInterval() {
        return this.debuggerUploadFlushInterval;
    }

    public boolean isDebuggerClassFileDumpEnabled() {
        return this.debuggerClassFileDumpEnabled;
    }

    public int getDebuggerPollInterval() {
        return this.debuggerPollInterval;
    }

    public int getDebuggerDiagnosticsInterval() {
        return this.debuggerDiagnosticsInterval;
    }

    public boolean isDebuggerMetricsEnabled() {
        return this.debuggerMetricEnabled;
    }

    public int getDebuggerUploadBatchSize() {
        return this.debuggerUploadBatchSize;
    }

    public long getDebuggerMaxPayloadSize() {
        return this.debuggerMaxPayloadSize;
    }

    public boolean isDebuggerVerifyByteCode() {
        return this.debuggerVerifyByteCode;
    }

    public boolean isDebuggerInstrumentTheWorld() {
        return this.debuggerInstrumentTheWorld;
    }

    public String getDebuggerExcludeFile() {
        return this.debuggerExcludeFile;
    }

    public String getFinalDebuggerProbeUrl() {
        return "http://" + this.agentHost + ":" + this.agentPort;
    }

    public String getFinalDebuggerSnapshotUrl() {
        return this.agentUrl + "/debugger/v1/input";
    }

    public String getDebuggerProbeFileLocation() {
        return this.debuggerProbeFileLocation;
    }

    public boolean isAwsPropagationEnabled() {
        return this.awsPropagationEnabled;
    }

    public boolean isSqsPropagationEnabled() {
        return this.sqsPropagationEnabled;
    }

    public boolean isKafkaClientPropagationEnabled() {
        return this.kafkaClientPropagationEnabled;
    }

    public boolean isKafkaClientPropagationDisabledForTopic(String topic) {
        return null != topic && this.kafkaClientPropagationDisabledTopics.contains(topic);
    }

    public boolean isJmsPropagationEnabled() {
        return this.jmsPropagationEnabled;
    }

    public boolean isJmsPropagationDisabledForDestination(String queueOrTopic) {
        return null != queueOrTopic && (this.jmsPropagationDisabledQueues.contains(queueOrTopic) || this.jmsPropagationDisabledTopics.contains(queueOrTopic));
    }

    public boolean isKafkaClientBase64DecodingEnabled() {
        return this.kafkaClientBase64DecodingEnabled;
    }

    public boolean isRabbitPropagationEnabled() {
        return this.rabbitPropagationEnabled;
    }

    public boolean isRabbitPropagationDisabledForDestination(String queueOrExchange) {
        return null != queueOrExchange && (this.rabbitPropagationDisabledQueues.contains(queueOrExchange) || this.rabbitPropagationDisabledExchanges.contains(queueOrExchange));
    }

    public boolean isRabbitIncludeRoutingKeyInResource() {
        return this.rabbitIncludeRoutingKeyInResource;
    }

    public boolean isMessageBrokerSplitByDestination() {
        return this.messageBrokerSplitByDestination;
    }

    public boolean isHystrixTagsEnabled() {
        return this.hystrixTagsEnabled;
    }

    public boolean isHystrixMeasuredEnabled() {
        return this.hystrixMeasuredEnabled;
    }

    public boolean isIgniteCacheIncludeKeys() {
        return this.igniteCacheIncludeKeys;
    }

    public String getObfuscationQueryRegexp() {
        return this.obfuscationQueryRegexp;
    }

    public boolean getPlayReportHttpStatus() {
        return this.playReportHttpStatus;
    }

    public boolean isServletPrincipalEnabled() {
        return this.servletPrincipalEnabled;
    }

    public int getxDatadogTagsMaxLength() {
        return this.xDatadogTagsMaxLength;
    }

    public boolean isServletAsyncTimeoutError() {
        return this.servletAsyncTimeoutError;
    }

    public boolean isTraceAgentV05Enabled() {
        return this.traceAgentV05Enabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isCwsEnabled() {
        return this.cwsEnabled;
    }

    public int getCwsTlsRefresh() {
        return this.cwsTlsRefresh;
    }

    public boolean isAzureAppServices() {
        return this.azureAppServices;
    }

    public boolean isDataStreamsEnabled() {
        return this.dataStreamsEnabled;
    }

    public String getTraceAgentPath() {
        return this.traceAgentPath;
    }

    public List<String> getTraceAgentArgs() {
        return this.traceAgentArgs;
    }

    public String getDogStatsDPath() {
        return this.dogStatsDPath;
    }

    public List<String> getDogStatsDArgs() {
        return this.dogStatsDArgs;
    }

    public String getConfigFileStatus() {
        return this.configFileStatus;
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return this.idGenerationStrategy;
    }

    public Set<String> getGrpcIgnoredInboundMethods() {
        return this.grpcIgnoredInboundMethods;
    }

    public Set<String> getGrpcIgnoredOutboundMethods() {
        return this.grpcIgnoredOutboundMethods;
    }

    public boolean isGrpcServerTrimPackageResource() {
        return this.grpcServerTrimPackageResource;
    }

    public BitSet getGrpcServerErrorStatuses() {
        return this.grpcServerErrorStatuses;
    }

    public BitSet getGrpcClientErrorStatuses() {
        return this.grpcClientErrorStatuses;
    }

    public Map<String, Object> getLocalRootSpanTags() {
        String hostName;
        Map<String, String> runtimeTags = this.getRuntimeTags();
        HashMap<String, String> result = new HashMap<String, String>(runtimeTags.size() + 1);
        result.putAll(runtimeTags);
        result.put("language", "jvm");
        if (this.reportHostName && null != (hostName = this.getHostName()) && !hostName.isEmpty()) {
            result.put("_dd.hostname", hostName);
        }
        if (this.azureAppServices) {
            result.putAll(this.getAzureAppServicesTags());
        }
        return Collections.unmodifiableMap(result);
    }

    public WellKnownTags getWellKnownTags() {
        return new WellKnownTags(this.getRuntimeId(), this.reportHostName ? this.getHostName() : "", this.getEnv(), this.serviceName, this.getVersion(), "jvm");
    }

    public String getPrimaryTag() {
        return this.primaryTag;
    }

    public Set<String> getMetricsIgnoredResources() {
        return CollectionUtils.tryMakeImmutableSet(this.configProvider.getList("trace.tracer.metrics.ignored.resources"));
    }

    public String getEnv() {
        if (this.env == null) {
            this.env = this.getMergedSpanTags().get("env");
            if (this.env == null) {
                this.env = "";
            }
        }
        return this.env;
    }

    public String getVersion() {
        if (this.version == null) {
            this.version = this.getMergedSpanTags().get("version");
            if (this.version == null) {
                this.version = "";
            }
        }
        return this.version;
    }

    public Map<String, String> getMergedSpanTags() {
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.spanTags.size());
        result.putAll(this.getGlobalTags());
        result.putAll(this.spanTags);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedJmxTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.jmxTags.size() + runtimeTags.size() + 1);
        result.putAll(this.getGlobalTags());
        result.putAll(this.jmxTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedProfilingTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        String host = this.getHostName();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.profilingTags.size() + runtimeTags.size() + 4);
        result.put("host", host);
        result.putAll(this.getGlobalTags());
        result.putAll(this.profilingTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        result.put("language", "jvm");
        result.put("runtime_version", this.runtimeVersion);
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getMergedCrashTrackingTags() {
        Map<String, String> runtimeTags = this.getRuntimeTags();
        String host = this.getHostName();
        Map<String, String> result = Config.newHashMap(this.getGlobalTags().size() + this.crashTrackingTags.size() + runtimeTags.size() + 3);
        result.put("host", host);
        result.putAll(this.getGlobalTags());
        result.putAll(this.crashTrackingTags);
        result.putAll(runtimeTags);
        result.put("service", this.serviceName);
        result.put("language", "jvm");
        return Collections.unmodifiableMap(result);
    }

    public float getInstrumentationAnalyticsSampleRate(String ... aliases) {
        for (String alias : aliases) {
            String configKey = alias + ".analytics.sample-rate";
            Float rate = this.configProvider.getFloat("trace." + configKey, configKey);
            if (null == rate) continue;
            return rate.floatValue();
        }
        return 1.0f;
    }

    public Map<String, String> getGlobalTags() {
        return this.tags;
    }

    private Map<String, String> getRuntimeTags() {
        return Collections.singletonMap("runtime-id", this.runtimeId);
    }

    private Map<String, String> getAzureAppServicesTags() {
        String websiteOwner;
        HashMap<String, String> aasTags = new HashMap<String, String>();
        String siteName = Config.getEnv("WEBSITE_SITE_NAME");
        if (siteName != null) {
            aasTags.put("aas.site.name", siteName);
        }
        if (Config.getEnv("FUNCTIONS_WORKER_RUNTIME") != null || Config.getEnv("FUNCTIONS_EXTENSIONS_VERSION") != null) {
            aasTags.put("aas.site.kind", "functionapp");
            aasTags.put("aas.site.type", "function");
        } else {
            aasTags.put("aas.site.kind", "app");
            aasTags.put("aas.site.type", "app");
        }
        String resourceGroup = Config.getEnv("WEBSITE_RESOURCE_GROUP");
        if (resourceGroup != null) {
            aasTags.put("aas.resource.group", resourceGroup);
        }
        int plusIndex = (websiteOwner = Config.getEnv("WEBSITE_OWNER_NAME")) == null ? -1 : websiteOwner.indexOf("+");
        String subscriptionId = null;
        if (plusIndex > 0) {
            subscriptionId = websiteOwner.substring(0, plusIndex);
            aasTags.put("aas.subscription.id", subscriptionId);
        }
        if (subscriptionId != null && siteName != null && resourceGroup != null) {
            String resourceId = "/subscriptions/" + subscriptionId + "/resourcegroups/" + resourceGroup + "/providers/microsoft.web/sites/" + siteName;
            resourceId = resourceId.toLowerCase();
            aasTags.put("aas.resource.id", resourceId);
        } else {
            log.warn("Unable to generate resource id subscription id: {}, site name: {}, resource group {}", new Object[]{subscriptionId, siteName, resourceGroup});
        }
        String instanceId = Config.getEnv("WEBSITE_INSTANCE_ID");
        instanceId = instanceId == null ? "unknown" : instanceId;
        aasTags.put("aas.environment.instance_id", instanceId);
        String instanceName = Config.getEnv("COMPUTERNAME");
        instanceName = instanceName == null ? "unknown" : instanceName;
        aasTags.put("aas.environment.instance_name", instanceName);
        String operatingSystem = Config.getEnv("WEBSITE_OS");
        operatingSystem = operatingSystem == null ? "unknown" : operatingSystem;
        aasTags.put("aas.environment.os", operatingSystem);
        String siteExtensionVersion = Config.getEnv("DD_AAS_JAVA_EXTENSION_VERSION");
        siteExtensionVersion = siteExtensionVersion == null ? "unknown" : siteExtensionVersion;
        aasTags.put("aas.environment.extension_version", siteExtensionVersion);
        aasTags.put("aas.environment.runtime", Config.getProp("java.vm.name", "unknown"));
        return aasTags;
    }

    public String getFinalProfilingUrl() {
        if (this.profilingUrl != null) {
            return this.profilingUrl;
        }
        if (this.profilingAgentless) {
            return "https://intake.profile." + this.site + "/api/v2/profile";
        }
        return "http://" + this.agentHost + ":" + this.agentPort + "/profiling/v1/input";
    }

    public String getFinalCrashTrackingTelemetryUrl() {
        if (this.crashTrackingAgentless) {
            return "https://all-http-intake.logs." + this.site + "/api/v2/apmtelemetry";
        }
        return "http://" + this.agentHost + ":" + this.agentPort + "/telemetry/proxy/api/v2/apmtelemetry";
    }

    public boolean isJmxFetchIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "jmxfetch.", ".enabled", defaultEnabled);
    }

    public boolean isRuleEnabled(String name) {
        return this.isRuleEnabled(name, true);
    }

    public boolean isRuleEnabled(String name, boolean defaultEnabled) {
        boolean enabled = this.configProvider.getBoolean("trace." + name + ".enabled", defaultEnabled, new String[0]);
        boolean lowerEnabled = this.configProvider.getBoolean("trace." + name.toLowerCase() + ".enabled", defaultEnabled, new String[0]);
        return defaultEnabled ? enabled && lowerEnabled : enabled || lowerEnabled;
    }

    public static boolean jmxFetchIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isJmxFetchIntegrationEnabled(integrationNames, defaultEnabled);
    }

    public boolean isEndToEndDurationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".e2e.duration.enabled", defaultEnabled);
    }

    public boolean isPropagationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".propagation.enabled", defaultEnabled);
    }

    public boolean isLegacyTracingEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".legacy.tracing.enabled", defaultEnabled);
    }

    public boolean isEnabled(boolean defaultEnabled, String settingName, String settingSuffix) {
        return this.configProvider.isEnabled(Collections.singletonList(settingName), "", settingSuffix, defaultEnabled);
    }

    private void logIngoredSettingWarning(String setting, String overridingSetting, String overridingSuffix) {
        log.warn("Setting {} ignored since {}{} is enabled.", new Object[]{Config.propertyNameToSystemPropertyName(setting), Config.propertyNameToSystemPropertyName(overridingSetting), overridingSuffix});
    }

    public boolean isTraceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "", ".analytics.enabled", defaultEnabled);
    }

    public boolean isTraceAnalyticsIntegrationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".analytics.enabled", defaultEnabled);
    }

    public boolean isSamplingMechanismValidationDisabled() {
        return this.configProvider.getBoolean("trace.sampling.mechanism.validation.disabled", false, new String[0]);
    }

    public <T extends Enum<T>> T getEnumValue(String name, Class<T> type, T defaultValue) {
        return this.configProvider.getEnum(name, type, defaultValue);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = Config.getProp("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = Config.getEnv(Strings.toEnvVar("dd.trace.debug"));
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    public static boolean traceAnalyticsIntegrationEnabled(SortedSet<String> integrationNames, boolean defaultEnabled) {
        return Config.get().isTraceAnalyticsIntegrationEnabled(integrationNames, defaultEnabled);
    }

    private Set<PropagationStyle> getPropagationStyleSetSettingFromEnvironmentOrDefault(String name, String defaultValue) {
        String value = this.configProvider.getString(name, defaultValue, new String[0]);
        Set<PropagationStyle> result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(value));
        if (result.isEmpty()) {
            result = Config.convertStringSetToPropagationStyleSet(Config.parseStringIntoSetOfNonEmptyStrings(defaultValue));
        }
        return result;
    }

    @Nonnull
    private static String propertyNameToSystemPropertyName(String setting) {
        return PREFIX + setting;
    }

    @Nonnull
    private static Map<String, String> newHashMap(int size) {
        return new HashMap<String, String>(size + 1, 1.0f);
    }

    @Nonnull
    private Map<String, String> getMapWithPropertiesDefinedByEnvironment(@Nonnull Map<String, String> map, String ... propNames) {
        HashMap<String, String> res = new HashMap<String, String>(map);
        for (String propName : propNames) {
            String val = this.configProvider.getString(propName);
            if (val == null) continue;
            res.put(propName, val);
        }
        return Collections.unmodifiableMap(res);
    }

    @Nonnull
    private static Set<String> parseStringIntoSetOfNonEmptyStrings(String str) {
        int i;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int start = 0;
        for (i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!Character.isWhitespace(c) && c != ',') continue;
            if (i - start - 1 > 0) {
                result.add(str.substring(start, i));
            }
            start = i + 1;
        }
        if (i - start - 1 > 0) {
            result.add(str.substring(start));
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    private static Set<PropagationStyle> convertStringSetToPropagationStyleSet(Set<String> input) {
        LinkedHashSet<PropagationStyle> result = new LinkedHashSet<PropagationStyle>();
        for (String value : input) {
            try {
                result.add(PropagationStyle.valueOf(value.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.debug("Cannot recognize config string value: {}, {}", (Object)value, PropagationStyle.class);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static String initHostName() {
        String possibleHostname = Config.isWindowsOS() ? Config.getEnv("COMPUTERNAME") : Config.getEnv("HOSTNAME");
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from environment variable");
            return possibleHostname.trim();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("hostname").getInputStream()));){
            possibleHostname = reader.readLine();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (possibleHostname != null && !possibleHostname.isEmpty()) {
            log.debug("Determined hostname from hostname command");
            return possibleHostname.trim();
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static boolean isWindowsOS() {
        return Config.getProp("os.name").startsWith("Windows");
    }

    private static String getEnv(String name) {
        String value = System.getenv(name);
        if (value != null) {
            ConfigCollector.get().put(name, (Object)value);
        }
        return value;
    }

    private static Pattern getPattern(String defaultValue, String userValue) {
        try {
            if (userValue != null) {
                return Pattern.compile(userValue);
            }
        }
        catch (Exception e) {
            log.debug("Cannot create pattern from user value {}", (Object)userValue);
        }
        return Pattern.compile(defaultValue);
    }

    private static String getProp(String name) {
        return Config.getProp(name, null);
    }

    private static String getProp(String name, String def) {
        String value = System.getProperty(name, def);
        if (value != null) {
            ConfigCollector.get().put(name, (Object)value);
        }
        return value;
    }

    public static Config get() {
        return INSTANCE;
    }

    @Deprecated
    public static Config get(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return INSTANCE;
        }
        return new Config(ConfigProvider.withPropertiesOverride(properties));
    }

    public String toString() {
        return "Config{runtimeId='" + this.runtimeId + '\'' + ", runtimeVersion='" + this.runtimeVersion + ", apiKey=" + (this.apiKey == null ? "null" : "****") + ", site='" + this.site + '\'' + ", hostName='" + this.hostName + '\'' + ", serviceName='" + this.serviceName + '\'' + ", serviceNameSetByUser=" + this.serviceNameSetByUser + ", rootContextServiceName=" + this.rootContextServiceName + ", traceEnabled=" + this.traceEnabled + ", integrationSynapseLegacyOperationName=" + this.integrationSynapseLegacyOperationName + ", writerType='" + this.writerType + '\'' + ", agentConfiguredUsingDefault=" + this.agentConfiguredUsingDefault + ", agentUrl='" + this.agentUrl + '\'' + ", agentHost='" + this.agentHost + '\'' + ", agentPort=" + this.agentPort + ", agentUnixDomainSocket='" + this.agentUnixDomainSocket + '\'' + ", agentTimeout=" + this.agentTimeout + ", noProxyHosts=" + this.noProxyHosts + ", prioritySamplingEnabled=" + this.prioritySamplingEnabled + ", prioritySamplingForce='" + this.prioritySamplingForce + '\'' + ", traceResolverEnabled=" + this.traceResolverEnabled + ", serviceMapping=" + this.serviceMapping + ", tags=" + this.tags + ", spanTags=" + this.spanTags + ", jmxTags=" + this.jmxTags + ", requestHeaderTags=" + this.requestHeaderTags + ", responseHeaderTags=" + this.responseHeaderTags + ", httpServerErrorStatuses=" + this.httpServerErrorStatuses + ", httpClientErrorStatuses=" + this.httpClientErrorStatuses + ", httpServerTagQueryString=" + this.httpServerTagQueryString + ", httpServerRawQueryString=" + this.httpServerRawQueryString + ", httpServerRawResource=" + this.httpServerRawResource + ", httpServerRouteBasedNaming=" + this.httpServerRouteBasedNaming + ", httpServerPathResourceNameMapping=" + this.httpServerPathResourceNameMapping + ", httpClientTagQueryString=" + this.httpClientTagQueryString + ", httpClientSplitByDomain=" + this.httpClientSplitByDomain + ", dbClientSplitByInstance=" + this.dbClientSplitByInstance + ", dbClientSplitByInstanceTypeSuffix=" + this.dbClientSplitByInstanceTypeSuffix + ", splitByTags=" + this.splitByTags + ", scopeDepthLimit=" + this.scopeDepthLimit + ", scopeStrictMode=" + this.scopeStrictMode + ", scopeInheritAsyncPropagation=" + this.scopeInheritAsyncPropagation + ", scopeIterationKeepAlive=" + this.scopeIterationKeepAlive + ", partialFlushMinSpans=" + this.partialFlushMinSpans + ", traceStrictWritesEnabled=" + this.traceStrictWritesEnabled + ", propagationStylesToExtract=" + this.propagationStylesToExtract + ", propagationStylesToInject=" + this.propagationStylesToInject + ", clockSyncPeriod=" + this.clockSyncPeriod + ", jmxFetchEnabled=" + this.jmxFetchEnabled + ", dogStatsDStartDelay=" + this.dogStatsDStartDelay + ", jmxFetchConfigDir='" + this.jmxFetchConfigDir + '\'' + ", jmxFetchConfigs=" + this.jmxFetchConfigs + ", jmxFetchMetricsConfigs=" + this.jmxFetchMetricsConfigs + ", jmxFetchCheckPeriod=" + this.jmxFetchCheckPeriod + ", jmxFetchInitialRefreshBeansPeriod=" + this.jmxFetchInitialRefreshBeansPeriod + ", jmxFetchRefreshBeansPeriod=" + this.jmxFetchRefreshBeansPeriod + ", jmxFetchStatsdHost='" + this.jmxFetchStatsdHost + '\'' + ", jmxFetchStatsdPort=" + this.jmxFetchStatsdPort + ", jmxFetchMultipleRuntimeServicesEnabled=" + this.jmxFetchMultipleRuntimeServicesEnabled + ", jmxFetchMultipleRuntimeServicesLimit=" + this.jmxFetchMultipleRuntimeServicesLimit + ", healthMetricsEnabled=" + this.healthMetricsEnabled + ", healthMetricsStatsdHost='" + this.healthMetricsStatsdHost + '\'' + ", healthMetricsStatsdPort=" + this.healthMetricsStatsdPort + ", perfMetricsEnabled=" + this.perfMetricsEnabled + ", tracerMetricsEnabled=" + this.tracerMetricsEnabled + ", tracerMetricsBufferingEnabled=" + this.tracerMetricsBufferingEnabled + ", tracerMetricsMaxAggregates=" + this.tracerMetricsMaxAggregates + ", tracerMetricsMaxPending=" + this.tracerMetricsMaxPending + ", logsMDCTagsInjectionEnabled=" + this.logsMDCTagsInjectionEnabled + ", reportHostName=" + this.reportHostName + ", traceAnalyticsEnabled=" + this.traceAnalyticsEnabled + ", traceSamplingServiceRules=" + this.traceSamplingServiceRules + ", traceSamplingOperationRules=" + this.traceSamplingOperationRules + ", traceSamplingJsonRules=" + this.traceSamplingRules + ", traceSampleRate=" + this.traceSampleRate + ", traceRateLimit=" + this.traceRateLimit + ", profilingEnabled=" + this.profilingEnabled + ", profilingAgentless=" + this.profilingAgentless + ", profilingUrl='" + this.profilingUrl + '\'' + ", profilingTags=" + this.profilingTags + ", profilingStartDelay=" + this.profilingStartDelay + ", profilingStartForceFirst=" + this.profilingStartForceFirst + ", profilingUploadPeriod=" + this.profilingUploadPeriod + ", profilingTemplateOverrideFile='" + this.profilingTemplateOverrideFile + '\'' + ", profilingUploadTimeout=" + this.profilingUploadTimeout + ", profilingUploadCompression='" + this.profilingUploadCompression + '\'' + ", profilingProxyHost='" + this.profilingProxyHost + '\'' + ", profilingProxyPort=" + this.profilingProxyPort + ", profilingProxyUsername='" + this.profilingProxyUsername + '\'' + ", profilingProxyPassword=" + (this.profilingProxyPassword == null ? "null" : "****") + ", profilingExceptionSampleLimit=" + this.profilingExceptionSampleLimit + ", profilingExceptionHistogramTopItems=" + this.profilingExceptionHistogramTopItems + ", profilingExceptionHistogramMaxCollectionSize=" + this.profilingExceptionHistogramMaxCollectionSize + ", profilingExcludeAgentThreads=" + this.profilingExcludeAgentThreads + ", crashTrackingTags=" + this.crashTrackingTags + ", crashTrackingAgentless=" + this.crashTrackingAgentless + ", remoteConfigEnabled=" + this.remoteConfigEnabled + ", remoteConfigUrl=" + this.remoteConfigUrl + ", remoteConfigInitialPollInterval=" + this.remoteConfigInitialPollInterval + ", remoteConfigMaxPayloadSize=" + this.remoteConfigMaxPayloadSize + ", remoteConfigIntegrityCheckEnabled=" + this.remoteConfigIntegrityCheckEnabled + ", debuggerEnabled=" + this.debuggerEnabled + ", debuggerUploadTimeout=" + this.debuggerUploadTimeout + ", debuggerUploadFlushInterval=" + this.debuggerUploadFlushInterval + ", debuggerClassFileDumpEnabled=" + this.debuggerClassFileDumpEnabled + ", debuggerPollInterval=" + this.debuggerPollInterval + ", debuggerDiagnosticsInterval=" + this.debuggerDiagnosticsInterval + ", debuggerMetricEnabled=" + this.debuggerMetricEnabled + ", debuggerProbeFileLocation=" + this.debuggerProbeFileLocation + ", debuggerUploadBatchSize=" + this.debuggerUploadBatchSize + ", debuggerMaxPayloadSize=" + this.debuggerMaxPayloadSize + ", debuggerVerifyByteCode=" + this.debuggerVerifyByteCode + ", debuggerInstrumentTheWorld=" + this.debuggerInstrumentTheWorld + ", debuggerExcludeFile=" + this.debuggerExcludeFile + ", awsPropagationEnabled=" + this.awsPropagationEnabled + ", sqsPropagationEnabled=" + this.sqsPropagationEnabled + ", kafkaClientPropagationEnabled=" + this.kafkaClientPropagationEnabled + ", kafkaClientPropagationDisabledTopics=" + this.kafkaClientPropagationDisabledTopics + ", kafkaClientBase64DecodingEnabled=" + this.kafkaClientBase64DecodingEnabled + ", jmsPropagationEnabled=" + this.jmsPropagationEnabled + ", jmsPropagationDisabledTopics=" + this.jmsPropagationDisabledTopics + ", jmsPropagationDisabledQueues=" + this.jmsPropagationDisabledQueues + ", rabbitPropagationEnabled=" + this.rabbitPropagationEnabled + ", rabbitPropagationDisabledQueues=" + this.rabbitPropagationDisabledQueues + ", rabbitPropagationDisabledExchanges=" + this.rabbitPropagationDisabledExchanges + ", messageBrokerSplitByDestination=" + this.messageBrokerSplitByDestination + ", hystrixTagsEnabled=" + this.hystrixTagsEnabled + ", hystrixMeasuredEnabled=" + this.hystrixMeasuredEnabled + ", igniteCacheIncludeKeys=" + this.igniteCacheIncludeKeys + ", servletPrincipalEnabled=" + this.servletPrincipalEnabled + ", servletAsyncTimeoutError=" + this.servletAsyncTimeoutError + ", datadogTagsLimit=" + this.xDatadogTagsMaxLength + ", traceAgentV05Enabled=" + this.traceAgentV05Enabled + ", debugEnabled=" + this.debugEnabled + ", configFile='" + this.configFileStatus + '\'' + ", idGenerationStrategy=" + this.idGenerationStrategy + ", grpcIgnoredInboundMethods=" + this.grpcIgnoredInboundMethods + ", grpcIgnoredOutboundMethods=" + this.grpcIgnoredOutboundMethods + ", grpcServerErrorStatuses=" + this.grpcServerErrorStatuses + ", grpcClientErrorStatuses=" + this.grpcClientErrorStatuses + ", configProvider=" + this.configProvider + ", clientIpEnabled=" + this.clientIpEnabled + ", appSecEnabled=" + (Object)((Object)this.appSecEnabled) + ", appSecReportingInband=" + this.appSecReportingInband + ", appSecRulesFile='" + this.appSecRulesFile + "', appSecHttpBlockedTemplateHtml=" + this.appSecHttpBlockedTemplateHtml + ", appSecHttpBlockedTemplateJson=" + this.appSecHttpBlockedTemplateJson + ", cwsEnabled=" + this.cwsEnabled + ", cwsTlsRefresh=" + this.cwsTlsRefresh + ", instrumenterConfig=" + this.instrumenterConfig + '}';
    }
}

