/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.DDId;

public class DDTraceId {
    public static final DDTraceId ZERO = new DDTraceId(0L, "0", null);
    public static final DDTraceId MAX = new DDTraceId(-1L, "18446744073709551615", null);
    public static final DDTraceId ONE = DDTraceId.from(1L);
    private final long id;
    private String str;
    private String hex;

    public static DDTraceId from(long id) {
        return DDTraceId.create(id, null);
    }

    public static DDTraceId from(String s) throws NumberFormatException {
        return DDTraceId.create(DDId.parseUnsignedLong(s), s);
    }

    public static DDTraceId fromHex(String s) throws NumberFormatException {
        return DDTraceId.create(DDId.parseUnsignedLongHex(s), null);
    }

    public static DDTraceId fromHexTruncatedWithOriginal(String s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        int trimmed = Math.min(s.length(), 16);
        return new DDTraceId(DDId.parseUnsignedLongHex(s, len - trimmed, trimmed), null, s);
    }

    private static DDTraceId create(long id, String str) {
        if (id == 0L) {
            return ZERO;
        }
        if (id == -1L) {
            return MAX;
        }
        return new DDTraceId(id, str, null);
    }

    private DDTraceId(long id, String str, String original) {
        this.id = id;
        this.str = str;
        this.hex = original;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DDTraceId)) {
            return false;
        }
        DDTraceId ddId = (DDTraceId)o;
        return this.id == ddId.id;
    }

    public int hashCode() {
        long id = this.id;
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        String s = this.str;
        if (s == null) {
            this.str = s = Long.toUnsignedString(this.id);
        }
        return s;
    }

    public String toHexString() {
        return Long.toHexString(this.id);
    }

    public String toHexStringPadded(int size) {
        return DDId.toHexStringPadded(this.id, size);
    }

    public String toHexStringOrOriginal() {
        String h = this.hex;
        if (h == null) {
            this.hex = h = this.toHexString();
        }
        return h;
    }

    public long toLong() {
        return this.id;
    }
}

