/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.cache;

import datadog.trace.api.Functions;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import java.util.function.Function;

public final class QualifiedClassNameCache
extends ClassValue<Leaf> {
    private final Function<Class<?>, CharSequence> formatter;
    private final Functions.Join joiner;
    private final int leafSize;

    public QualifiedClassNameCache(Function<Class<?>, CharSequence> formatter, Functions.Join joiner) {
        this(formatter, joiner, 16);
    }

    public QualifiedClassNameCache(Function<Class<?>, CharSequence> formatter, Functions.Join joiner, int leafSize) {
        this.formatter = formatter;
        this.joiner = joiner;
        this.leafSize = leafSize;
    }

    @Override
    protected Leaf computeValue(Class<?> type) {
        return new Leaf(this.formatter.apply(type), this.joiner, this.leafSize);
    }

    public CharSequence getClassName(Class<?> klass) {
        return ((Leaf)this.get(klass)).getName();
    }

    public CharSequence getQualifiedName(Class<?> klass, String qualifier) {
        return ((Leaf)this.get(klass)).get(qualifier);
    }

    static final class Leaf {
        private final CharSequence name;
        private final DDCache<CharSequence, CharSequence> cache;
        private final Function<CharSequence, CharSequence> joiner;

        private Leaf(CharSequence name, Functions.Join joiner, int leafSize) {
            this.name = name;
            this.cache = DDCaches.newUnboundedCache(leafSize);
            this.joiner = joiner.curry(name);
        }

        CharSequence get(CharSequence name) {
            return this.cache.computeIfAbsent(name, this.joiner);
        }

        CharSequence getName() {
            return this.name;
        }
    }
}

