/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.org.jctools.queues.MessagePassingQueue;
import ddtrot.org.jctools.queues.MpscBlockingConsumerArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PendingTraceBuffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 4096;

    public static PendingTraceBuffer delaying(TimeSource timeSource) {
        return new DelayingPendingTraceBuffer(4096, timeSource);
    }

    public static PendingTraceBuffer discarding() {
        return new DiscardingPendingTraceBuffer();
    }

    public abstract void start();

    @Override
    public abstract void close();

    public abstract void flush();

    public abstract void enqueue(Element var1);

    static class DiscardingPendingTraceBuffer
    extends PendingTraceBuffer {
        private static final Logger log = LoggerFactory.getLogger(DiscardingPendingTraceBuffer.class);

        DiscardingPendingTraceBuffer() {
        }

        @Override
        public void start() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void enqueue(Element pendingTrace) {
            log.debug("PendingTrace enqueued but won't be reported. Root span: {}", (Object)pendingTrace.getRootSpan());
        }
    }

    private static class DelayingPendingTraceBuffer
    extends PendingTraceBuffer {
        private static final long FORCE_SEND_DELAY_MS = TimeUnit.SECONDS.toMillis(5L);
        private static final long SEND_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(500L);
        private static final long SLEEP_TIME_MS = 100L;
        private final MpscBlockingConsumerArrayQueue<Element> queue;
        private final Thread worker;
        private final TimeSource timeSource;
        private volatile boolean closed = false;
        private final AtomicInteger flushCounter = new AtomicInteger(0);

        @Override
        public void enqueue(Element pendingTrace) {
            if (pendingTrace.setEnqueued(true) && !this.queue.offer(pendingTrace)) {
                pendingTrace.setEnqueued(false);
                pendingTrace.write();
            }
        }

        @Override
        public void start() {
            this.worker.start();
        }

        @Override
        public void close() {
            this.closed = true;
            this.worker.interrupt();
            try {
                this.worker.join(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void yieldOrSleep(int loop) {
            if (loop <= 3) {
                Thread.yield();
            } else {
                try {
                    Thread.sleep(10L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        @Override
        public void flush() {
            if (this.worker.isAlive()) {
                int count = this.flushCounter.get();
                int loop = 1;
                boolean signaled = this.queue.offer(FlushElement.FLUSH_ELEMENT);
                while (!this.closed && !signaled) {
                    this.yieldOrSleep(loop++);
                    signaled = this.queue.offer(FlushElement.FLUSH_ELEMENT);
                }
                int newCount = this.flushCounter.get();
                while (!this.closed && count >= newCount) {
                    this.yieldOrSleep(loop++);
                    newCount = this.flushCounter.get();
                }
            }
        }

        public DelayingPendingTraceBuffer(int bufferSize, TimeSource timeSource) {
            this.queue = new MpscBlockingConsumerArrayQueue(bufferSize);
            this.worker = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.TRACE_MONITOR, new Worker());
            this.timeSource = timeSource;
        }

        private final class Worker
        implements Runnable {
            private Worker() {
            }

            @Override
            public void run() {
                try {
                    while (!DelayingPendingTraceBuffer.this.closed && !Thread.currentThread().isInterrupted()) {
                        Element pendingTrace = (Element)DelayingPendingTraceBuffer.this.queue.take();
                        if (pendingTrace instanceof FlushElement) {
                            DelayingPendingTraceBuffer.this.queue.drain(WriteDrain.WRITE_DRAIN);
                            DelayingPendingTraceBuffer.this.flushCounter.incrementAndGet();
                            continue;
                        }
                        pendingTrace.setEnqueued(false);
                        long oldestFinishedTime = pendingTrace.oldestFinishedTime();
                        long finishTimestampMillis = TimeUnit.NANOSECONDS.toMillis(oldestFinishedTime);
                        if (finishTimestampMillis <= DelayingPendingTraceBuffer.this.timeSource.getCurrentTimeMillis() - FORCE_SEND_DELAY_MS) {
                            pendingTrace.write();
                            continue;
                        }
                        if (pendingTrace.lastReferencedNanosAgo(SEND_DELAY_NS)) {
                            pendingTrace.write();
                            continue;
                        }
                        DelayingPendingTraceBuffer.this.enqueue(pendingTrace);
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private static final class FlushElement
        implements Element {
            static FlushElement FLUSH_ELEMENT = new FlushElement();

            private FlushElement() {
            }

            @Override
            public long oldestFinishedTime() {
                return 0L;
            }

            @Override
            public boolean lastReferencedNanosAgo(long nanos) {
                return false;
            }

            @Override
            public void write() {
            }

            @Override
            public DDSpan getRootSpan() {
                return null;
            }

            @Override
            public boolean setEnqueued(boolean enqueued) {
                return true;
            }
        }

        private static final class WriteDrain
        implements MessagePassingQueue.Consumer<Element> {
            private static final WriteDrain WRITE_DRAIN = new WriteDrain();

            private WriteDrain() {
            }

            @Override
            public void accept(Element pendingTrace) {
                pendingTrace.write();
            }
        }
    }

    public static interface Element {
        public long oldestFinishedTime();

        public boolean lastReferencedNanosAgo(long var1);

        public void write();

        public DDSpan getRootSpan();

        public boolean setEnqueued(boolean var1);
    }
}

