/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.TagContextExtractor;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HaystackHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HaystackHttpCodec.class);
    private static final String OT_BAGGAGE_PREFIX = "Baggage-";
    private static final String TRACE_ID_KEY = "Trace-ID";
    private static final String SPAN_ID_KEY = "Span-ID";
    private static final String PARENT_ID_KEY = "Parent-ID";
    private static final String DD_TRACE_ID_BAGGAGE_KEY = "Baggage-Datadog-Trace-Id";
    private static final String DD_SPAN_ID_BAGGAGE_KEY = "Baggage-Datadog-Span-Id";
    private static final String DD_PARENT_ID_BAGGAGE_KEY = "Baggage-Datadog-Parent-Id";
    private static final String HAYSTACK_TRACE_ID_BAGGAGE_KEY = "Haystack-Trace-ID";
    private static final String HAYSTACK_SPAN_ID_BAGGAGE_KEY = "Haystack-Span-ID";
    private static final String HAYSTACK_PARENT_ID_BAGGAGE_KEY = "Haystack-Parent-ID";
    public static final String DATADOG = "44617461-646f-6721";
    public static final HttpCodec.Injector INJECTOR = new Injector();

    private HaystackHttpCodec() {
    }

    public static HttpCodec.Extractor newExtractor(Map<String, String> tagMapping) {
        return new TagContextExtractor(tagMapping, new ContextInterpreter.Factory(){

            @Override
            protected ContextInterpreter construct(Map<String, String> mapping) {
                return new HaystackContextInterpreter((Map)mapping);
            }
        });
    }

    private static String convertLongToUUID(long id) {
        String idHex = String.format("%016x", id);
        return "44617461-646f-6721-" + idHex.substring(0, 4) + "-" + idHex.substring(4);
    }

    @SuppressForbidden
    private static String convertUUIDToHexString(String value) {
        try {
            if (value.contains("-")) {
                String[] strings = value.split("-");
                if (strings.length == 5) {
                    String idHex = strings[3] + strings[4];
                    return idHex;
                }
                throw new NumberFormatException("Invalid UUID format: " + value);
            }
            int length = value.length();
            if (length == 32) {
                return value.substring(16);
            }
            return value;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception when converting UUID to BigInteger: " + value, e);
        }
    }

    private static class HaystackContextInterpreter
    extends ContextInterpreter {
        private static final String BAGGAGE_PREFIX_LC = "baggage-";
        private static final int TRACE_ID = 0;
        private static final int SPAN_ID = 1;
        private static final int PARENT_ID = 2;
        private static final int TAGS = 3;
        private static final int BAGGAGE = 4;
        private static final int IGNORE = -1;

        private HaystackContextInterpreter(Map<String, String> taggedHeaders) {
            super(taggedHeaders, Config.get());
        }

        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            char first = Character.toLowerCase(key.charAt(0));
            String lowerCaseKey = null;
            int classification = -1;
            switch (first) {
                case 't': {
                    if (!HaystackHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 0;
                    break;
                }
                case 's': {
                    if (!HaystackHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 1;
                    break;
                }
                case 'p': {
                    if (!HaystackHttpCodec.PARENT_ID_KEY.equalsIgnoreCase(key)) break;
                    classification = 2;
                    break;
                }
                case 'x': {
                    if (!this.handledXForwarding(key, value)) break;
                    return true;
                }
                case 'f': {
                    if (!this.handledForwarding(key, value)) break;
                    return true;
                }
                case 'b': {
                    lowerCaseKey = this.toLowerCase(key);
                    if (!lowerCaseKey.startsWith(BAGGAGE_PREFIX_LC)) break;
                    classification = 4;
                    break;
                }
                case 'u': {
                    if (!this.handledUserAgent(key, value)) break;
                    return true;
                }
            }
            if (this.handledIpHeaders(key, value)) {
                return true;
            }
            if (!this.taggedHeaders.isEmpty() && classification == -1 && this.taggedHeaders.containsKey(lowerCaseKey = this.toLowerCase(key))) {
                classification = 3;
            }
            if (-1 != classification) {
                try {
                    String firstValue = HttpCodec.firstHeaderValue(value);
                    if (null != firstValue) {
                        switch (classification) {
                            case 0: {
                                this.traceId = DDTraceId.fromHex(HaystackHttpCodec.convertUUIDToHexString(value));
                                this.addBaggageItem(HaystackHttpCodec.HAYSTACK_TRACE_ID_BAGGAGE_KEY, value);
                                break;
                            }
                            case 1: {
                                this.spanId = DDSpanId.fromHex(HaystackHttpCodec.convertUUIDToHexString(value));
                                this.addBaggageItem(HaystackHttpCodec.HAYSTACK_SPAN_ID_BAGGAGE_KEY, value);
                                break;
                            }
                            case 2: {
                                this.addBaggageItem(HaystackHttpCodec.HAYSTACK_PARENT_ID_BAGGAGE_KEY, value);
                                break;
                            }
                            case 3: {
                                String mappedKey = (String)this.taggedHeaders.get(lowerCaseKey);
                                if (null == mappedKey) break;
                                if (this.tags.isEmpty()) {
                                    this.tags = new TreeMap();
                                }
                                this.tags.put(mappedKey, HttpCodec.decode(value));
                                break;
                            }
                            case 4: {
                                this.addBaggageItem(lowerCaseKey.substring(BAGGAGE_PREFIX_LC.length()), value);
                                break;
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.invalidateContext();
                    log.debug("Exception when extracting context", (Throwable)e);
                    return false;
                }
            }
            return true;
        }

        private void addBaggageItem(String key, String value) {
            if (this.baggage.isEmpty()) {
                this.baggage = new TreeMap();
            }
            this.baggage.put(key, HttpCodec.decode(value));
        }

        @Override
        protected int defaultSamplingPriority() {
            return 1;
        }
    }

    private static class Injector
    implements HttpCodec.Injector {
        private Injector() {
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            try {
                String originalHaystackTraceId = this.getBaggageItemIgnoreCase(context.getBaggageItems(), HaystackHttpCodec.HAYSTACK_TRACE_ID_BAGGAGE_KEY);
                String injectedTraceId = originalHaystackTraceId != null && DDTraceId.fromHex(HaystackHttpCodec.convertUUIDToHexString(originalHaystackTraceId)).equals(context.getTraceId()) ? originalHaystackTraceId : HaystackHttpCodec.convertLongToUUID(context.getTraceId().toLong());
                setter.set(carrier, HaystackHttpCodec.TRACE_ID_KEY, injectedTraceId);
                context.setTag(HaystackHttpCodec.HAYSTACK_TRACE_ID_BAGGAGE_KEY, injectedTraceId);
                setter.set(carrier, HaystackHttpCodec.DD_TRACE_ID_BAGGAGE_KEY, HttpCodec.encode(context.getTraceId().toString()));
                setter.set(carrier, HaystackHttpCodec.SPAN_ID_KEY, HaystackHttpCodec.convertLongToUUID(context.getSpanId()));
                setter.set(carrier, HaystackHttpCodec.DD_SPAN_ID_BAGGAGE_KEY, HttpCodec.encode(DDSpanId.toString(context.getSpanId())));
                setter.set(carrier, HaystackHttpCodec.PARENT_ID_KEY, HaystackHttpCodec.convertLongToUUID(context.getParentId()));
                setter.set(carrier, HaystackHttpCodec.DD_PARENT_ID_BAGGAGE_KEY, HttpCodec.encode(DDSpanId.toString(context.getParentId())));
                for (Map.Entry<String, String> entry : context.baggageItems()) {
                    setter.set(carrier, HaystackHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
                }
                log.debug("{} - Haystack parent context injected - {}", (Object)context.getTraceId(), (Object)injectedTraceId);
            }
            catch (NumberFormatException e) {
                log.debug("Cannot parse context id(s): {} {}", new Object[]{context.getTraceId(), context.getSpanId(), e});
            }
        }

        private String getBaggageItemIgnoreCase(Map<String, String> baggage, String key) {
            for (Map.Entry<String, String> mapping : baggage.entrySet()) {
                if (!key.equalsIgnoreCase(mapping.getKey())) continue;
                return mapping.getValue();
            }
            return null;
        }
    }
}

