/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import java.util.Map;

public class TagContextExtractor
implements HttpCodec.Extractor {
    protected final Map<String, String> taggedHeaders;
    private final ThreadLocal<ContextInterpreter> ctxInterpreter;

    public TagContextExtractor(final Map<String, String> taggedHeaders, final ContextInterpreter.Factory factory) {
        this.taggedHeaders = taggedHeaders;
        this.ctxInterpreter = new ThreadLocal<ContextInterpreter>(){

            @Override
            protected ContextInterpreter initialValue() {
                return factory.create(taggedHeaders);
            }
        };
    }

    @Override
    public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        ContextInterpreter interpreter = this.ctxInterpreter.get().reset();
        getter.forEachKey(carrier, interpreter);
        return interpreter.build();
    }
}

