/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.cache;

import ddtrot.dd.trace.api.cache.DDPartialKeyCache;
import ddtrot.dd.trace.api.cache.FixedSizeCache;
import java.util.Arrays;
import javax.annotation.Nullable;

final class FixedSizePartialKeyCache<K, V>
implements DDPartialKeyCache<K, V> {
    private final int mask;
    private final HVElement<V>[] elements;

    FixedSizePartialKeyCache(int capacity) {
        int size = FixedSizeCache.calculateSize(capacity);
        this.elements = new HVElement[size];
        this.mask = size - 1;
    }

    @Override
    public V computeIfAbsent(K key, int m, int n, DDPartialKeyCache.Hasher<K> hasher, DDPartialKeyCache.Comparator<K, V> comparator, DDPartialKeyCache.Producer<K, ? extends V> producer) {
        Object value;
        int hash;
        if (key == null) {
            return null;
        }
        int h = hash = hasher.apply(key, m, n);
        int firstPos = h & this.mask;
        int i = 1;
        while (true) {
            int pos;
            HVElement<V> current;
            if ((current = this.elements[pos = h & this.mask]) == null) {
                value = this.produceAndStoreValue(producer, hash, key, m, n, pos);
                break;
            }
            if (hash == current.hash && comparator.test(key, m, n, current.value)) {
                value = current.value;
                break;
            }
            if (i == 3) {
                value = this.produceAndStoreValue(producer, hash, key, m, n, firstPos);
                break;
            }
            h = FixedSizeCache.rehash(h);
            ++i;
        }
        return value;
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
    }

    private V produceAndStoreValue(DDPartialKeyCache.Producer<K, ? extends V> producer, int hash, K key, int m, int n, int pos) {
        V value = producer.apply(key, m, n);
        this.elements[pos] = new HVElement<V>(hash, value);
        return value;
    }

    static final class HVElement<U> {
        final int hash;
        final U value;

        HVElement(int hash, @Nullable U value) {
            this.hash = hash;
            this.value = value;
        }
    }
}

