/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.telemetry;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.iast.telemetry.IastMetric;
import ddtrot.dd.trace.api.iast.telemetry.IastMetricHandler;
import ddtrot.dd.trace.api.iast.telemetry.IastTelemetryCollectorImpl;
import ddtrot.dd.trace.api.iast.telemetry.NoOpTelemetryCollector;
import ddtrot.dd.trace.api.iast.telemetry.Verbosity;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IastTelemetryCollector {
    public static final Logger LOGGER = LoggerFactory.getLogger(IastTelemetryCollector.class);

    public static void add(@Nonnull IastMetric metric, long value) {
        IastTelemetryCollector.add(metric, value, null, null);
    }

    public static void add(@Nonnull IastMetric metric, long value, @Nullable String tag) {
        IastTelemetryCollector.add(metric, value, tag, null);
    }

    public static void add(@Nonnull IastMetric metric, long value, @Nullable RequestContext ctx) {
        IastTelemetryCollector.add(metric, value, null, ctx);
    }

    public static void add(@Nonnull IastMetric metric, long value, @Nullable String tag, @Nullable RequestContext ctx) {
        try {
            IastTelemetryCollector instance = Holder.get(metric, ctx);
            instance.addMetric(metric, value, tag);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to add metric {}", (Object)metric, (Object)e);
        }
    }

    public static Collection<MetricData> drain() {
        return Holder.GLOBAL.drainMetrics();
    }

    public void addMetric(IastMetric var1, long var2, String var4);

    public void merge(Collection<MetricData> var1);

    public Collection<MetricData> drainMetrics();

    public static final class Point {
        private final long timestamp;
        private final long value;

        public Point(long value) {
            this(System.currentTimeMillis() / 1000L, value);
        }

        public Point(long timestamp, long value) {
            this.timestamp = timestamp;
            this.value = value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static final class MetricData {
        private final IastMetric metric;
        private final String tag;
        private final List<Point> points;

        public MetricData(IastMetric metric, List<Point> points) {
            this(metric, null, points);
        }

        public MetricData(IastMetric metric, String tag, List<Point> points) {
            this.metric = metric;
            this.tag = tag;
            this.points = points;
        }

        public IastMetric getMetric() {
            return this.metric;
        }

        public String getTag() {
            return this.tag;
        }

        public List<Point> getPoints() {
            return this.points;
        }
    }

    public static interface HasTelemetryCollector {
        public IastTelemetryCollector getTelemetryCollector();
    }

    public static class Holder {
        public static final IastTelemetryCollector GLOBAL = Holder.globalCollector();

        public static IastTelemetryCollector get(@Nonnull IastMetric metric, @Nullable RequestContext ctx) {
            Object iastRequestContext;
            if (metric.getScope() == IastMetric.Scope.REQUEST && (ctx = Holder.activeRequestContext(ctx)) != null && (iastRequestContext = ctx.getData(RequestContextSlot.IAST)) instanceof HasTelemetryCollector) {
                return ((HasTelemetryCollector)iastRequestContext).getTelemetryCollector();
            }
            return GLOBAL;
        }

        private static RequestContext activeRequestContext(RequestContext context) {
            if (context != null) {
                return context;
            }
            AgentSpan span = AgentTracer.activeSpan();
            return span == null ? null : span.getRequestContext();
        }

        static IastTelemetryCollector globalCollector() {
            Config config = Config.get();
            if (!config.isTelemetryEnabled() || config.getIastTelemetryVerbosity() == Verbosity.OFF) {
                return new NoOpTelemetryCollector();
            }
            return new IastTelemetryCollectorImpl(Holder::globalHandlerFor);
        }

        private static IastMetricHandler globalHandlerFor(IastMetric metric) {
            return metric.getScope() == IastMetric.Scope.REQUEST ? IastMetricHandler.aggregated(metric) : IastMetricHandler.conflated(metric);
        }
    }
}

