/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.telemetry;

import ddtrot.dd.trace.api.iast.telemetry.IastMetric;
import ddtrot.dd.trace.api.iast.telemetry.IastMetricHandler;
import ddtrot.dd.trace.api.iast.telemetry.IastTelemetryCollector;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class IastTelemetryCollectorImpl
implements IastTelemetryCollector {
    private final ConcurrentHashMap<IastMetric, IastMetricHandler> handlers = new ConcurrentHashMap(IastMetric.values().length);
    private final Function<IastMetric, IastMetricHandler> builders;

    public IastTelemetryCollectorImpl(Function<IastMetric, IastMetricHandler> builders) {
        this.builders = builders;
    }

    @Override
    public void addMetric(IastMetric metric, long value, String tag) {
        this.getOrCreateHandler(metric).add(value, tag);
    }

    @Override
    public void merge(Collection<IastTelemetryCollector.MetricData> metrics) {
        for (IastTelemetryCollector.MetricData data : metrics) {
            this.getOrCreateHandler(data.getMetric()).merge(data);
        }
    }

    @Override
    public Collection<IastTelemetryCollector.MetricData> drainMetrics() {
        if (this.handlers.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<IastTelemetryCollector.MetricData> result = new LinkedList<IastTelemetryCollector.MetricData>();
        for (IastMetricHandler handler : this.handlers.values()) {
            Collection<IastTelemetryCollector.MetricData> values = handler.drain();
            if (values.isEmpty()) continue;
            result.addAll(values);
        }
        this.handlers.clear();
        return result;
    }

    private IastMetricHandler getOrCreateHandler(IastMetric metric) {
        IastMetricHandler handler = this.handlers.get((Object)metric);
        if (handler == null) {
            handler = this.builders.apply(metric);
            IastMetricHandler old = this.handlers.putIfAbsent(metric, handler);
            handler = old == null ? handler : old;
        }
        return handler;
    }
}

