/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import ddtrot.dd.trace.core.propagation.DatadogPropagationTagsFactory;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PropagationTagsFactory
implements PropagationTags.Factory {
    static final String PROPAGATION_ERROR_TAG_KEY = "_dd.propagation_error";
    private final DatadogPropagationTagsFactory ddFactory;

    PropagationTagsFactory(int xDatadogTagsLimit) {
        this.ddFactory = new DatadogPropagationTagsFactory(xDatadogTagsLimit);
    }

    @Override
    public final PropagationTags empty() {
        return new ValidPropagationTags(Collections.emptyList(), 0, false);
    }

    @Override
    public final PropagationTags fromHeaderValue(PropagationTags.HeaderType headerType, String value) {
        return this.ddFactory.fromHeaderValue(this, value);
    }

    PropagationTags createValid(List<String> tagPairs, int tagSize, boolean hasDecisionMaker) {
        return new ValidPropagationTags(tagPairs, tagSize, hasDecisionMaker);
    }

    PropagationTags createInvalid(String error) {
        return new InvalidPropagationTags(error);
    }

    private static final class InvalidPropagationTags
    extends PropagationTags {
        private final String error;

        private InvalidPropagationTags(String error) {
            this.error = error;
        }

        @Override
        public void updateTraceSamplingPriority(int samplingPriority, int samplingMechanism) {
        }

        @Override
        public String headerValue(PropagationTags.HeaderType headerType) {
            return null;
        }

        @Override
        public void fillTagMap(Map<String, String> tagMap) {
            tagMap.put(PropagationTagsFactory.PROPAGATION_ERROR_TAG_KEY, this.error);
        }

        @Override
        List<String> tagPairs() {
            return Collections.emptyList();
        }

        @Override
        int tagsSize() {
            return 0;
        }

        @Override
        boolean missingDecisionMaker() {
            return false;
        }

        @Override
        String decisionMakerTagValue() {
            return null;
        }
    }

    private final class ValidPropagationTags
    extends PropagationTags {
        private final List<String> propagatedTagPairs;
        private final int propagatedTagsSize;
        private final boolean isDecisionMakerTagMissing;
        private volatile String decisionMakerTagValue;

        private ValidPropagationTags(List<String> tagPairs, int tagsSize, boolean hasDecisionMaker) {
            assert (tagPairs.size() % 2 == 0);
            this.propagatedTagPairs = tagPairs;
            this.propagatedTagsSize = tagsSize;
            this.isDecisionMakerTagMissing = !hasDecisionMaker;
        }

        @Override
        public void updateTraceSamplingPriority(int samplingPriority, int samplingMechanism) {
            if (samplingPriority != -128 && this.isDecisionMakerTagMissing) {
                if (samplingPriority > 0) {
                    if (samplingMechanism >= 0) {
                        this.decisionMakerTagValue = "-" + samplingMechanism;
                    }
                } else {
                    this.decisionMakerTagValue = null;
                }
            }
        }

        @Override
        public String headerValue(PropagationTags.HeaderType headerType) {
            return PropagationTagsFactory.this.ddFactory.headerValue(this);
        }

        @Override
        public void fillTagMap(Map<String, String> tagMap) {
            PropagationTagsFactory.this.ddFactory.fillTagMap(this, tagMap);
        }

        @Override
        List<String> tagPairs() {
            return this.propagatedTagPairs;
        }

        @Override
        int tagsSize() {
            return this.propagatedTagsSize;
        }

        @Override
        boolean missingDecisionMaker() {
            return this.isDecisionMakerTagMissing;
        }

        @Override
        String decisionMakerTagValue() {
            return this.decisionMakerTagValue;
        }
    }
}

