/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.datadoghq.sketch.ddsketch.encoding;

import ddtrot.com.datadoghq.sketch.ddsketch.encoding.Flag;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.InvalidFlagException;

public enum BinEncodingMode {
    INDEX_DELTAS_AND_COUNTS(1),
    INDEX_DELTAS(2),
    CONTIGUOUS_COUNTS(3);

    private final byte subFlag;

    private BinEncodingMode(byte subFlag) {
        this.subFlag = subFlag;
    }

    public final Flag toFlag(Flag.Type storeFlagType) {
        return new Flag(storeFlagType, this.subFlag);
    }

    public static BinEncodingMode ofFlag(Flag flag) throws InvalidFlagException {
        int index = (flag.marker() >>> 2) - 1;
        if (index < 0 || index >= BinEncodingMode.values().length) {
            throw new InvalidFlagException("The flag does not encode any valid bin encoding mode.");
        }
        return BinEncodingMode.values()[index];
    }
}

