/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.telemetry;

import ddtrot.dd.trace.api.iast.telemetry.Verbosity;

public enum IastMetric {
    INSTRUMENTED_PROPAGATION("instrumented.propagation", true, Scope.GLOBAL, Verbosity.MANDATORY, "propagation_type"),
    INSTRUMENTED_SOURCE("instrumented.source", true, Scope.GLOBAL, Verbosity.MANDATORY, "source_type"),
    INSTRUMENTED_SINK("instrumented.sink", true, Scope.GLOBAL, Verbosity.MANDATORY, "vulnerability_type"),
    EXECUTED_PROPAGATION("executed.propagation", true, Scope.REQUEST, Verbosity.DEBUG, "propagation_type"),
    EXECUTED_SOURCE("executed.source", true, Scope.REQUEST, Verbosity.INFORMATION, "source_type"),
    EXECUTED_SINK("executed.sink", true, Scope.REQUEST, Verbosity.INFORMATION, "vulnerability_type"),
    EXECUTED_TAINTED("executed.tainted", true, Scope.REQUEST, Verbosity.DEBUG),
    REQUEST_TAINTED("request.tainted", true, Scope.REQUEST, Verbosity.INFORMATION),
    TAINTED_FLAT_MODE("tainted.flat.mode", false, Scope.REQUEST, Verbosity.INFORMATION);

    private final String name;
    private final boolean common;
    private final Scope scope;
    private final String tag;
    private final Verbosity verbosity;

    private IastMetric(String name, boolean common, Scope scope, Verbosity verbosity) {
        this(name, common, scope, verbosity, null);
    }

    private IastMetric(String name, boolean common, Scope scope, Verbosity verbosity, String tag) {
        this.name = name;
        this.common = common;
        this.scope = scope;
        this.verbosity = verbosity;
        this.tag = tag;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "COUNT";
    }

    public boolean isCommon() {
        return this.common;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean isEnabled(Verbosity verbosity) {
        return verbosity.isEnabled(this.verbosity);
    }

    public static enum Scope {
        GLOBAL,
        REQUEST;

    }

    public static abstract class Tags {
        public static final String VULNERABILITY_TYPE = "vulnerability_type";
        public static final String SOURCE_TYPE = "source_type";
        public static final String PROPAGATION_TYPE = "propagation_type";

        private Tags() {
        }
    }
}

