/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.ContextInterpreter;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.TagContextExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class B3HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(B3HttpCodec.class);
    private static final String B3_TRACE_ID = "b3.traceid";
    private static final String B3_SPAN_ID = "b3.spanid";
    static final String TRACE_ID_KEY = "X-B3-TraceId";
    static final String SPAN_ID_KEY = "X-B3-SpanId";
    private static final String SAMPLING_PRIORITY_KEY = "X-B3-Sampled";
    private static final String B3_KEY = "b3";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);

    private B3HttpCodec() {
    }

    public static HttpCodec.Injector newCombinedInjector(boolean paddingEnabled) {
        return new HttpCodec.CompoundInjector(Arrays.asList(B3HttpCodec.newSingleInjector(paddingEnabled), B3HttpCodec.newMultiInjector(paddingEnabled)));
    }

    public static HttpCodec.Injector newMultiInjector(boolean paddingEnalbed) {
        return new B3MultiInjector(paddingEnalbed);
    }

    public static HttpCodec.Injector newSingleInjector(boolean paddingEnabled) {
        return new B3SingleInjector(paddingEnabled);
    }

    private static String convertSamplingPriority(int samplingPriority) {
        return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
    }

    static HttpCodec.Extractor newExtractor(Map<String, String> tagMapping, Map<String, String> baggageMapping) {
        Config config = Config.get();
        ArrayList<HttpCodec.Extractor> extractors = new ArrayList<HttpCodec.Extractor>(2);
        extractors.add(B3HttpCodec.newSingleExtractor(tagMapping, baggageMapping, config));
        extractors.add(B3HttpCodec.newMultiExtractor(tagMapping, baggageMapping, config));
        return new HttpCodec.CompoundExtractor(extractors);
    }

    public static HttpCodec.Extractor newMultiExtractor(Map<String, String> tagMapping, Map<String, String> baggageMapping, final Config config) {
        return new TagContextExtractor(tagMapping, baggageMapping, new ContextInterpreter.Factory(){

            @Override
            protected ContextInterpreter construct(Map<String, String> mapping, Map<String, String> baggageMapping) {
                return new B3MultiContextInterpreter(mapping, baggageMapping, config);
            }
        });
    }

    public static HttpCodec.Extractor newSingleExtractor(Map<String, String> tagMapping, Map<String, String> baggageMapping, final Config config) {
        return new TagContextExtractor(tagMapping, baggageMapping, new ContextInterpreter.Factory(){

            @Override
            protected ContextInterpreter construct(Map<String, String> mapping, Map<String, String> baggageMapping) {
                return new B3SingleContextInterpreter(mapping, baggageMapping, config);
            }
        });
    }

    private static int convertSamplingPriority(String samplingPriority) {
        return "1".equals(samplingPriority) ? 1 : 0;
    }

    private static final class B3SingleContextInterpreter
    extends B3BaseContextInterpreter {
        public B3SingleContextInterpreter(Map<String, String> taggedHeaders, Map<String, String> baggageMapping, Config config) {
            super(taggedHeaders, baggageMapping, config);
        }

        @Override
        public boolean accept(String key, String value) {
            try {
                if (null == key || key.isEmpty() || null == value || value.isEmpty()) {
                    return true;
                }
                if (LOG_EXTRACT_HEADER_NAMES) {
                    log.debug("Header: {}", (Object)key);
                }
                if (B3HttpCodec.B3_KEY.equals(key)) {
                    return this.extractB3(HttpCodec.firstHeaderValue(value));
                }
                char first = Character.toLowerCase(key.charAt(0));
                switch (first) {
                    case 'x': {
                        if (!this.handledXForwarding(key, value)) break;
                        return true;
                    }
                    case 'f': {
                        if (!this.handledForwarding(key, value)) break;
                        return true;
                    }
                    case 'u': {
                        if (!this.handledUserAgent(key, value)) break;
                        return true;
                    }
                }
                if (this.handledIpHeaders(key, value)) {
                    return true;
                }
                this.handleTags(key, value);
            }
            catch (RuntimeException e) {
                this.invalidateContext();
                log.debug("Exception when extracting context", (Throwable)e);
                return false;
            }
            return true;
        }

        private boolean extractB3(String firstValue) {
            if (firstValue.length() == 1) {
                this.samplingPriority = B3HttpCodec.convertSamplingPriority(firstValue);
            } else {
                String b3SpanId;
                String b3TraceId;
                int firstIndex = firstValue.indexOf("-");
                int secondIndex = firstValue.indexOf("-", firstIndex + 1);
                if (firstIndex != -1 && !this.setTraceId(b3TraceId = firstValue.substring(0, firstIndex))) {
                    return false;
                }
                if (secondIndex == -1) {
                    b3SpanId = firstValue.substring(firstIndex + 1);
                    this.setSpanId(b3SpanId);
                } else {
                    b3SpanId = firstValue.substring(firstIndex + 1, secondIndex);
                    this.setSpanId(b3SpanId);
                    String b3SamplingId = firstValue.substring(secondIndex + 1);
                    this.samplingPriority = B3HttpCodec.convertSamplingPriority(b3SamplingId);
                }
            }
            return true;
        }
    }

    private static final class B3MultiContextInterpreter
    extends B3BaseContextInterpreter {
        private B3MultiContextInterpreter(Map<String, String> taggedHeaders, Map<String, String> baggageMapping, Config config) {
            super(taggedHeaders, baggageMapping, config);
        }

        @Override
        public boolean accept(String key, String value) {
            if (null == key || key.isEmpty() || null == value || value.isEmpty()) {
                return true;
            }
            if (LOG_EXTRACT_HEADER_NAMES) {
                log.debug("Header: {}", (Object)key);
            }
            try {
                char first = Character.toLowerCase(key.charAt(0));
                switch (first) {
                    case 'x': {
                        if (B3HttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                            this.setTraceId(HttpCodec.firstHeaderValue(value));
                            return true;
                        }
                        if (B3HttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                            this.setSpanId(HttpCodec.firstHeaderValue(value));
                            return true;
                        }
                        if (B3HttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                            this.samplingPriority = B3HttpCodec.convertSamplingPriority(HttpCodec.firstHeaderValue(value));
                            return true;
                        }
                        if (!this.handledXForwarding(key, value)) break;
                        return true;
                    }
                    case 'f': {
                        if (!this.handledForwarding(key, value)) break;
                        return true;
                    }
                    case 'u': {
                        if (!this.handledUserAgent(key, value)) break;
                        return true;
                    }
                }
                if (this.handledIpHeaders(key, value)) {
                    return true;
                }
                this.handleTags(key, value);
            }
            catch (RuntimeException e) {
                this.invalidateContext();
                log.debug("Exception when extracting context", (Throwable)e);
                return false;
            }
            return true;
        }
    }

    private static abstract class B3BaseContextInterpreter
    extends ContextInterpreter {
        public B3BaseContextInterpreter(Map<String, String> taggedHeaders, Map<String, String> baggageMapping, Config config) {
            super(taggedHeaders, baggageMapping, config);
        }

        protected void setSpanId(String sId) {
            this.spanId = DDSpanId.fromHex((String)sId);
            if (this.tags.isEmpty()) {
                this.tags = new TreeMap();
            }
            this.tags.put(B3HttpCodec.B3_SPAN_ID, sId);
        }

        protected boolean setTraceId(String tId) {
            int length = tId.length();
            if (length > 32) {
                log.debug("Header {} exceeded max length of 32: {}", (Object)B3HttpCodec.TRACE_ID_KEY, (Object)tId);
                this.traceId = DDTraceId.ZERO;
                return false;
            }
            this.traceId = DDTraceId.fromHexTruncatedWithOriginal((String)tId);
            if (this.tags.isEmpty()) {
                this.tags = new TreeMap();
            }
            this.tags.put(B3HttpCodec.B3_TRACE_ID, tId);
            return true;
        }
    }

    private static final class B3SingleInjector
    extends B3Injector {
        public B3SingleInjector(boolean paddingEnabled) {
            super(paddingEnabled);
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            String injectedTraceId = this.getTraceId(context);
            String injectedSpanId = this.getSpanId(context);
            StringBuilder injectedB3IdBuilder = new StringBuilder(100);
            injectedB3IdBuilder.append(injectedTraceId).append('-').append(injectedSpanId);
            if (context.lockSamplingPriority()) {
                String injectedSamplingPriority = B3HttpCodec.convertSamplingPriority(context.getSamplingPriority());
                injectedB3IdBuilder.append('-').append(injectedSamplingPriority);
            }
            String injectedB3Id = injectedB3IdBuilder.toString();
            setter.set(carrier, B3HttpCodec.B3_KEY, injectedB3Id);
            log.debug("{} - B3 parent context injected - {}", (Object)context.getTraceId(), (Object)injectedB3Id);
        }
    }

    private static final class B3MultiInjector
    extends B3Injector {
        public B3MultiInjector(boolean paddingEnabled) {
            super(paddingEnabled);
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            String injectedTraceId = this.getTraceId(context);
            String injectedSpanId = this.getSpanId(context);
            setter.set(carrier, B3HttpCodec.TRACE_ID_KEY, injectedTraceId);
            setter.set(carrier, B3HttpCodec.SPAN_ID_KEY, injectedSpanId);
            if (context.lockSamplingPriority()) {
                String injectedSamplingPriority = B3HttpCodec.convertSamplingPriority(context.getSamplingPriority());
                setter.set(carrier, B3HttpCodec.SAMPLING_PRIORITY_KEY, injectedSamplingPriority);
            }
            log.debug("{} - B3 parent context injected - {} {}", new Object[]{context.getTraceId(), injectedTraceId, injectedSpanId});
        }
    }

    private static abstract class B3Injector
    implements HttpCodec.Injector {
        private final boolean paddingEnabled;

        public B3Injector(boolean paddingEnabled) {
            this.paddingEnabled = paddingEnabled;
        }

        protected final String getTraceId(DDSpanContext context) {
            return this.paddingEnabled ? context.getTraceId().toHexStringPaddedOrOriginal(32) : context.getTraceId().toHexStringOrOriginal();
        }

        protected final String getSpanId(DDSpanContext context) {
            return this.paddingEnabled ? DDSpanId.toHexStringPadded((long)context.getSpanId()) : DDSpanId.toHexString((long)context.getSpanId());
        }
    }
}

