/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation.ptags;

import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.propagation.ptags.PTagsCodec;
import ddtrot.dd.trace.core.propagation.ptags.PTagsFactory;
import ddtrot.dd.trace.core.propagation.ptags.TagElement;
import ddtrot.dd.trace.core.propagation.ptags.TagKey;
import ddtrot.dd.trace.core.propagation.ptags.TagValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class W3CPTagsCodec
extends PTagsCodec {
    private static final Logger log = LoggerFactory.getLogger(W3CPTagsCodec.class);
    private static final int MAX_HEADER_SIZE = 256;
    private static final int EMPTY_SIZE = 3;
    private static final char MEMBER_SEPARATOR = ',';
    private static final char ELEMENT_SEPARATOR = ';';
    private static final char KEY_VALUE_SEPARATOR = ':';
    private static final int MIN_ALLOWED_CHAR = 32;
    private static final int MAX_ALLOWED_CHAR = 126;

    @Override
    PropagationTags fromHeaderValue(PTagsFactory tagsFactory, String value) {
        if (value == null || value.isEmpty()) {
            return tagsFactory.empty();
        }
        int len = value.length();
        int firstMemberStart = W3CPTagsCodec.findNextMember(value, 0);
        if (firstMemberStart == len) {
            return tagsFactory.empty();
        }
        int memberStart = firstMemberStart;
        int ddMemberStart = -1;
        int ddMemberValueStart = -1;
        int ddMemberValueEnd = -1;
        int memberIndex = 0;
        int ddMemberIndex = -1;
        while (memberStart < len) {
            int pos;
            if (memberIndex == 32) {
                return tagsFactory.empty();
            }
            if (ddMemberIndex == -1 && value.startsWith("dd=", memberStart)) {
                ddMemberStart = memberStart;
                ddMemberIndex = memberIndex;
            }
            if ((pos = W3CPTagsCodec.validateMemberKey(value, memberStart)) < 0) {
                return tagsFactory.empty();
            }
            if (ddMemberValueStart == -1 && ddMemberIndex != -1) {
                ddMemberValueStart = pos;
            }
            if ((pos = W3CPTagsCodec.validateMemberValue(value, pos)) < 0) {
                return tagsFactory.empty();
            }
            if (ddMemberValueEnd == -1 && ddMemberIndex != -1) {
                ddMemberValueEnd = pos;
            }
            if ((memberStart = W3CPTagsCodec.findNextMember(value, pos)) < 0) {
                return tagsFactory.empty();
            }
            ++memberIndex;
        }
        if (ddMemberIndex == -1) {
            return W3CPTagsCodec.empty(tagsFactory, value);
        }
        ArrayList<TagValue> tagPairs = null;
        int tagPos = ddMemberValueStart;
        int samplingPriority = -128;
        TagValue origin = null;
        TagValue decisionMakerTagValue = null;
        int maxUnknownSize = 0;
        while (tagPos < ddMemberValueEnd) {
            TagKey tagKey;
            int tagKeyEndsAt = W3CPTagsCodec.validateCharsUntilSeparatorOrEnd(value, tagPos, ddMemberValueEnd, ':', false, W3CPTagsCodec::isAllowedKeyChar);
            if (tagKeyEndsAt < 0 || tagKeyEndsAt == ddMemberValueEnd) {
                log.warn("Invalid datadog tags header value: '{}' at {}", (Object)value, (Object)tagPos);
                return W3CPTagsCodec.empty(tagsFactory, value, firstMemberStart, ddMemberStart, ddMemberValueEnd);
            }
            int tagValuePos = tagKeyEndsAt + 1;
            int tagValueEndsAt = W3CPTagsCodec.validateCharsUntilSeparatorOrEnd(value, tagValuePos, ddMemberValueEnd, ';', true, W3CPTagsCodec::isAllowedValueChar);
            if (tagValueEndsAt < 0) {
                log.warn("Invalid datadog tags header value: '{}' at {}", (Object)value, (Object)tagKeyEndsAt);
                return W3CPTagsCodec.empty(tagsFactory, value, firstMemberStart, ddMemberStart, ddMemberValueEnd);
            }
            int nextTagPos = tagValueEndsAt + 1;
            if (tagValueEndsAt == ddMemberValueEnd) {
                tagValueEndsAt = W3CPTagsCodec.stripTrailingOWC(value, tagValuePos, tagValueEndsAt);
            }
            if ((tagKey = TagKey.from(TagElement.Encoding.W3C, value, tagPos, tagKeyEndsAt)) != null) {
                TagValue tagValue = TagValue.from(TagElement.Encoding.W3C, value, tagValuePos, tagValueEndsAt);
                if (!tagKey.equals(UPSTREAM_SERVICES_DEPRECATED_TAG)) {
                    if (!W3CPTagsCodec.validateTagValue(tagKey, tagValue)) {
                        log.warn("Invalid datadog tags header value: '{}' invalid tag value at {}", (Object)value, (Object)tagValuePos);
                        return W3CPTagsCodec.empty(tagsFactory, value, firstMemberStart, ddMemberStart, ddMemberValueEnd);
                    }
                    if (tagKey.equals(DECISION_MAKER_TAG)) {
                        decisionMakerTagValue = tagValue;
                    } else {
                        if (tagPairs == null) {
                            tagPairs = new ArrayList<TagValue>(6);
                        }
                        tagPairs.add((TagValue)((Object)tagKey));
                        tagPairs.add(tagValue);
                    }
                }
            } else {
                int keyLength = tagKeyEndsAt - tagPos;
                char c = value.charAt(tagPos);
                if (keyLength == 1 && c == 's') {
                    samplingPriority = W3CPTagsCodec.validateSamplingPriority(value, tagValuePos, tagValueEndsAt);
                } else if (keyLength == 1 && c == 'o') {
                    origin = TagValue.from(TagElement.Encoding.W3C, value, tagValuePos, tagValueEndsAt);
                } else {
                    if (maxUnknownSize != 0) {
                        ++maxUnknownSize;
                    }
                    maxUnknownSize += tagValueEndsAt - tagPos;
                }
            }
            tagPos = nextTagPos;
        }
        return new W3CPTags(tagsFactory, tagPairs, decisionMakerTagValue, samplingPriority, origin, value, firstMemberStart, ddMemberStart, ddMemberValueEnd, maxUnknownSize);
    }

    @Override
    protected int estimateHeaderSize(PTagsFactory.PTags pTags) {
        int size = 4;
        size += pTags.getXDatadogTagsSize();
        if (pTags.getOrigin() != null) {
            size += pTags.getOrigin().length() + 3;
        }
        if (pTags.getSamplingPriority() != -128) {
            size += 5;
        }
        if (pTags instanceof W3CPTags) {
            W3CPTags w3CPTags = (W3CPTags)pTags;
            size += w3CPTags.maxUnknownSize;
            if (w3CPTags.ddMemberStart != -1) {
                size += w3CPTags.original.length() - (w3CPTags.ddMemberValueEnd - w3CPTags.ddMemberStart);
            }
        }
        return size;
    }

    @Override
    protected int appendPrefix(StringBuilder sb, PTagsFactory.PTags ptags) {
        CharSequence origin;
        sb.append("dd=");
        if (ptags.getSamplingPriority() != -128) {
            sb.append("s:");
            sb.append(ptags.getSamplingPriority());
        }
        if ((origin = ptags.getOrigin()) != null) {
            if (sb.length() > 3) {
                sb.append(';');
            }
            sb.append("o:");
            if (origin instanceof TagValue) {
                sb.append(((TagValue)origin).forType(TagElement.Encoding.W3C));
            } else {
                sb.append(origin);
            }
        }
        return sb.length();
    }

    @Override
    protected int appendTag(StringBuilder sb, TagElement key, TagElement value, int size) {
        return this.appendTag(sb, key, value, TagElement.Encoding.W3C, size);
    }

    @Override
    protected int appendSuffix(StringBuilder sb, PTagsFactory.PTags ptags, int size) {
        int newSize;
        if (size >= 256 || !(ptags instanceof W3CPTags)) {
            return size;
        }
        W3CPTags w3cPTags = (W3CPTags)ptags;
        if ((size = W3CPTagsCodec.cleanUpAndAppendUnknown(sb, w3cPTags, size)) == 3) {
            sb.setLength(0);
            size = 0;
        }
        if ((newSize = W3CPTagsCodec.cleanUpAndAppendSuffix(sb, w3cPTags, size)) != size) {
            size = Math.max(size, 4);
        }
        return size;
    }

    @Override
    protected boolean isTooLarge(StringBuilder sb, int size) {
        return size > 256;
    }

    @Override
    protected boolean isEmpty(StringBuilder sb, int size) {
        return size <= 3;
    }

    private int appendTag(StringBuilder sb, TagElement key, TagElement value, TagElement.Encoding encoding, int size) {
        if (size >= 256) {
            return size;
        }
        int validSize = size;
        if (size > 3) {
            sb.append(';');
            ++size;
        }
        CharSequence s = key.forType(encoding);
        sb.append(s);
        size += s.length();
        sb.append(':');
        ++size;
        s = value.forType(encoding);
        sb.append(s);
        if ((size += s.length()) > 256) {
            sb.setLength(validSize);
            size = validSize;
        }
        return size;
    }

    private static int validateCharsUntilSeparatorOrEnd(String s, int start, int end, char separator, boolean allowOWC, IntPredicate isValid) {
        if (start >= end) {
            return -1;
        }
        int pos = start;
        char c = s.charAt(pos);
        boolean definitelyOWC = false;
        do {
            if (allowOWC && W3CPTagsCodec.isOWC(c)) {
                if (c == '\t') {
                    definitelyOWC = true;
                }
            } else if (definitelyOWC || !isValid.test(c) || c == separator) {
                return -1;
            }
            if (++pos >= end) continue;
            c = s.charAt(pos);
            if (pos < end - 1 && c == separator) break;
        } while (pos < end);
        return pos;
    }

    private static boolean isAllowedKeyChar(int c) {
        return c > 32 && c <= 126 && c != 58;
    }

    private static boolean isAllowedValueChar(int c) {
        return c >= 32 && c <= 126;
    }

    private static int validateSamplingPriority(String original, int start, int end) {
        try {
            return W3CPTagsCodec.parseIntDecimal(original, start, end);
        }
        catch (Exception ignored) {
            return -128;
        }
    }

    private static int parseIntDecimal(String original, int start, int end) throws NumberFormatException {
        if (start < 0 || start > end || end > original.length()) {
            throw new IndexOutOfBoundsException();
        }
        boolean negative = false;
        int i = start;
        int limit = -2147483647;
        if (i < end) {
            char firstChar = original.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw new NumberFormatException(original);
                }
                if (++i == end) {
                    throw new NumberFormatException(original);
                }
            }
            int multmin = limit / 10;
            int result = 0;
            while (i < end) {
                int digit = original.charAt(i) - 48;
                if (digit < 0 || digit > 9 || result < multmin) {
                    throw new NumberFormatException(original);
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException(original);
                }
                ++i;
                result -= digit;
            }
            return negative ? result : -result;
        }
        throw new NumberFormatException("");
    }

    private static int validateMemberKey(String original, int start) {
        char c;
        int end = original.length();
        if (start < 0 || start >= end) {
            return -1;
        }
        boolean multi = false;
        int length = 1;
        int pos = start;
        while (pos < end) {
            if (length > 242) {
                if (multi) {
                    return -1;
                }
                if (length > 257) {
                    return -1;
                }
            }
            if (!W3CPTagsCodec.isLcAlpha(c = original.charAt(pos))) {
                if (W3CPTagsCodec.isDigit(c)) {
                    if (length == 1) {
                        multi = true;
                    }
                } else {
                    if (length == 1) {
                        return -1;
                    }
                    if (!W3CPTagsCodec.isValidExtra(c)) {
                        if (c == '=') {
                            if (multi) {
                                return -1;
                            }
                            ++pos;
                            break;
                        }
                        if (c == '@') {
                            if (length > 242) {
                                return -1;
                            }
                            multi = true;
                            ++pos;
                            break;
                        }
                        return -1;
                    }
                }
            }
            ++pos;
            ++length;
        }
        if (multi) {
            length = 1;
            while (pos < end) {
                if (length > 15) {
                    return -1;
                }
                c = original.charAt(pos);
                if (!W3CPTagsCodec.isLcAlpha(c)) {
                    if (length == 1) {
                        return -1;
                    }
                    if (!W3CPTagsCodec.isDigit(c) && !W3CPTagsCodec.isValidExtra(c) && c == '=') {
                        ++pos;
                        break;
                    }
                }
                ++pos;
                ++length;
            }
        }
        if (pos >= end) {
            return -1;
        }
        return pos;
    }

    private static int validateMemberValue(String original, int start) {
        int end = original.length();
        if (start < 0 || start >= end) {
            return -1;
        }
        int length = 1;
        int nonOWSLength = 0;
        int pos = start;
        boolean inWhiteSpace = false;
        boolean onlyWhiteSpace = true;
        boolean moreNonWSAllowed = true;
        while (pos < end) {
            if (!inWhiteSpace) {
                nonOWSLength = length - 1;
            }
            if (nonOWSLength > 256) {
                return -1;
            }
            char c = original.charAt(pos);
            if (c == ' ') {
                inWhiteSpace = true;
            } else if (c == '\t') {
                inWhiteSpace = true;
                moreNonWSAllowed = false;
            } else {
                if (c == ',') break;
                if (!moreNonWSAllowed) {
                    return -1;
                }
                inWhiteSpace = false;
                if (W3CPTagsCodec.isValidMemberValueChar(c)) {
                    onlyWhiteSpace = false;
                } else {
                    return -1;
                }
            }
            ++pos;
            ++length;
        }
        if (onlyWhiteSpace) {
            return -1;
        }
        if (!inWhiteSpace && length > 257) {
            return -1;
        }
        return pos;
    }

    private static int findNextMember(String original, int start) {
        char c;
        int pos;
        int len = original.length();
        if (start < 0) {
            return -1;
        }
        if (start >= len) {
            return len;
        }
        for (pos = start; pos < len && (W3CPTagsCodec.isOWC(c = original.charAt(pos)) || c == ','); ++pos) {
        }
        return pos;
    }

    private static boolean isLcAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isValidExtra(char c) {
        return c == '_' || c == '-' || c == '*' || c == '/';
    }

    private static boolean isValidMemberValueChar(char c) {
        return c >= ' ' && c <= '~' && c != ',' && c != '=';
    }

    private static boolean isOWC(char c) {
        return c == ' ' || c == '\t';
    }

    private static int stripTrailingOWC(String original, int start, int end) {
        char c = original.charAt(--end);
        while (W3CPTagsCodec.isOWC(c) && end > start) {
            c = original.charAt(--end);
        }
        return ++end;
    }

    private static int cleanUpAndAppendUnknown(StringBuilder sb, W3CPTags w3CPTags, int size) {
        if (w3CPTags.maxUnknownSize == 0 || w3CPTags.ddMemberStart == -1 || w3CPTags.ddMemberStart >= w3CPTags.ddMemberValueEnd) {
            return size;
        }
        String original = w3CPTags.original;
        int elementStart = w3CPTags.ddMemberStart + 3;
        int okSize = size;
        while (elementStart < w3CPTags.ddMemberValueEnd && size < 256) {
            okSize = size;
            int elementEnd = original.indexOf(59, elementStart);
            if (elementEnd < 0) {
                elementEnd = w3CPTags.ddMemberValueEnd;
            }
            if (!original.startsWith(TagElement.Encoding.W3C.getPrefix(), elementStart)) {
                char first = original.charAt(elementStart);
                char second = original.charAt(elementStart + 1);
                if (second != ':' || first != 'o' && first != 's') {
                    int end;
                    if (sb.length() > 3) {
                        sb.append(';');
                        ++size;
                    }
                    if ((end = elementEnd) == w3CPTags.ddMemberValueEnd) {
                        end = W3CPTagsCodec.stripTrailingOWC(original, elementStart, end);
                    }
                    sb.append(original, elementStart, end);
                    size += end - elementStart;
                }
            }
            elementStart = elementEnd + 1;
        }
        if (size > 256) {
            sb.setLength(okSize);
            size = okSize;
        }
        return size;
    }

    private static int cleanUpAndAppendSuffix(StringBuilder sb, W3CPTags w3CPTags, int size) {
        String original = w3CPTags.original;
        int len = original.length();
        int memberStart = W3CPTagsCodec.findNextMember(original, 0);
        while (memberStart < len) {
            int memberEnd = original.indexOf(44, memberStart);
            if (memberEnd < 0) {
                memberEnd = len;
            }
            if (memberStart != w3CPTags.ddMemberStart) {
                if (sb.length() > 0) {
                    sb.append(',');
                    ++size;
                }
                int end = W3CPTagsCodec.stripTrailingOWC(original, memberStart, memberEnd);
                sb.append(original, memberStart, end);
                size += end - memberStart;
            }
            memberStart = W3CPTagsCodec.findNextMember(original, memberEnd + 1);
        }
        return size;
    }

    private static W3CPTags empty(PTagsFactory factory, String original) {
        return W3CPTagsCodec.empty(factory, original, 0, -1, -1);
    }

    private static W3CPTags empty(PTagsFactory factory, String original, int firstMemberStart, int ddMemberStart, int ddMemberValueEnd) {
        return new W3CPTags(factory, null, null, -128, null, original, firstMemberStart, ddMemberStart, ddMemberValueEnd, 0);
    }

    private static class W3CPTags
    extends PTagsFactory.PTags {
        private final String original;
        private final int firstMemberStart;
        private final int ddMemberStart;
        private final int ddMemberValueEnd;
        private final int maxUnknownSize;

        public W3CPTags(PTagsFactory factory, List<TagElement> tagPairs, TagValue decisionMakerTagValue, int samplingPriority, CharSequence origin, String original, int firstMemberStart, int ddMemberStart, int ddMemberValueEnd, int maxUnknownSize) {
            super(factory, tagPairs, decisionMakerTagValue, samplingPriority, origin);
            this.original = original;
            this.firstMemberStart = firstMemberStart;
            this.ddMemberStart = ddMemberStart;
            this.ddMemberValueEnd = ddMemberValueEnd;
            this.maxUnknownSize = maxUnknownSize;
        }
    }
}

