/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.dd.communication.ddagent.DroppingPolicy;
import ddtrot.dd.trace.common.sampling.SingleSpanSampler;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.org.jctools.queues.MessagePassingQueue;
import ddtrot.org.jctools.queues.MpscBlockingConsumerArrayQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SpanSamplingWorker
extends AutoCloseable {
    public static SpanSamplingWorker build(int capacity, Queue<Object> primaryQueue, Queue<Object> secondaryQueue, SingleSpanSampler singleSpanSampler, HealthMetrics healthMetrics, DroppingPolicy droppingPolicy) {
        if (singleSpanSampler == null) {
            return new NoopSpanSamplingWorker();
        }
        return new DefaultSpanSamplingWorker(capacity, primaryQueue, secondaryQueue, singleSpanSampler, healthMetrics, droppingPolicy);
    }

    public void start();

    public Queue<Object> getSpanSamplingQueue();

    @Override
    public void close();

    public static class NoopSpanSamplingWorker
    implements SpanSamplingWorker {
        @Override
        public void start() {
        }

        @Override
        public Queue<Object> getSpanSamplingQueue() {
            return null;
        }

        @Override
        public void close() {
        }
    }

    public static class DefaultSpanSamplingWorker
    implements SpanSamplingWorker {
        private static final Logger log = LoggerFactory.getLogger(SpanSamplingWorker.class);
        private final Thread spanSamplingThread;
        private final SamplingHandler samplingHandler = new SamplingHandler();
        private final MpscBlockingConsumerArrayQueue<Object> spanSamplingQueue;
        private final Queue<Object> primaryQueue;
        private final Queue<Object> secondaryQueue;
        private final SingleSpanSampler singleSpanSampler;
        private final HealthMetrics healthMetrics;
        private final DroppingPolicy droppingPolicy;

        protected DefaultSpanSamplingWorker(int capacity, Queue<Object> primaryQueue, Queue<Object> secondaryQueue, SingleSpanSampler singleSpanSampler, HealthMetrics healthMetrics, DroppingPolicy droppingPolicy) {
            this.spanSamplingThread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.SPAN_SAMPLING_PROCESSOR, this.samplingHandler);
            this.spanSamplingQueue = new MpscBlockingConsumerArrayQueue(capacity);
            this.primaryQueue = primaryQueue;
            this.secondaryQueue = secondaryQueue;
            this.singleSpanSampler = singleSpanSampler;
            this.healthMetrics = healthMetrics;
            this.droppingPolicy = droppingPolicy;
        }

        @Override
        public void start() {
            this.spanSamplingThread.start();
        }

        @Override
        public void close() {
            this.spanSamplingThread.interrupt();
            try {
                this.spanSamplingThread.join(800L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public Queue<Object> getSpanSamplingQueue() {
            return this.spanSamplingQueue;
        }

        protected void afterOnEvent() {
        }

        private final class SamplingHandler
        implements Runnable {
            private SamplingHandler() {
            }

            @Override
            public void run() {
                try {
                    this.runDutyCycle();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }

            private void runDutyCycle() throws InterruptedException {
                Thread thread = Thread.currentThread();
                while (!thread.isInterrupted()) {
                    this.consumeFromInputQueue();
                }
            }

            private void consumeFromInputQueue() throws InterruptedException {
                Object event = DefaultSpanSamplingWorker.this.spanSamplingQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (null != event) {
                    this.onEvent(event);
                    this.consumeBatch(DefaultSpanSamplingWorker.this.spanSamplingQueue);
                }
            }

            public void onEvent(Object event) {
                if (event instanceof List) {
                    List trace = (List)event;
                    if (trace.isEmpty()) {
                        log.warn("SingleSamplingWorker has received an empty trace.");
                        return;
                    }
                    ArrayList<DDSpan> sampledSpans = new ArrayList<DDSpan>(trace.size());
                    ArrayList<DDSpan> unsampledSpans = new ArrayList<DDSpan>(trace.size());
                    for (DDSpan span : trace) {
                        if (DefaultSpanSamplingWorker.this.singleSpanSampler.setSamplingPriority(span)) {
                            sampledSpans.add(span);
                            continue;
                        }
                        unsampledSpans.add(span);
                    }
                    int samplingPriority = ((DDSpan)trace.get(0)).samplingPriority();
                    if (sampledSpans.size() > 0 && !DefaultSpanSamplingWorker.this.primaryQueue.offer(sampledSpans)) {
                        DefaultSpanSamplingWorker.this.healthMetrics.onFailedPublish(samplingPriority);
                        log.debug("Sampled spans written to overfilled buffer after single span sampling. Counted but dropping trace: {}", (Object)trace);
                    } else if (unsampledSpans.size() > 0 && (DefaultSpanSamplingWorker.this.droppingPolicy.active() || !DefaultSpanSamplingWorker.this.secondaryQueue.offer(unsampledSpans))) {
                        if (sampledSpans.isEmpty()) {
                            DefaultSpanSamplingWorker.this.healthMetrics.onFailedPublish(samplingPriority);
                            log.debug("Trace is empty. None of the spans have been sampled by single span sampling. Counted but dropping trace: {}", (Object)trace);
                        } else {
                            DefaultSpanSamplingWorker.this.healthMetrics.onPartialPublish(unsampledSpans.size());
                            log.debug("Unsampled spans dropped after single span sampling because Dropping Policy is active (droppingPolicy.active()={}) or the queue is full. Counted partial trace: {}", (Object)DefaultSpanSamplingWorker.this.droppingPolicy.active(), sampledSpans);
                        }
                    } else {
                        log.debug("Entire trace has been published: {}", (Object)trace);
                        DefaultSpanSamplingWorker.this.healthMetrics.onPublish(trace, samplingPriority);
                    }
                    DefaultSpanSamplingWorker.this.afterOnEvent();
                }
            }

            private void consumeBatch(MessagePassingQueue<Object> queue) {
                queue.drain(this::onEvent, queue.size());
            }
        }
    }
}

