/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation.ptags;

import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.propagation.ptags.PTagsFactory;
import ddtrot.dd.trace.core.propagation.ptags.TagElement;
import ddtrot.dd.trace.core.propagation.ptags.TagKey;
import ddtrot.dd.trace.core.propagation.ptags.TagValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class PTagsCodec {
    private static final String PROPAGATION_ERROR_INJECT_MAX_SIZE = "inject_max_size";
    private static final String PROPAGATION_ERROR_DISABLED = "disabled";
    protected static final TagKey DECISION_MAKER_TAG = TagKey.from("dm");
    protected static final TagKey UPSTREAM_SERVICES_DEPRECATED_TAG = TagKey.from("upstream_services");

    PTagsCodec() {
    }

    static String headerValue(PTagsCodec codec, PTagsFactory.PTags ptags) {
        int estimate = codec.estimateHeaderSize(ptags);
        if (estimate == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(estimate);
        int size = codec.appendPrefix(sb, ptags);
        if (!ptags.isPropagationTagsDisabled()) {
            if (ptags.getDecisionMakerTagValue() != null) {
                size = codec.appendTag(sb, DECISION_MAKER_TAG, ptags.getDecisionMakerTagValue(), size);
            }
            Iterator<TagElement> it = ptags.getTagPairs().iterator();
            while (it.hasNext() && !codec.isTooLarge(sb, size)) {
                TagElement tagKey = it.next();
                TagElement tagValue = it.next();
                size = codec.appendTag(sb, tagKey, tagValue, size);
            }
        }
        if (codec.isTooLarge(sb, size = codec.appendSuffix(sb, ptags, size))) {
            return null;
        }
        return codec.isEmpty(sb, size) ? null : sb.toString();
    }

    static void fillTagMap(PTagsFactory.PTags propagationTags, Map<String, String> tagMap) {
        int newSize = propagationTags.getXDatadogTagsSize();
        if (newSize > propagationTags.getxDatadogTagsLimit()) {
            if (propagationTags.isPropagationTagsDisabled()) {
                tagMap.put("_dd.propagation_error", PROPAGATION_ERROR_DISABLED);
            } else {
                tagMap.put("_dd.propagation_error", PROPAGATION_ERROR_INJECT_MAX_SIZE);
            }
            return;
        }
        Iterator<TagElement> it = propagationTags.getTagPairs().iterator();
        while (it.hasNext()) {
            TagElement tagKey = it.next();
            TagElement tagValue = it.next();
            tagMap.put(tagKey.forType(TagElement.Encoding.DATADOG).toString(), tagValue.forType(TagElement.Encoding.DATADOG).toString());
        }
        if (propagationTags.getDecisionMakerTagValue() != null) {
            tagMap.put(DECISION_MAKER_TAG.forType(TagElement.Encoding.DATADOG).toString(), propagationTags.getDecisionMakerTagValue().forType(TagElement.Encoding.DATADOG).toString());
        }
        if (propagationTags.getError() != null) {
            tagMap.put("_dd.propagation_error", propagationTags.getError());
        }
    }

    static int calcXDatadogTagsSize(List<TagElement> tagPairs) {
        int size = 0;
        int pl = TagElement.Encoding.DATADOG.getPrefixLength();
        boolean key = true;
        for (CharSequence charSequence : tagPairs) {
            if (key) {
                size += pl;
            }
            key = !key;
            size += charSequence.length();
            ++size;
        }
        return size == 0 ? 0 : size - 1;
    }

    static int calcXDatadogTagsSize(int size, TagKey tagKey, TagValue tagValue) {
        if (tagValue != null) {
            if (size > 0) {
                ++size;
            }
            size += tagKey.length();
            ++size;
            size += tagValue.length();
            size += TagElement.Encoding.DATADOG.getPrefixLength();
        }
        return size;
    }

    abstract PropagationTags fromHeaderValue(PTagsFactory var1, String var2);

    protected abstract int estimateHeaderSize(PTagsFactory.PTags var1);

    protected abstract int appendPrefix(StringBuilder var1, PTagsFactory.PTags var2);

    protected abstract int appendTag(StringBuilder var1, TagElement var2, TagElement var3, int var4);

    protected abstract int appendSuffix(StringBuilder var1, PTagsFactory.PTags var2, int var3);

    protected abstract boolean isTooLarge(StringBuilder var1, int var2);

    protected abstract boolean isEmpty(StringBuilder var1, int var2);

    protected static boolean validateTagValue(TagKey tagKey, TagValue tagValue) {
        return !tagKey.equals(DECISION_MAKER_TAG) || PTagsCodec.validateDecisionMakerTag(tagValue);
    }

    private static boolean validateDecisionMakerTag(TagValue value) {
        int i;
        int sepPos = value.indexOf('-');
        if (sepPos < 0) {
            return false;
        }
        if (sepPos != 0 && sepPos != 10) {
            return false;
        }
        int samplingMechanismPos = sepPos + 1;
        int len = value.length();
        if (samplingMechanismPos == len) {
            return false;
        }
        for (i = 0; i < sepPos; ++i) {
            if (PTagsCodec.isHexDigit(value.charAt(i))) continue;
            return false;
        }
        for (i = samplingMechanismPos; i < len; ++i) {
            if (PTagsCodec.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected static boolean isHexDigit(char c) {
        return c >= 'a' && c <= 'f' || PTagsCodec.isDigit(c);
    }
}

