/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilerContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.core.scopemanager.ContinuableScope;
import java.util.ArrayDeque;

final class ScopeStack {
    private final ProfilingContextIntegration profilingContextIntegration;
    private final ArrayDeque<ContinuableScope> stack = new ArrayDeque();
    ContinuableScope top;
    volatile ContinuableScope overdueRootScope;

    ScopeStack(ProfilingContextIntegration profilingContextIntegration) {
        this.profilingContextIntegration = profilingContextIntegration;
    }

    ContinuableScope active() {
        return this.top != this.overdueRootScope ? this.top : null;
    }

    void cleanup() {
        ContinuableScope curScope = this.top;
        boolean changedTop = false;
        while (curScope != null && !curScope.alive()) {
            curScope.onProperClose();
            changedTop = true;
            curScope = this.stack.poll();
        }
        if (curScope != null && curScope == this.overdueRootScope) {
            curScope.onProperClose();
            this.overdueRootScope = null;
            this.top = null;
        } else if (changedTop) {
            this.top = curScope;
            if (curScope != null) {
                curScope.afterActivated();
            }
        }
        if (this.top == null) {
            this.onBecomeEmpty();
        } else {
            this.onTopChanged(this.top);
        }
    }

    void push(ContinuableScope scope) {
        this.onTopChanged(scope);
        if (this.top != null) {
            this.stack.push(this.top);
        } else {
            this.onBecomeNonEmpty();
        }
        this.top = scope;
        scope.afterActivated();
    }

    boolean checkTop(ContinuableScope expectedScope) {
        return expectedScope.equals(this.top);
    }

    final boolean checkOverdueScopes(ContinuableScope expectedScope) {
        if (this.top == null || this.top.source() != ScopeSource.ITERATION.id()) {
            return false;
        }
        this.top.clearReferences();
        this.top.span.finishWithEndToEnd();
        for (ContinuableScope scope : this.stack) {
            if (scope.source() != ScopeSource.ITERATION.id()) {
                return expectedScope.equals(scope);
            }
            scope.clearReferences();
            scope.span.finishWithEndToEnd();
        }
        return false;
    }

    int depth() {
        return this.top != null ? 1 + this.stack.size() : 0;
    }

    void clear() {
        this.stack.clear();
        this.top = null;
    }

    private void onTopChanged(ContinuableScope top) {
        AgentSpan.Context context = top.span.context();
        if (context instanceof ProfilerContext) {
            this.profilingContextIntegration.setContext((ProfilerContext)((Object)context));
        }
    }

    private void onBecomeNonEmpty() {
        this.profilingContextIntegration.onAttach();
    }

    private void onBecomeEmpty() {
        this.profilingContextIntegration.clearContext();
        this.profilingContextIntegration.onDetach();
    }
}

