/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import ddtrot.dd.trace.api.scopemanager.ExtendedScopeListener;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AttachableWrapper;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.core.scopemanager.AbstractContinuation;
import ddtrot.dd.trace.core.scopemanager.ConcurrentContinuation;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import ddtrot.dd.trace.core.scopemanager.ScopeStack;
import ddtrot.dd.trace.core.scopemanager.SingleContinuation;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;

class ContinuableScope
implements AgentScope,
AttachableWrapper {
    private final ContinuableScopeManager scopeManager;
    final AgentSpan span;
    private boolean isAsyncPropagating;
    private final byte flags;
    private short referenceCount = 1;
    private volatile Object wrapper;
    private static final AtomicReferenceFieldUpdater<ContinuableScope, Object> WRAPPER_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ContinuableScope.class, Object.class, "wrapper");

    ContinuableScope(ContinuableScopeManager scopeManager, AgentSpan span, byte source, boolean isAsyncPropagating) {
        this.scopeManager = scopeManager;
        this.span = span;
        this.flags = source;
        this.isAsyncPropagating = isAsyncPropagating;
    }

    @Override
    public final void close() {
        boolean alive;
        ScopeStack scopeStack = this.scopeManager.scopeStack();
        if (!scopeStack.checkTop(this) && !scopeStack.checkOverdueScopes(this)) {
            if (ContinuableScopeManager.log.isDebugEnabled()) {
                ContinuableScopeManager.log.debug("Tried to close {} scope when not on top.  Current top: {}", (Object)this, (Object)scopeStack.top);
            }
            byte source = this.source();
            this.scopeManager.healthMetrics.onScopeCloseError(source);
            if (source == ScopeSource.MANUAL.id() && this.scopeManager.strictMode) {
                throw new RuntimeException("Tried to close scope when not on top");
            }
        }
        if (!(alive = this.decrementReferences())) {
            this.cleanup(scopeStack);
        }
    }

    void cleanup(ScopeStack scopeStack) {
        scopeStack.cleanup();
    }

    final void onProperClose() {
        for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
            try {
                scopeListener.afterScopeClosed();
            }
            catch (Exception e) {
                ContinuableScopeManager.log.debug("ScopeListener threw exception in close()", (Throwable)e);
            }
        }
        for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
            try {
                extendedScopeListener.afterScopeClosed();
            }
            catch (Exception e) {
                ContinuableScopeManager.log.debug("ScopeListener threw exception in close()", (Throwable)e);
            }
        }
    }

    final void incrementReferences() {
        this.referenceCount = (short)(this.referenceCount + 1);
    }

    final boolean decrementReferences() {
        this.referenceCount = (short)(this.referenceCount - 1);
        return this.referenceCount > 0;
    }

    final void clearReferences() {
        this.referenceCount = 0;
    }

    final boolean alive() {
        return this.referenceCount > 0;
    }

    public final boolean isAsyncPropagating() {
        return this.isAsyncPropagating;
    }

    @Override
    public final AgentSpan span() {
        return this.span;
    }

    @Override
    public final void setAsyncPropagation(boolean value) {
        this.isAsyncPropagating = value;
    }

    @Override
    public final AbstractContinuation capture() {
        return this.isAsyncPropagating ? new SingleContinuation(this.scopeManager, this.span, this.source()).register() : null;
    }

    @Override
    public final AbstractContinuation captureConcurrent() {
        return this.isAsyncPropagating ? new ConcurrentContinuation(this.scopeManager, this.span, this.source()).register() : null;
    }

    public final String toString() {
        return super.toString() + "->" + this.span;
    }

    public final void afterActivated() {
        for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
            try {
                scopeListener.afterScopeActivated();
            }
            catch (Throwable e) {
                ContinuableScopeManager.log.debug("ScopeListener threw exception in afterActivated()", e);
            }
        }
        for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
            try {
                extendedScopeListener.afterScopeActivated(this.span.getTraceId(), this.span.getLocalRootSpan().getSpanId(), this.span.context().getSpanId());
            }
            catch (Throwable e) {
                ContinuableScopeManager.log.debug("ExtendedScopeListener threw exception in afterActivated()", e);
            }
        }
    }

    @Override
    public byte source() {
        return (byte)(this.flags & 0x7F);
    }

    @Override
    public void attachWrapper(@Nonnull Object wrapper) {
        WRAPPER_FIELD_UPDATER.set(this, wrapper);
    }

    @Override
    public Object getWrapper() {
        return WRAPPER_FIELD_UPDATER.get(this);
    }
}

