/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CIInfo {
    public static final CIInfo NOOP = new CIInfo();
    private final String ciProviderName;
    private final String ciPipelineId;
    private final String ciPipelineName;
    private final String ciStageName;
    private final String ciJobName;
    private final String ciPipelineNumber;
    private final String ciPipelineUrl;
    private final String ciJobUrl;
    private final String ciWorkspace;
    private final Map<String, String> ciEnvVars;

    public static Builder builder() {
        return new Builder();
    }

    public CIInfo() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    public CIInfo(String ciProviderName, String ciPipelineId, String ciPipelineName, String ciStageName, String ciJobName, String ciPipelineNumber, String ciPipelineUrl, String ciJobUrl, String ciWorkspace, Map<String, String> ciEnvVars) {
        this.ciProviderName = ciProviderName;
        this.ciPipelineId = ciPipelineId;
        this.ciPipelineName = ciPipelineName;
        this.ciStageName = ciStageName;
        this.ciJobName = ciJobName;
        this.ciPipelineNumber = ciPipelineNumber;
        this.ciPipelineUrl = ciPipelineUrl;
        this.ciJobUrl = ciJobUrl;
        this.ciWorkspace = ciWorkspace;
        this.ciEnvVars = ciEnvVars;
    }

    public String getCiProviderName() {
        return this.ciProviderName;
    }

    public String getCiPipelineId() {
        return this.ciPipelineId;
    }

    public String getCiPipelineName() {
        return this.ciPipelineName;
    }

    public String getCiStageName() {
        return this.ciStageName;
    }

    public String getCiJobName() {
        return this.ciJobName;
    }

    public String getCiPipelineNumber() {
        return this.ciPipelineNumber;
    }

    public String getCiPipelineUrl() {
        return this.ciPipelineUrl;
    }

    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    public String getCiWorkspace() {
        return this.ciWorkspace;
    }

    public Map<String, String> getCiEnvVars() {
        return this.ciEnvVars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIInfo ciInfo = (CIInfo)o;
        return Objects.equals(this.ciProviderName, ciInfo.ciProviderName) && Objects.equals(this.ciPipelineId, ciInfo.ciPipelineId) && Objects.equals(this.ciPipelineName, ciInfo.ciPipelineName) && Objects.equals(this.ciStageName, ciInfo.ciStageName) && Objects.equals(this.ciJobName, ciInfo.ciJobName) && Objects.equals(this.ciPipelineNumber, ciInfo.ciPipelineNumber) && Objects.equals(this.ciPipelineUrl, ciInfo.ciPipelineUrl) && Objects.equals(this.ciJobUrl, ciInfo.ciJobUrl) && Objects.equals(this.ciWorkspace, ciInfo.ciWorkspace) && Objects.equals(this.ciEnvVars, ciInfo.ciEnvVars);
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + (this.ciProviderName == null ? 0 : this.ciProviderName.hashCode());
        hash = 31 * hash + (this.ciPipelineId == null ? 0 : this.ciPipelineId.hashCode());
        hash = 31 * hash + (this.ciPipelineName == null ? 0 : this.ciPipelineName.hashCode());
        hash = 31 * hash + (this.ciStageName == null ? 0 : this.ciStageName.hashCode());
        hash = 31 * hash + (this.ciJobName == null ? 0 : this.ciJobName.hashCode());
        hash = 31 * hash + (this.ciPipelineNumber == null ? 0 : this.ciPipelineNumber.hashCode());
        hash = 31 * hash + (this.ciPipelineUrl == null ? 0 : this.ciPipelineUrl.hashCode());
        hash = 31 * hash + (this.ciJobUrl == null ? 0 : this.ciJobUrl.hashCode());
        hash = 31 * hash + (this.ciWorkspace == null ? 0 : this.ciWorkspace.hashCode());
        hash = 31 * hash + (this.ciEnvVars == null ? 0 : this.ciEnvVars.hashCode());
        return hash;
    }

    public String toString() {
        return "CIInfo{ciProviderName='" + this.ciProviderName + '\'' + ", ciPipelineId='" + this.ciPipelineId + '\'' + ", ciPipelineName='" + this.ciPipelineName + '\'' + ", ciStageName='" + this.ciStageName + '\'' + ", ciJobName='" + this.ciJobName + '\'' + ", ciPipelineNumber='" + this.ciPipelineNumber + '\'' + ", ciPipelineUrl='" + this.ciPipelineUrl + '\'' + ", ciJobUrl='" + this.ciJobUrl + '\'' + ", ciWorkspace='" + this.ciWorkspace + '\'' + ", ciEnvVars='" + this.ciEnvVars + '\'' + '}';
    }

    public static final class Builder {
        private String ciProviderName;
        private String ciPipelineId;
        private String ciPipelineName;
        private String ciStageName;
        private String ciJobName;
        private String ciPipelineNumber;
        private String ciPipelineUrl;
        private String ciJobUrl;
        private String ciWorkspace;
        private Map<String, String> ciEnvVars;

        public Builder ciProviderName(String ciProviderName) {
            this.ciProviderName = ciProviderName;
            return this;
        }

        public Builder ciPipelineId(String ciPipelineId) {
            this.ciPipelineId = ciPipelineId;
            return this;
        }

        public Builder ciPipelineName(String ciPipelineName) {
            this.ciPipelineName = ciPipelineName;
            return this;
        }

        public Builder ciStageName(String ciStageName) {
            this.ciStageName = ciStageName;
            return this;
        }

        public Builder ciJobName(String ciJobName) {
            this.ciJobName = ciJobName;
            return this;
        }

        public Builder ciPipelineNumber(String ciPipelineNumber) {
            this.ciPipelineNumber = ciPipelineNumber;
            return this;
        }

        public Builder ciPipelineUrl(String ciPipelineUrl) {
            this.ciPipelineUrl = ciPipelineUrl;
            return this;
        }

        public Builder ciJobUrl(String ciJobUrl) {
            this.ciJobUrl = ciJobUrl;
            return this;
        }

        public Builder ciWorkspace(String ciWorkspace) {
            this.ciWorkspace = ciWorkspace;
            return this;
        }

        public Builder ciEnvVars(String ... ciEnvVarKeysArray) {
            if (ciEnvVarKeysArray == null || ciEnvVarKeysArray.length == 0) {
                return this;
            }
            this.ciEnvVars = new HashMap<String, String>();
            for (String ciEnvVarKey : ciEnvVarKeysArray) {
                String envVarVal = System.getenv(ciEnvVarKey);
                if (envVarVal == null || envVarVal.isEmpty()) continue;
                this.ciEnvVars.put(ciEnvVarKey, envVarVal);
            }
            return this;
        }

        public CIInfo build() {
            return new CIInfo(this.ciProviderName, this.ciPipelineId, this.ciPipelineName, this.ciStageName, this.ciJobName, this.ciPipelineNumber, this.ciPipelineUrl, this.ciJobUrl, this.ciWorkspace, this.ciEnvVars);
        }
    }
}

