/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.events.impl;

import ddtrot.dd.trace.api.civisibility.decorator.TestDecorator;
import ddtrot.dd.trace.api.civisibility.events.BuildEventsHandler;
import ddtrot.dd.trace.api.civisibility.events.impl.SpanTestContext;
import ddtrot.dd.trace.api.civisibility.events.impl.TestContext;
import ddtrot.dd.trace.api.civisibility.events.impl.TestModuleDescriptor;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BuildEventsHandlerImpl<T>
implements BuildEventsHandler<T> {
    private final ConcurrentMap<T, SessionContext> testSessionContexts = new ConcurrentHashMap<T, SessionContext>();
    private final ConcurrentMap<TestModuleDescriptor<T>, TestContext> testModuleContexts = new ConcurrentHashMap<TestModuleDescriptor<T>, TestContext>();

    @Override
    public void onTestSessionStart(T sessionKey, TestDecorator sessionDecorator, String projectName, String startCommand, String buildSystemName, String buildSystemVersion) {
        AgentSpan span = AgentTracer.startSpan(sessionDecorator.component() + ".test_session");
        SpanTestContext context = new SpanTestContext(span);
        this.testSessionContexts.put(sessionKey, new SessionContext(context, sessionDecorator));
        sessionDecorator.afterTestSessionStart(span, projectName, startCommand, buildSystemName, buildSystemVersion);
    }

    @Override
    public void onTestFrameworkDetected(T sessionKey, String frameworkName, String frameworkVersion) {
        AgentSpan span = this.getTestSessionSpan(sessionKey);
        span.setTag("test.framework", frameworkName);
        span.setTag("test.framework_version", frameworkVersion);
    }

    @Override
    public void onTestSessionFail(T sessionKey, Throwable throwable) {
        AgentSpan span = this.getTestSessionSpan(sessionKey);
        span.setError(true);
        span.addThrowable(throwable);
        span.setTag("test.status", "fail");
    }

    private AgentSpan getTestSessionSpan(T sessionKey) {
        SessionContext sessionContext = (SessionContext)this.testSessionContexts.get(sessionKey);
        AgentSpan span = sessionContext.context.getSpan();
        if (span == null) {
            throw new IllegalStateException("Could not find session span for key: " + sessionKey);
        }
        return span;
    }

    @Override
    public void onTestSessionFinish(T sessionKey) {
        SessionContext sessionContext = (SessionContext)this.testSessionContexts.remove(sessionKey);
        AgentSpan span = sessionContext.context.getSpan();
        if (span == null) {
            throw new IllegalStateException("Could not find session span for key: " + sessionKey);
        }
        span.setTag("test.status", sessionContext.context.getStatus());
        span.setTag("test_session_id", sessionContext.context.getId());
        sessionContext.decorator.beforeFinish(span);
        span.finish();
    }

    @Override
    public BuildEventsHandler.ModuleAndSessionId onTestModuleStart(T sessionKey, String moduleName, String startCommand, Map<String, Object> additionalTags) {
        SessionContext sessionContext = (SessionContext)this.testSessionContexts.get(sessionKey);
        AgentSpan sessionSpan = sessionContext.context.getSpan();
        if (sessionSpan == null) {
            throw new IllegalStateException("Could not find session span for key: " + sessionKey);
        }
        AgentSpan span = AgentTracer.startSpan((CharSequence)(sessionContext.decorator.component() + ".test_module"), sessionSpan.context());
        span.setTag("test.status", "pass");
        if (additionalTags != null) {
            for (Map.Entry<String, Object> e : additionalTags.entrySet()) {
                String tag = e.getKey();
                Object value = e.getValue();
                span.setTag(tag, value);
            }
        }
        TestModuleDescriptor<T> testModuleDescriptor = new TestModuleDescriptor<T>(sessionKey, moduleName);
        this.testModuleContexts.put(testModuleDescriptor, new SpanTestContext(span));
        sessionContext.decorator.afterTestModuleStart(span, moduleName, null, startCommand);
        return new BuildEventsHandler.ModuleAndSessionId(span.getSpanId(), sessionSpan.getSpanId());
    }

    @Override
    public void onModuleTestFrameworkDetected(T sessionKey, String moduleName, String frameworkName, String frameworkVersion) {
        AgentSpan span = this.getTestModuleSpan(sessionKey, moduleName);
        span.setTag("test.framework", frameworkName);
        span.setTag("test.framework_version", frameworkVersion);
    }

    @Override
    public void onTestModuleSkip(T sessionKey, String moduleName, String reason) {
        AgentSpan span = this.getTestModuleSpan(sessionKey, moduleName);
        span.setTag("test.status", "skip");
        span.setTag("test.skip_reason", reason);
    }

    @Override
    public void onTestModuleFail(T sessionKey, String moduleName, Throwable throwable) {
        AgentSpan span = this.getTestModuleSpan(sessionKey, moduleName);
        span.setError(true);
        span.addThrowable(throwable);
        span.setTag("test.status", "fail");
    }

    private AgentSpan getTestModuleSpan(T sessionKey, String moduleName) {
        TestModuleDescriptor<T> testModuleDescriptor = new TestModuleDescriptor<T>(sessionKey, moduleName);
        TestContext testModuleContext = (TestContext)this.testModuleContexts.get(testModuleDescriptor);
        AgentSpan span = testModuleContext.getSpan();
        if (span == null) {
            throw new IllegalStateException("Could not find module span for session key " + sessionKey + " and module name " + moduleName);
        }
        return span;
    }

    @Override
    public void onTestModuleFinish(T sessionKey, String moduleName) {
        TestModuleDescriptor<T> testModuleDescriptor = new TestModuleDescriptor<T>(sessionKey, moduleName);
        TestContext testModuleContext = (TestContext)this.testModuleContexts.remove(testModuleDescriptor);
        AgentSpan span = testModuleContext.getSpan();
        if (span == null) {
            throw new IllegalStateException("Could not find module span for session key " + sessionKey + " and module name " + moduleName);
        }
        span.setTag("test_module_id", testModuleContext.getId());
        SessionContext sessionContext = (SessionContext)this.testSessionContexts.get(sessionKey);
        span.setTag("test_session_id", sessionContext.context.getId());
        sessionContext.context.reportChildStatus(testModuleContext.getStatus());
        sessionContext.decorator.beforeFinish(span);
        span.finish();
    }

    private static final class SessionContext {
        private final TestContext context;
        private final TestDecorator decorator;

        private SessionContext(TestContext context, TestDecorator decorator) {
            this.context = context;
            this.decorator = decorator;
        }
    }
}

