/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.events.impl;

import datadog.trace.api.Config;
import datadog.trace.api.DisableTestTrace;
import ddtrot.dd.trace.api.civisibility.decorator.TestDecorator;
import ddtrot.dd.trace.api.civisibility.events.TestEventsHandler;
import ddtrot.dd.trace.api.civisibility.events.impl.ParentProcessTestContext;
import ddtrot.dd.trace.api.civisibility.events.impl.SpanTestContext;
import ddtrot.dd.trace.api.civisibility.events.impl.TestContext;
import ddtrot.dd.trace.api.civisibility.events.impl.TestSuiteDescriptor;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.util.Strings;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEventsHandlerImpl
implements TestEventsHandler {
    private static final Logger log = LoggerFactory.getLogger(TestEventsHandlerImpl.class);
    private volatile TestContext testModuleContext;
    private final ConcurrentMap<TestSuiteDescriptor, Integer> testSuiteNestedCallCounters = new ConcurrentHashMap<TestSuiteDescriptor, Integer>();
    private final ConcurrentMap<TestSuiteDescriptor, TestContext> testSuiteContexts = new ConcurrentHashMap<TestSuiteDescriptor, TestContext>();
    private final TestDecorator testDecorator;

    public TestEventsHandlerImpl(TestDecorator testDecorator) {
        this.testDecorator = testDecorator;
        Config config = Config.get();
        Long sessionId = config.getCiVisibilitySessionId();
        Long moduleId = config.getCiVisibilityModuleId();
        if (sessionId != null && moduleId != null) {
            this.testModuleContext = new ParentProcessTestContext(sessionId, moduleId);
        }
    }

    @Override
    public void onTestModuleStart(@Nullable String version) {
        String systemProp;
        Long moduleId;
        String systemProp2;
        Long sessionId = Config.get().getCiVisibilitySessionId();
        if (sessionId == null && (systemProp2 = System.getProperty(Strings.propertyNameToSystemPropertyName("civisibility.session.id"))) != null) {
            sessionId = Long.parseLong(systemProp2);
        }
        if ((moduleId = Config.get().getCiVisibilityModuleId()) == null && (systemProp = System.getProperty(Strings.propertyNameToSystemPropertyName("civisibility.module.id"))) != null) {
            moduleId = Long.parseLong(systemProp);
        }
        if (sessionId != null && moduleId != null) {
            this.testModuleContext = new ParentProcessTestContext(sessionId, moduleId);
        } else {
            AgentSpan span = AgentTracer.startSpan(this.testDecorator.component() + ".test_module");
            this.testModuleContext = new SpanTestContext(span);
            this.testDecorator.afterTestModuleStart(span, null, version, null);
        }
    }

    @Override
    public void onTestModuleFinish() {
        if (!this.testModuleContext.isLocalToCurrentProcess()) {
            return;
        }
        AgentSpan span = this.testModuleContext.getSpan();
        if (span == null) {
            throw new IllegalStateException("Test module context is local to current process, but has no span: " + this.testModuleContext);
        }
        span.setTag("test.status", this.testModuleContext.getStatus());
        span.setTag("test_module_id", this.testModuleContext.getId());
        span.setTag("test_session_id", this.testModuleContext.getParentId());
        this.testDecorator.beforeFinish(span);
        span.finish();
    }

    @Override
    public void onTestSuiteStart(String testSuiteName, @Nullable Class<?> testClass, @Nullable String version, @Nullable Collection<String> categories) {
        if (TestEventsHandlerImpl.skipTrace(testClass)) {
            return;
        }
        if (!this.tryTestSuiteStart(testSuiteName, testClass)) {
            return;
        }
        AgentSpan moduleSpan = this.testModuleContext.getSpan();
        AgentSpan.Context moduleSpanContext = moduleSpan != null ? moduleSpan.context() : null;
        AgentSpan span = AgentTracer.startSpan((CharSequence)(this.testDecorator.component() + ".test_suite"), moduleSpanContext);
        AgentScope scope = AgentTracer.activateSpan(span);
        scope.setAsyncPropagation(true);
        TestSuiteDescriptor testSuiteDescriptor = new TestSuiteDescriptor(testSuiteName, testClass);
        this.testSuiteContexts.put(testSuiteDescriptor, new SpanTestContext(span));
        this.testDecorator.afterTestSuiteStart(span, testSuiteName, testClass, version, categories);
    }

    @Override
    public void onTestSuiteFinish(String testSuiteName, @Nullable Class<?> testClass) {
        if (TestEventsHandlerImpl.skipTrace(testClass)) {
            return;
        }
        if (!this.tryTestSuiteFinish(testSuiteName, testClass)) {
            return;
        }
        AgentSpan span = AgentTracer.activeSpan();
        if (!TestEventsHandlerImpl.isTestSuiteSpan(AgentTracer.activeSpan())) {
            return;
        }
        AgentScope scope = AgentTracer.activeScope();
        if (scope != null) {
            scope.close();
        }
        TestSuiteDescriptor testSuiteDescriptor = new TestSuiteDescriptor(testSuiteName, testClass);
        TestContext testSuiteContext = (TestContext)this.testSuiteContexts.remove(testSuiteDescriptor);
        span.setTag("test.status", testSuiteContext.getStatus());
        this.testModuleContext.reportChildStatus(testSuiteContext.getStatus());
        span.setTag("test_suite_id", testSuiteContext.getId());
        span.setTag("test_module_id", this.testModuleContext.getId());
        span.setTag("test_session_id", this.testModuleContext.getParentId());
        this.testDecorator.beforeFinish(span);
        span.finish();
    }

    private boolean tryTestSuiteStart(String testSuiteName, Class<?> testClass) {
        if (this.testModuleContext == null) {
            return false;
        }
        TestSuiteDescriptor testSuiteDescriptor = new TestSuiteDescriptor(testSuiteName, testClass);
        Integer counter = this.testSuiteNestedCallCounters.merge(testSuiteDescriptor, 1, Integer::sum);
        return counter == 1;
    }

    private boolean tryTestSuiteFinish(String testSuiteName, Class<?> testClass) {
        TestSuiteDescriptor testSuiteDescriptor = new TestSuiteDescriptor(testSuiteName, testClass);
        Integer counter = this.testSuiteNestedCallCounters.merge(testSuiteDescriptor, -1, (a, b) -> a + b > 0 ? Integer.valueOf(a + b) : null);
        return counter == null;
    }

    @Override
    public void onSkip(@Nullable String reason) {
        AgentSpan span = AgentTracer.activeSpan();
        if (!TestEventsHandlerImpl.isTestSuiteSpan(span) && !TestEventsHandlerImpl.isTestSpan(span)) {
            return;
        }
        span.setTag("test.status", "skip");
        if (reason != null) {
            span.setTag("test.skip_reason", reason);
        }
    }

    @Override
    public void onFailure(@Nullable Throwable throwable) {
        if (throwable == null) {
            return;
        }
        AgentSpan span = AgentTracer.activeSpan();
        if (!TestEventsHandlerImpl.isTestSuiteSpan(span) && !TestEventsHandlerImpl.isTestSpan(span)) {
            return;
        }
        span.setError(true);
        span.addThrowable(throwable);
        span.setTag("test.status", "fail");
    }

    @Override
    public void onTestStart(String testSuiteName, String testName, @Nullable String testParameters, @Nullable Collection<String> categories, @Nullable String version, @Nullable Class<?> testClass, @Nullable Method testMethod) {
        if (TestEventsHandlerImpl.skipTrace(testClass)) {
            return;
        }
        if (TestEventsHandlerImpl.isTestSpan(AgentTracer.activeSpan())) {
            return;
        }
        AgentSpan span = AgentTracer.startSpan((CharSequence)(this.testDecorator.component() + ".test"), null);
        AgentScope scope = AgentTracer.activateSpan(span);
        scope.setAsyncPropagation(true);
        this.testDecorator.afterTestStart(span, testSuiteName, testName, testParameters, version, testClass, testMethod, categories);
        span.setTag("test.status", "pass");
    }

    @Override
    public void onTestFinish(String testSuiteName, Class<?> testClass) {
        if (TestEventsHandlerImpl.skipTrace(testClass)) {
            return;
        }
        AgentSpan span = AgentTracer.activeSpan();
        if (!TestEventsHandlerImpl.isTestSpan(span)) {
            return;
        }
        AgentScope scope = AgentTracer.activeScope();
        if (scope != null) {
            scope.close();
        }
        this.beforeTestFinish(testSuiteName, testClass, span);
        this.testDecorator.beforeFinish(span);
        span.finish();
    }

    private void beforeTestFinish(String testSuiteName, Class<?> testClass, AgentSpan span) {
        TestSuiteDescriptor testSuiteDescriptor = new TestSuiteDescriptor(testSuiteName, testClass);
        TestContext testSuiteContext = (TestContext)this.testSuiteContexts.get(testSuiteDescriptor);
        if (testSuiteContext != null) {
            span.setTag("test_suite_id", testSuiteContext.getId());
            span.setTag("test_module_id", this.testModuleContext.getId());
            span.setTag("test_session_id", this.testModuleContext.getParentId());
            String testCaseStatus = (String)span.getTag("test.status");
            testSuiteContext.reportChildStatus(testCaseStatus);
        } else {
            log.debug("Could not find test suite for name {} and class {}", (Object)testSuiteName, testClass);
        }
    }

    @Override
    public void onTestIgnore(String testSuiteName, String testName, @Nullable String testParameters, @Nullable List<String> categories, @Nullable String version, @Nullable Class<?> testClass, @Nullable Method testMethod, @Nullable String reason) {
        if (TestEventsHandlerImpl.skipTrace(testClass)) {
            return;
        }
        AgentSpan span = AgentTracer.startSpan((CharSequence)"junit.test", null);
        AgentScope scope = AgentTracer.activateSpan(span);
        this.testDecorator.afterTestStart(span, testSuiteName, testName, testParameters, version, testClass, testMethod, categories);
        this.onSkip(reason);
        this.beforeTestFinish(testSuiteName, testClass, span);
        this.testDecorator.beforeFinish(span);
        scope.close();
        span.finishWithDuration(1L);
    }

    @Override
    public boolean isTestSuiteInProgress() {
        return TestEventsHandlerImpl.isTestSuiteSpan(AgentTracer.activeSpan());
    }

    private static boolean isTestSuiteSpan(AgentSpan activeSpan) {
        return activeSpan != null && "test_suite_end".equals(activeSpan.getSpanType()) && "test".equals(activeSpan.getTag("test.type"));
    }

    private static boolean isTestSpan(AgentSpan activeSpan) {
        return activeSpan != null && "test".equals(activeSpan.getSpanType()) && "test".equals(activeSpan.getTag("test.type"));
    }

    private static boolean skipTrace(Class<?> testClass) {
        return testClass != null && testClass.getAnnotation(DisableTestTrace.class) != null;
    }
}

