/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.util.CollectionUtils;
import java.util.Collections;
import java.util.Map;

public final class DynamicConfig {
    private volatile State currentState;

    private DynamicConfig() {
    }

    public static Builder create() {
        return new DynamicConfig().prepare();
    }

    public TraceConfig captureTraceConfig() {
        return this.currentState;
    }

    public Builder prepare() {
        return new Builder(this.currentState);
    }

    static final class State
    implements TraceConfig {
        final Map<String, String> serviceMapping;

        State(Builder builder) {
            this.serviceMapping = builder.serviceMapping;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return this.serviceMapping;
        }
    }

    public final class Builder {
        Map<String, String> serviceMapping;

        Builder(State state) {
            this.serviceMapping = null == state ? Collections.emptyMap() : state.serviceMapping;
        }

        public Builder setServiceMapping(Map<String, String> serviceMapping) {
            this.serviceMapping = CollectionUtils.tryMakeImmutableMap(serviceMapping);
            return this;
        }

        public DynamicConfig apply() {
            DynamicConfig.this.currentState = new State(this);
            return DynamicConfig.this;
        }
    }
}

