/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class WafMetricCollector {
    public static final WafMetricCollector INSTANCE = new WafMetricCollector();
    private static final String NAMESPACE = "appsec";
    private static final BlockingQueue<WafMetric> rawMetricsQueue = new ArrayBlockingQueue<WafMetric>(1024);
    private static final AtomicInteger wafInitCounter = new AtomicInteger();
    private static final AtomicInteger wafUpdatesCounter = new AtomicInteger();
    private static final AtomicRequestCounter wafRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafTriggeredRequestCounter = new AtomicRequestCounter();
    private static final AtomicRequestCounter wafBlockedRequestCounter = new AtomicRequestCounter();
    private static String wafVersion = "";
    private static String rulesVersion = "";

    public static WafMetricCollector get() {
        return INSTANCE;
    }

    public void wafInit(String wafVersion, String rulesVersion) {
        WafMetricCollector.wafVersion = wafVersion;
        WafMetricCollector.rulesVersion = rulesVersion;
        rawMetricsQueue.offer(new WafInitRawMetric(wafInitCounter.incrementAndGet(), wafVersion, rulesVersion));
    }

    public void wafUpdates(String rulesVersion) {
        rawMetricsQueue.offer(new WafUpdatesRawMetric(wafUpdatesCounter.incrementAndGet(), wafVersion, rulesVersion));
        if (rulesVersion != null && WafMetricCollector.rulesVersion != null && !rulesVersion.equals(WafMetricCollector.rulesVersion)) {
            WafMetricCollector.get().prepareRequestMetrics();
        }
        WafMetricCollector.rulesVersion = rulesVersion;
    }

    public void wafRequest() {
        wafRequestCounter.increment();
    }

    public void wafRequestTriggered() {
        wafTriggeredRequestCounter.increment();
    }

    public void wafRequestBlocked() {
        wafBlockedRequestCounter.increment();
    }

    public Collection<WafMetric> drain() {
        LinkedList<WafMetric> list;
        int drained;
        if (!rawMetricsQueue.isEmpty() && (drained = rawMetricsQueue.drainTo(list = new LinkedList<WafMetric>())) > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    public void prepareRequestMetrics() {
        if (wafRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafRequestCounter.getAndReset(), wafVersion, rulesVersion, false, false))) {
            return;
        }
        if (wafTriggeredRequestCounter.get() > 0L && !rawMetricsQueue.offer(new WafRequestsRawMetric(wafTriggeredRequestCounter.getAndReset(), wafVersion, rulesVersion, true, false))) {
            return;
        }
        if (wafBlockedRequestCounter.get() > 0L) {
            rawMetricsQueue.offer(new WafRequestsRawMetric(wafBlockedRequestCounter.getAndReset(), wafVersion, rulesVersion, true, true));
        }
    }

    public static class AtomicRequestCounter {
        private final AtomicLong atomicLong = new AtomicLong();
        private volatile long timestamp;

        public final long get() {
            return this.atomicLong.get();
        }

        public final long getAndReset() {
            this.timestamp = 0L;
            return this.atomicLong.getAndSet(0L);
        }

        public final void increment() {
            if (this.timestamp == 0L) {
                this.timestamp = System.currentTimeMillis();
            }
            this.atomicLong.incrementAndGet();
        }
    }

    public static class WafRequestsRawMetric
    extends WafMetric {
        public WafRequestsRawMetric(long counter, String wafVersion, String rulesVersion, boolean triggered, boolean blocked) {
            super("waf.requests", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion, "rule_triggered:" + triggered, "request_blocked:" + blocked);
        }
    }

    public static class WafUpdatesRawMetric
    extends WafMetric {
        public WafUpdatesRawMetric(long counter, String wafVersion, String rulesVersion) {
            super("waf.updates", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion);
        }
    }

    public static class WafInitRawMetric
    extends WafMetric {
        public WafInitRawMetric(long counter, String wafVersion, String rulesVersion) {
            super("waf.init", counter, "waf_version:" + wafVersion, "event_rules_version:" + rulesVersion);
        }
    }

    public static abstract class WafMetric {
        public final String metricName;
        public final long timestamp;
        public final long counter;
        public final String namespace;
        public final List<String> tags;

        public WafMetric(String metricName, long counter, String ... tags) {
            this.metricName = metricName;
            this.timestamp = System.currentTimeMillis() / 1000L;
            this.counter = counter;
            this.namespace = WafMetricCollector.NAMESPACE;
            this.tags = Arrays.asList(tags);
        }
    }
}

