/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.git;

import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.git.CommitInfo;
import ddtrot.dd.trace.api.git.EmbeddedGitInfoBuilder;
import ddtrot.dd.trace.api.git.GitInfo;
import ddtrot.dd.trace.api.git.GitInfoBuilder;
import ddtrot.dd.trace.api.git.GitUtils;
import ddtrot.dd.trace.api.git.PersonInfo;
import ddtrot.dd.trace.api.git.UserSuppliedGitInfoBuilder;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GitInfoProvider {
    public static final GitInfoProvider INSTANCE = new GitInfoProvider();
    private final Collection<GitInfoBuilder> builders = new CopyOnWriteArrayList<GitInfoBuilder>();
    private final DDCache<String, GitInfo> gitInfoCache = DDCaches.newFixedSizeCache(4);

    public GitInfo getGitInfo() {
        return this.getGitInfo(null);
    }

    public GitInfo getGitInfo(@Nullable String repositoryPath) {
        if (repositoryPath == null) {
            repositoryPath = Paths.get("", new String[0]).toAbsolutePath().toString();
        }
        return this.gitInfoCache.computeIfAbsent(repositoryPath, this::buildGitInfo);
    }

    private GitInfo buildGitInfo(String repositoryPath) {
        List<GitInfo> infos = this.builders.stream().map(builder -> builder.build(repositoryPath)).collect(Collectors.toList());
        String commitSha = GitInfoProvider.firstNonNull(infos, gi -> gi.getCommit().getSha());
        return new GitInfo(GitInfoProvider.firstNonNull(infos, gi -> GitUtils.filterSensitiveInfo(gi.getRepositoryURL())), GitInfoProvider.firstNonNull(infos, GitInfo::getBranch), GitInfoProvider.firstNonNull(infos, GitInfo::getTag), new CommitInfo(commitSha, new PersonInfo(GitInfoProvider.firstNonNullWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getAuthor().getName()), GitInfoProvider.firstNonNullWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getAuthor().getEmail()), GitInfoProvider.firstNonNullWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getAuthor().getIso8601Date())), new PersonInfo(GitInfoProvider.firstNonNullWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getCommitter().getName()), GitInfoProvider.firstNonNullWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getCommitter().getEmail()), GitInfoProvider.firstNonNullWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getCommitter().getIso8601Date())), GitInfoProvider.firstNonNullWithMatchingCommit(infos, commitSha, gi -> gi.getCommit().getFullMessage())));
    }

    private static String firstNonNull(Iterable<GitInfo> gitInfos, Function<GitInfo, String> function) {
        for (GitInfo gitInfo : gitInfos) {
            String result = function.apply(gitInfo);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static String firstNonNullWithMatchingCommit(Iterable<GitInfo> gitInfos, String commitSha, Function<GitInfo, String> function) {
        for (GitInfo gitInfo : gitInfos) {
            String result;
            if (commitSha != null && !commitSha.equalsIgnoreCase(gitInfo.getCommit().getSha()) || (result = function.apply(gitInfo)) == null) continue;
            return result;
        }
        return null;
    }

    public void registerGitInfoBuilder(GitInfoBuilder builder) {
        this.builders.add(builder);
        this.gitInfoCache.clear();
    }

    static {
        INSTANCE.registerGitInfoBuilder(new UserSuppliedGitInfoBuilder());
        INSTANCE.registerGitInfoBuilder(new EmbeddedGitInfoBuilder());
    }
}

