/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.util.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DynamicConfig {
    private volatile State currentState;

    private DynamicConfig() {
    }

    public static Builder create() {
        return new DynamicConfig().prepare();
    }

    public TraceConfig captureTraceConfig() {
        return this.currentState;
    }

    public Builder prepare() {
        return new Builder(this.currentState);
    }

    static final class State
    implements TraceConfig {
        final Map<String, String> serviceMapping;
        final Map<String, String> taggedHeaders;
        final Map<String, String> baggageMapping;

        State(Builder builder) {
            this.serviceMapping = builder.serviceMapping;
            this.taggedHeaders = builder.taggedHeaders;
            this.baggageMapping = builder.baggageMapping;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return this.serviceMapping;
        }

        @Override
        public Map<String, String> getTaggedHeaders() {
            return this.taggedHeaders;
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return this.baggageMapping;
        }
    }

    public final class Builder {
        Map<String, String> serviceMapping;
        Map<String, String> taggedHeaders;
        Map<String, String> baggageMapping;

        Builder(State state) {
            if (null == state) {
                this.serviceMapping = Collections.emptyMap();
                this.taggedHeaders = Collections.emptyMap();
                this.baggageMapping = Collections.emptyMap();
            } else {
                this.serviceMapping = state.serviceMapping;
                this.taggedHeaders = state.taggedHeaders;
                this.baggageMapping = state.baggageMapping;
            }
        }

        public Builder setServiceMapping(Map<String, String> serviceMapping) {
            this.serviceMapping = this.cleanMapping(serviceMapping, false, false);
            return this;
        }

        public Builder setTaggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = this.cleanMapping(taggedHeaders, true, true);
            return this;
        }

        public Builder setBaggageMapping(Map<String, String> baggageMapping) {
            this.baggageMapping = this.cleanMapping(baggageMapping, true, false);
            return this;
        }

        private Map<String, String> cleanMapping(Map<String, String> mapping, boolean lowerCaseKeys, boolean lowerCaseValues) {
            HashMap<String, String> cleanedMapping = new HashMap<String, String>(mapping.size() * 4 / 3);
            for (Map.Entry<String, String> association : mapping.entrySet()) {
                String key = association.getKey().trim();
                if (lowerCaseKeys) {
                    key = key.toLowerCase();
                }
                String value = association.getValue().trim();
                if (lowerCaseValues) {
                    value = value.toLowerCase();
                }
                cleanedMapping.put(key, value);
            }
            return CollectionUtils.tryMakeImmutableMap(cleanedMapping);
        }

        public DynamicConfig apply() {
            DynamicConfig.this.currentState = new State(this);
            return DynamicConfig.this;
        }
    }
}

