/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.dd.trace.common.sampling.RateSampler;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.util.GlobPattern;
import ddtrot.dd.trace.core.util.SimpleRateLimiter;
import java.util.regex.Pattern;

public abstract class SamplingRule {
    private final RateSampler sampler;

    public SamplingRule(RateSampler sampler) {
        this.sampler = sampler;
    }

    public abstract <T extends CoreSpan<T>> boolean matches(T var1);

    public <T extends CoreSpan<T>> boolean sample(T span) {
        return this.sampler.sample(span);
    }

    public RateSampler getSampler() {
        return this.sampler;
    }

    public static final class SpanSamplingRule
    extends SamplingRule {
        private final String serviceExactName;
        private final Pattern servicePattern;
        private final String operationExactName;
        private final Pattern operationPattern;
        private final SimpleRateLimiter rateLimiter;

        public SpanSamplingRule(String serviceName, String operationName, RateSampler sampler, SimpleRateLimiter rateLimiter) {
            super(sampler);
            if (serviceName == null || "*".equals(serviceName)) {
                this.serviceExactName = null;
                this.servicePattern = null;
            } else if (this.isExactMatcher(serviceName)) {
                this.serviceExactName = serviceName;
                this.servicePattern = null;
            } else {
                this.serviceExactName = null;
                this.servicePattern = GlobPattern.globToRegexPattern(serviceName);
            }
            if (operationName == null || "*".equals(operationName)) {
                this.operationExactName = null;
                this.operationPattern = null;
            } else if (this.isExactMatcher(operationName)) {
                this.operationExactName = operationName;
                this.operationPattern = null;
            } else {
                this.operationExactName = null;
                this.operationPattern = GlobPattern.globToRegexPattern(operationName);
            }
            this.rateLimiter = rateLimiter;
        }

        private boolean isExactMatcher(String serviceNameGlob) {
            return !serviceNameGlob.contains("*") && !serviceNameGlob.contains("?");
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            return !(this.serviceExactName != null && !this.serviceExactName.equals(span.getServiceName()) || this.servicePattern != null && !this.servicePattern.matcher(span.getServiceName()).matches() || this.operationExactName != null && !this.operationExactName.contentEquals(span.getOperationName()) || this.operationPattern != null && !this.operationPattern.matcher(span.getOperationName()).matches());
        }

        @Override
        public <T extends CoreSpan<T>> boolean sample(T span) {
            return super.sample(span) && (this.rateLimiter == null || this.rateLimiter.tryAcquire());
        }

        public SimpleRateLimiter getRateLimiter() {
            return this.rateLimiter;
        }
    }

    public static final class TraceSamplingRule
    extends SamplingRule {
        private final String serviceName;
        private final String operationName;

        public TraceSamplingRule(String exactServiceName, String exactOperationName, RateSampler sampler) {
            super(sampler);
            this.serviceName = exactServiceName;
            this.operationName = exactOperationName;
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            return !(this.serviceName != null && !this.serviceName.equals(span.getServiceName()) || this.operationName != null && !this.operationName.contentEquals(span.getOperationName()));
        }
    }

    public static class OperationSamplingRule
    extends PatternMatchSamplingRule {
        public OperationSamplingRule(String regex, RateSampler sampler) {
            super(regex, sampler);
        }

        @Override
        protected <T extends CoreSpan<T>> CharSequence getRelevantString(T span) {
            return span.getOperationName();
        }
    }

    public static class ServiceSamplingRule
    extends PatternMatchSamplingRule {
        public ServiceSamplingRule(String regex, RateSampler sampler) {
            super(regex, sampler);
        }

        @Override
        protected <T extends CoreSpan<T>> String getRelevantString(T span) {
            return span.getServiceName();
        }
    }

    public static abstract class PatternMatchSamplingRule
    extends SamplingRule {
        private final Pattern pattern;

        public PatternMatchSamplingRule(String regex, RateSampler sampler) {
            super(sampler);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            CharSequence relevantString = this.getRelevantString(span);
            return relevantString != null && this.pattern.matcher(relevantString).matches();
        }

        protected abstract <T extends CoreSpan<T>> CharSequence getRelevantString(T var1);
    }

    public static class AlwaysMatchesSamplingRule
    extends SamplingRule {
        public AlwaysMatchesSamplingRule(RateSampler sampler) {
            super(sampler);
        }

        @Override
        public <T extends CoreSpan<T>> boolean matches(T span) {
            return true;
        }
    }
}

