/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import datadog.trace.api.Config;
import datadog.trace.api.WellKnownTags;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.Backlog;
import ddtrot.dd.trace.bootstrap.instrumentation.api.DataStreamsMonitoring;
import ddtrot.dd.trace.bootstrap.instrumentation.api.InboxItem;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.StatsPoint;
import ddtrot.dd.trace.common.metrics.EventListener;
import ddtrot.dd.trace.common.metrics.OkHttpSink;
import ddtrot.dd.trace.common.metrics.Sink;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.core.datastreams.DatastreamsPayloadWriter;
import ddtrot.dd.trace.core.datastreams.DefaultPathwayContext;
import ddtrot.dd.trace.core.datastreams.MsgPackDatastreamsPayloadWriter;
import ddtrot.dd.trace.core.datastreams.StatsBucket;
import ddtrot.dd.trace.core.datastreams.TagsProcessor;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.org.jctools.queues.MpscBlockingConsumerArrayQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStreamsMonitoring
implements DataStreamsMonitoring,
AutoCloseable,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataStreamsMonitoring.class);
    static final long DEFAULT_BUCKET_DURATION_NANOS = TimeUnit.SECONDS.toNanos(10L);
    static final long FEATURE_CHECK_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(5L);
    private static final StatsPoint REPORT = new StatsPoint(Collections.emptyList(), 0L, 0L, 0L, 0L, 0L);
    private static final StatsPoint POISON_PILL = new StatsPoint(Collections.emptyList(), 0L, 0L, 0L, 0L, 0L);
    private final Map<Long, StatsBucket> timeToBucket = new HashMap<Long, StatsBucket>();
    private final BlockingQueue<InboxItem> inbox = new MpscBlockingConsumerArrayQueue<InboxItem>(1024);
    private final DatastreamsPayloadWriter payloadWriter;
    private final DDAgentFeaturesDiscovery features;
    private final TimeSource timeSource;
    private final WellKnownTags wellKnownTags;
    private final long bucketDurationNanos;
    private final Thread thread;
    private AgentTaskScheduler.Scheduled<DefaultDataStreamsMonitoring> cancellation;
    private volatile long nextFeatureCheck;
    private volatile boolean supportsDataStreams = false;

    public DefaultDataStreamsMonitoring(Config config, SharedCommunicationObjects sharedCommunicationObjects, TimeSource timeSource) {
        this(new OkHttpSink(sharedCommunicationObjects.okHttpClient, sharedCommunicationObjects.agentUrl.toString(), "v0.1/pipeline_stats", false, true, Collections.emptyMap()), sharedCommunicationObjects.featuresDiscovery(config), timeSource, config);
    }

    public DefaultDataStreamsMonitoring(Sink sink, DDAgentFeaturesDiscovery features, TimeSource timeSource, Config config) {
        this(sink, features, timeSource, config.getWellKnownTags(), new MsgPackDatastreamsPayloadWriter(sink, config.getWellKnownTags(), DDTraceCoreInfo.VERSION, config.getPrimaryTag()), DEFAULT_BUCKET_DURATION_NANOS);
    }

    public DefaultDataStreamsMonitoring(Sink sink, DDAgentFeaturesDiscovery features, TimeSource timeSource, WellKnownTags wellKnownTags, DatastreamsPayloadWriter payloadWriter, long bucketDurationNanos) {
        this.features = features;
        this.timeSource = timeSource;
        this.wellKnownTags = wellKnownTags;
        this.payloadWriter = payloadWriter;
        this.bucketDurationNanos = bucketDurationNanos;
        this.thread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.DATA_STREAMS_MONITORING, new InboxProcessor());
        sink.register(this);
    }

    @Override
    public void start() {
        if (this.features.getDataStreamsEndpoint() == null) {
            this.features.discoverIfOutdated();
        }
        if (this.features.supportsDataStreams()) {
            this.supportsDataStreams = true;
        } else {
            this.supportsDataStreams = false;
            log.debug("Data streams is disabled or not supported by agent");
        }
        this.nextFeatureCheck = this.timeSource.getCurrentTimeNanos() + FEATURE_CHECK_INTERVAL_NANOS;
        this.cancellation = AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(new ReportTask(), this, this.bucketDurationNanos, this.bucketDurationNanos, TimeUnit.NANOSECONDS);
        this.thread.start();
    }

    @Override
    public void accept(StatsPoint statsPoint) {
        if (this.thread.isAlive()) {
            this.inbox.offer(statsPoint);
        }
    }

    @Override
    public PathwayContext newPathwayContext() {
        return new DefaultPathwayContext(this.timeSource, this.wellKnownTags);
    }

    @Override
    public <C> PathwayContext extractBinaryPathwayContext(C carrier, AgentPropagation.BinaryContextVisitor<C> getter) {
        return DefaultPathwayContext.extractBinary(carrier, getter, this.timeSource, this.wellKnownTags);
    }

    @Override
    public <C> PathwayContext extractPathwayContext(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        return DefaultPathwayContext.extract(carrier, getter, this.timeSource, this.wellKnownTags);
    }

    @Override
    public void trackBacklog(LinkedHashMap<String, String> sortedTags, long value) {
        ArrayList<String> tags = new ArrayList<String>(sortedTags.size());
        for (Map.Entry<String, String> entry : sortedTags.entrySet()) {
            String tag = TagsProcessor.createTag(entry.getKey(), entry.getValue());
            if (tag == null) continue;
            tags.add(tag);
        }
        this.inbox.offer(new Backlog(tags, value, this.timeSource.getCurrentTimeNanos()));
    }

    @Override
    public void close() {
        if (null != this.cancellation) {
            this.cancellation.cancel();
        }
        this.inbox.offer(POISON_PILL);
        try {
            this.thread.join(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.inbox.clear();
    }

    private long currentBucket(long timestampNanos) {
        return timestampNanos - timestampNanos % this.bucketDurationNanos;
    }

    private void flush(long timestampNanos) {
        long currentBucket = this.currentBucket(timestampNanos);
        ArrayList<StatsBucket> includedBuckets = new ArrayList<StatsBucket>();
        Iterator<Map.Entry<Long, StatsBucket>> mapIterator = this.timeToBucket.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry<Long, StatsBucket> entry = mapIterator.next();
            if (entry.getKey() >= currentBucket) continue;
            mapIterator.remove();
            includedBuckets.add(entry.getValue());
        }
        if (!includedBuckets.isEmpty()) {
            log.debug("Flushing {} buckets", (Object)includedBuckets.size());
            this.payloadWriter.writePayload(includedBuckets);
        }
    }

    @Override
    public void clear() {
        this.timeToBucket.clear();
    }

    void report() {
        this.inbox.offer(REPORT);
    }

    @Override
    public void onEvent(EventListener.EventType eventType, String message) {
        switch (eventType) {
            case DOWNGRADED: {
                log.debug("Agent downgrade was detected");
                this.checkFeatures();
                break;
            }
            case BAD_PAYLOAD: {
                log.debug("bad metrics payload sent to trace agent: {}", (Object)message);
                break;
            }
            case ERROR: {
                log.debug("trace agent errored receiving metrics payload: {}", (Object)message);
                break;
            }
        }
    }

    private void checkFeatures() {
        boolean oldValue = this.supportsDataStreams;
        this.features.discoverIfOutdated();
        this.supportsDataStreams = this.features.supportsDataStreams();
        if (oldValue && !this.supportsDataStreams) {
            log.info("Disabling data streams reporting because it is not supported by the agent");
        } else if (!oldValue && this.supportsDataStreams) {
            log.info("Agent upgrade detected. Enabling data streams because it is now supported");
        }
        this.nextFeatureCheck = this.timeSource.getCurrentTimeNanos() + FEATURE_CHECK_INTERVAL_NANOS;
    }

    private static final class ReportTask
    implements AgentTaskScheduler.Task<DefaultDataStreamsMonitoring> {
        private ReportTask() {
        }

        @Override
        public void run(DefaultDataStreamsMonitoring target) {
            target.report();
        }
    }

    private class InboxProcessor
    implements Runnable {
        private InboxProcessor() {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    StatsBucket statsBucket;
                    Long bucket;
                    InboxItem payload = (InboxItem)DefaultDataStreamsMonitoring.this.inbox.take();
                    if (payload == REPORT) {
                        if (DefaultDataStreamsMonitoring.this.supportsDataStreams) {
                            DefaultDataStreamsMonitoring.this.flush(DefaultDataStreamsMonitoring.this.timeSource.getCurrentTimeNanos());
                            continue;
                        }
                        if (DefaultDataStreamsMonitoring.this.timeSource.getCurrentTimeNanos() < DefaultDataStreamsMonitoring.this.nextFeatureCheck) continue;
                        DefaultDataStreamsMonitoring.this.checkFeatures();
                        continue;
                    }
                    if (payload == POISON_PILL) {
                        if (!DefaultDataStreamsMonitoring.this.supportsDataStreams) break;
                        DefaultDataStreamsMonitoring.this.flush(Long.MAX_VALUE);
                        break;
                    }
                    if (!DefaultDataStreamsMonitoring.this.supportsDataStreams) continue;
                    if (payload instanceof StatsPoint) {
                        StatsPoint statsPoint = (StatsPoint)payload;
                        bucket = DefaultDataStreamsMonitoring.this.currentBucket(statsPoint.getTimestampNanos());
                        statsBucket = DefaultDataStreamsMonitoring.this.timeToBucket.computeIfAbsent(bucket, startTime -> new StatsBucket((long)startTime, DefaultDataStreamsMonitoring.this.bucketDurationNanos));
                        statsBucket.addPoint(statsPoint);
                        continue;
                    }
                    if (!(payload instanceof Backlog)) continue;
                    Backlog backlog = (Backlog)payload;
                    bucket = DefaultDataStreamsMonitoring.this.currentBucket(backlog.getTimestampNanos());
                    statsBucket = DefaultDataStreamsMonitoring.this.timeToBucket.computeIfAbsent(bucket, startTime -> new StatsBucket((long)startTime, DefaultDataStreamsMonitoring.this.bucketDurationNanos));
                    statsBucket.addBacklog(backlog);
                }
                catch (InterruptedException e) {
                    currentThread.interrupt();
                }
                catch (Exception e) {
                    log.debug("Error monitoring data streams", (Throwable)e);
                }
            }
        }
    }
}

