/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.lambda;

import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.com.squareup.moshi.JsonWriter;
import ddtrot.com.squareup.moshi.Moshi;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SkipAbstractTypeJsonSerializer<T>
extends JsonAdapter<T> {
    private final JsonAdapter<T> delegate;
    private static final HashSet<String> allowedCanonicalNames = Stream.of("java.util.List", "java.util.Map", "java.util.Set", "java.util.Collection", "java.lang.Object", "java.lang.Integer", "java.lang.Double", "java.lang.Long", "java.lang.Short", "java.lang.Float", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.String", "int", "double", "long", "short", "float", "boolean", "byte", "char").collect(Collectors.toCollection(HashSet::new));

    private SkipAbstractTypeJsonSerializer(JsonAdapter<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T fromJson(JsonReader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toJson(JsonWriter writer, T value) throws IOException {
        writer.beginObject();
        writer.endObject();
    }

    private static boolean isPlatformClass(String canonicalName) {
        return canonicalName.startsWith("java.") || canonicalName.startsWith("javax.");
    }

    public static <T> JsonAdapter.Factory newFactory() {
        return new JsonAdapter.Factory(){

            @Override
            public JsonAdapter<?> create(Type requestedType, Set<? extends Annotation> annotations, Moshi moshi) {
                if (!(requestedType instanceof Class)) {
                    return null;
                }
                String typeName = ((Class)requestedType).getTypeName();
                if (allowedCanonicalNames.contains(typeName)) {
                    return null;
                }
                boolean isAbstract = Modifier.isAbstract(((Class)requestedType).getModifiers());
                if (isAbstract || SkipAbstractTypeJsonSerializer.isPlatformClass(typeName)) {
                    JsonAdapter delegate = moshi.nextAdapter(this, (Type)((Object)Object.class), annotations);
                    return new SkipAbstractTypeJsonSerializer(delegate);
                }
                return null;
            }
        };
    }
}

