/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import ddtrot.com.datadoghq.sketch.ddsketch.DDSketch;
import ddtrot.dd.trace.core.histogram.Histograms;
import java.util.List;

public class StatsGroup {
    private static final double NANOSECONDS_TO_SECOND = 1.0E9;
    private final List<String> edgeTags;
    private final long hash;
    private final long parentHash;
    private final DDSketch pathwayLatency;
    private final DDSketch edgeLatency;

    public StatsGroup(List<String> edgeTags, long hash, long parentHash) {
        this.edgeTags = edgeTags;
        this.hash = hash;
        this.parentHash = parentHash;
        this.pathwayLatency = Histograms.newHistogram();
        this.edgeLatency = Histograms.newHistogram();
    }

    public void add(long pathwayLatencyNano, long edgeLatencyNano) {
        this.pathwayLatency.accept((double)pathwayLatencyNano / 1.0E9);
        this.edgeLatency.accept((double)edgeLatencyNano / 1.0E9);
    }

    public List<String> getEdgeTags() {
        return this.edgeTags;
    }

    public long getHash() {
        return this.hash;
    }

    public long getParentHash() {
        return this.parentHash;
    }

    public DDSketch getPathwayLatency() {
        return this.pathwayLatency;
    }

    public DDSketch getEdgeLatency() {
        return this.edgeLatency;
    }

    public String toString() {
        return "StatsGroup{edgeTags='" + this.edgeTags + '\'' + ", hash=" + this.hash + ", parentHash=" + this.parentHash + '}';
    }
}

