/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.common.socket;

import ddtrot.dd.common.socket.NamedPipeSocket;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;

public class NamedPipeSocketFactory
extends SocketFactory {
    private static final String NAMED_PIPE_PREFIX = "\\\\.\\pipe\\";
    private static final Map<File, NamedPipeSocket> fileToSocket = new HashMap<File, NamedPipeSocket>();
    private final File pipe;

    public NamedPipeSocketFactory(String pipeName) {
        String pipeNameWithPrefix = pipeName.startsWith(NAMED_PIPE_PREFIX) ? pipeName : NAMED_PIPE_PREFIX + pipeName;
        this.pipe = new File(pipeNameWithPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket createSocket() throws IOException {
        Map<File, NamedPipeSocket> map = fileToSocket;
        synchronized (map) {
            NamedPipeSocket socket = fileToSocket.get(this.pipe);
            if (socket == null || socket.isClosed()) {
                socket = new NamedPipeSocket(this.pipe);
                fileToSocket.put(this.pipe, socket);
            }
            return socket;
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocket();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.createSocket();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.createSocket();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.createSocket();
    }
}

